/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.ipc.impl;

import com.github.jlangch.venice.impl.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class Topics {
    public static final long TOPIC_MAX_LEN = 100L;
    public static final long TOPICS_MAX = 20L;
    private final List<String> topics = new ArrayList<String>();

    private Topics(String topic) {
        this.topics.add(topic);
    }

    private Topics(Collection<String> topics) {
        if (topics instanceof Set) {
            this.topics.addAll(topics);
        } else {
            HashSet<String> distinct = new HashSet<String>(topics);
            this.topics.addAll(distinct.size() == topics.size() ? topics : distinct);
        }
    }

    private Topics(String[] topics) {
        this(Arrays.asList(topics));
    }

    public static Topics of(String topic) {
        Topics.validate(topic);
        return new Topics(topic);
    }

    public static Topics of(Set<String> topics) {
        if (topics == null || topics.isEmpty()) {
            throw new IllegalArgumentException("A least one topic is required!");
        }
        topics.forEach(t -> Topics.validate(t));
        if ((long)topics.size() > 20L) {
            throw new IllegalArgumentException("More than 20specified!");
        }
        return new Topics(topics);
    }

    public static Topics of(String[] topics) {
        if (topics == null || topics.length == 0) {
            throw new IllegalArgumentException("A least one topic is required!");
        }
        for (int ii = 0; ii < topics.length; ++ii) {
            Topics.validate(topics[ii]);
        }
        if ((long)topics.length > 20L) {
            throw new IllegalArgumentException("More than 20specified!");
        }
        return new Topics(topics);
    }

    public String getTopic() {
        return this.topics.get(0);
    }

    public List<String> getTopics() {
        return Collections.unmodifiableList(this.topics);
    }

    public Set<String> getTopicsSet() {
        return Collections.unmodifiableSet(new HashSet<String>(this.topics));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.topics == null ? 0 : this.topics.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Topics other = (Topics)obj;
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public static String encode(Topics topics) {
        Objects.requireNonNull(topics);
        return String.join((CharSequence)",", topics.topics);
    }

    public static Topics decode(String topics) {
        Objects.requireNonNull(topics);
        return Topics.of(topics.split(" *, *"));
    }

    public static void validate(String topic) {
        if (StringUtil.isBlank(topic)) {
            throw new IllegalArgumentException("A topic must not be empty or blank!");
        }
        if ((long)topic.length() > 100L) {
            throw new IllegalArgumentException("A topic is limit to 100characters!");
        }
        if (topic.contains(",")) {
            throw new IllegalArgumentException("A topic must not contain commas!");
        }
        for (char c : topic.toCharArray()) {
            if (!Character.isWhitespace(c)) continue;
            throw new IllegalArgumentException("A topic must not contain white spaces!");
        }
    }
}

