/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.crypt;

import com.github.jlangch.venice.FileException;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.util.crypt.AbstractEncryptor;
import com.github.jlangch.venice.util.crypt.IEncryptor;
import com.github.jlangch.venice.util.crypt.Util;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Objects;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.ChaChaEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class Encryptor_ChaCha20_BouncyCastle
extends AbstractEncryptor
implements IEncryptor {
    private static final boolean supported = Util.hasClass("org.bouncycastle.crypto.engines.ChaChaEngine");
    public static int KEY_ITERATIONS = 3000;
    public static int KEY_LEN = 256;
    public static int IV_LEN = 8;
    public static int ROUNDS = 20;
    public static String SECRET_KEY_FACTORY = "PBKDF2WithHmacSHA256";
    private static byte[] KEY_SALT = new byte[]{69, 26, 121, 103, -70, -6, 13, 94, 3, 113, 68, 47, -61, -91, 110, 79};
    private final byte[] key;

    private Encryptor_ChaCha20_BouncyCastle(byte[] key) {
        Objects.requireNonNull(key);
        this.key = key;
    }

    public static Encryptor_ChaCha20_BouncyCastle create(String passphrase) throws GeneralSecurityException {
        Objects.requireNonNull(passphrase);
        return Encryptor_ChaCha20_BouncyCastle.create(passphrase, KEY_SALT, KEY_ITERATIONS);
    }

    public static Encryptor_ChaCha20_BouncyCastle create(String passphrase, byte[] keySalt, Integer keyIterations) throws GeneralSecurityException {
        Objects.requireNonNull(passphrase);
        byte[] key = Util.deriveKeyFromPassphrase(passphrase, SECRET_KEY_FACTORY, keySalt == null ? KEY_SALT : keySalt, keyIterations == null ? KEY_ITERATIONS : keyIterations, KEY_LEN);
        return new Encryptor_ChaCha20_BouncyCastle(key);
    }

    public static boolean isSupported() {
        return supported;
    }

    @Override
    public byte[] encrypt(byte[] data) {
        Objects.requireNonNull(data);
        try {
            byte[] iv = new byte[IV_LEN];
            new SecureRandom().nextBytes(iv);
            ChaChaEngine chacha = new ChaChaEngine(ROUNDS);
            chacha.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(this.key), iv));
            byte[] outData = new byte[IV_LEN + data.length];
            System.arraycopy(iv, 0, outData, 0, iv.length);
            chacha.processBytes(data, 0, data.length, outData, IV_LEN);
            return outData;
        }
        catch (Exception ex) {
            throw new FileException("Failed to decrypt data", ex);
        }
    }

    @Override
    public byte[] decrypt(byte[] data) {
        Objects.requireNonNull(data);
        try {
            byte[] iv = new byte[IV_LEN];
            System.arraycopy(data, 0, iv, 0, IV_LEN);
            ChaChaEngine chacha = new ChaChaEngine(ROUNDS);
            chacha.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(this.key), iv));
            byte[] outData = new byte[data.length - IV_LEN];
            chacha.processBytes(data, IV_LEN, data.length - IV_LEN, outData, 0);
            return outData;
        }
        catch (Exception ex) {
            throw new FileException("Failed to decrypt data", ex);
        }
    }

    public static boolean hasProvider(String name) {
        return Security.getProvider(StringUtil.trimToEmpty(name)) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addBouncyCastleProvider() {
        Class<Encryptor_ChaCha20_BouncyCastle> clazz = Encryptor_ChaCha20_BouncyCastle.class;
        synchronized (Encryptor_ChaCha20_BouncyCastle.class) {
            if (Security.getProvider("BC") != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return false;
            }
            try {
                Security.addProvider((Provider)Util.classForName("org.bouncycastle.jce.provider.BouncyCastleProvider").getConstructor(new Class[0]).newInstance(new Object[0]));
                // ** MonitorExit[var0] (shouldn't be in output)
                return true;
            }
            catch (Exception ex) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return false;
            }
        }
    }
}

