/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.crypt;

import com.github.jlangch.venice.FileException;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.util.crypt.AbstractEncryptor;
import com.github.jlangch.venice.util.crypt.IEncryptor;
import com.github.jlangch.venice.util.crypt.Util;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Encryptor_AES256_GCM
extends AbstractEncryptor
implements IEncryptor {
    public static int KEY_ITERATIONS = 3000;
    public static int KEY_LEN = 256;
    public static int IV_LEN = 12;
    public static String SECRET_KEY_FACTORY = "PBKDF2WithHmacSHA256";
    private static byte[] KEY_SALT = new byte[]{69, 26, 121, 103, -70, -6, 13, 94, 3, 113, 68, 47, -61, -91, 110, 79};
    private final SecretKeySpec keySpec;
    private final boolean efficientMemUse;

    private Encryptor_AES256_GCM(SecretKeySpec keySpec, boolean efficientMemUse) {
        Objects.requireNonNull(keySpec);
        this.keySpec = keySpec;
        this.efficientMemUse = efficientMemUse;
    }

    public static Encryptor_AES256_GCM create(String passphrase) throws GeneralSecurityException {
        Objects.requireNonNull(passphrase);
        return Encryptor_AES256_GCM.create(passphrase, KEY_SALT, KEY_ITERATIONS, false);
    }

    public static Encryptor_AES256_GCM create(String passphrase, boolean efficientMemUse) throws GeneralSecurityException {
        Objects.requireNonNull(passphrase);
        return Encryptor_AES256_GCM.create(passphrase, KEY_SALT, KEY_ITERATIONS, efficientMemUse);
    }

    public static Encryptor_AES256_GCM create(String passphrase, byte[] keySalt, Integer keyIterations) throws GeneralSecurityException {
        return Encryptor_AES256_GCM.create(passphrase, keySalt, keyIterations, false);
    }

    public static Encryptor_AES256_GCM create(String passphrase, byte[] keySalt, Integer keyIterations, boolean efficientMemUse) throws GeneralSecurityException {
        Objects.requireNonNull(passphrase);
        byte[] key = Util.deriveKeyFromPassphrase(passphrase, SECRET_KEY_FACTORY, keySalt == null ? KEY_SALT : keySalt, keyIterations == null ? KEY_ITERATIONS : keyIterations, KEY_LEN);
        SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
        return new Encryptor_AES256_GCM(keySpec, efficientMemUse);
    }

    public static boolean isSupported() {
        return true;
    }

    @Override
    public byte[] encrypt(byte[] data) {
        return this.encrypt(data, null);
    }

    @Override
    public byte[] decrypt(byte[] data) {
        return this.decrypt(data, null);
    }

    @Override
    public byte[] encrypt(byte[] data, byte[] aad) {
        Objects.requireNonNull(data);
        try {
            byte[] iv = this.randomIV();
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)this.keySpec, gcmParameterSpec);
            if (aad != null && aad.length > 0) {
                cipher.updateAAD(aad);
            }
            if (this.efficientMemUse) {
                byte[] outData = new byte[IV_LEN + data.length + 16];
                System.arraycopy(iv, 0, outData, 0, IV_LEN);
                int bytesWritten = cipher.doFinal(data, 0, data.length, outData, IV_LEN);
                if (bytesWritten != data.length + 16) {
                    throw new RuntimeException("AES GCM encryption out buffer length misalignment");
                }
                return outData;
            }
            byte[] encryptedData = cipher.doFinal(data);
            byte[] outData = new byte[IV_LEN + encryptedData.length];
            System.arraycopy(iv, 0, outData, 0, IV_LEN);
            System.arraycopy(encryptedData, 0, outData, IV_LEN, encryptedData.length);
            return outData;
        }
        catch (Exception ex) {
            throw new FileException("Failed to decrypt data", ex);
        }
    }

    @Override
    public byte[] decrypt(byte[] data, byte[] aad) {
        Objects.requireNonNull(data);
        try {
            byte[] iv = new byte[IV_LEN];
            System.arraycopy(data, 0, iv, 0, IV_LEN);
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)this.keySpec, gcmParameterSpec);
            if (aad != null && aad.length > 0) {
                cipher.updateAAD(aad);
            }
            return cipher.doFinal(data, IV_LEN, data.length - IV_LEN);
        }
        catch (Exception ex) {
            throw new FileException("Failed to encrypt data", ex);
        }
    }

    public boolean hasProvider(String name) {
        return Security.getProvider(StringUtil.trimToEmpty(name)) != null;
    }

    public static byte[] emptyToNull(byte[] data) {
        return (byte[])(data != null && data.length == 0 ? null : data);
    }

    private byte[] randomIV() {
        byte[] iv = new byte[IV_LEN];
        new SecureRandom().nextBytes(iv);
        return iv;
    }
}

