/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.crypt;

import com.github.jlangch.venice.FileException;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.util.crypt.AbstractEncryptor;
import com.github.jlangch.venice.util.crypt.IEncryptor;
import com.github.jlangch.venice.util.crypt.Util;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Encryptor_AES256_CBC
extends AbstractEncryptor
implements IEncryptor {
    public static int KEY_ITERATIONS = 3000;
    public static int KEY_LEN = 256;
    public static int IV_LEN = 16;
    public static String SECRET_KEY_FACTORY = "PBKDF2WithHmacSHA256";
    private static byte[] KEY_SALT = new byte[]{69, 26, 121, 103, -70, -6, 13, 94, 3, 113, 68, 47, -61, -91, 110, 79};
    private final SecretKeySpec keySpec;
    private final byte[] customIV;
    private final boolean addIvToEncryptedData;

    private Encryptor_AES256_CBC(SecretKeySpec keySpec, byte[] customIV, boolean addCustomIvToEncryptedData) {
        Objects.requireNonNull(keySpec);
        this.keySpec = keySpec;
        this.customIV = customIV;
        this.addIvToEncryptedData = customIV == null || addCustomIvToEncryptedData;
    }

    public static Encryptor_AES256_CBC create(String passphrase) throws GeneralSecurityException {
        Objects.requireNonNull(passphrase);
        return Encryptor_AES256_CBC.create(passphrase, KEY_SALT, KEY_ITERATIONS, null, false);
    }

    public static Encryptor_AES256_CBC create(String passphrase, byte[] keySalt, Integer keyIterations) throws GeneralSecurityException {
        return Encryptor_AES256_CBC.create(passphrase, keySalt, keyIterations, null, false);
    }

    public static Encryptor_AES256_CBC create(String passphrase, byte[] keySalt, Integer keyIterations, byte[] customIV, boolean addCustomIvToEncryptedData) throws GeneralSecurityException {
        Objects.requireNonNull(passphrase);
        if (customIV != null && customIV.length != IV_LEN) {
            throw new IllegalArgumentException("A custom IV must have " + IV_LEN + " bytes!");
        }
        byte[] key = Util.deriveKeyFromPassphrase(passphrase, SECRET_KEY_FACTORY, keySalt == null ? KEY_SALT : keySalt, keyIterations == null ? KEY_ITERATIONS : keyIterations, KEY_LEN);
        SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
        return new Encryptor_AES256_CBC(keySpec, Encryptor_AES256_CBC.emptyToNull(customIV), addCustomIvToEncryptedData);
    }

    public static boolean isSupported() {
        return true;
    }

    @Override
    public byte[] encrypt(byte[] data) {
        Objects.requireNonNull(data);
        try {
            byte[] iv = this.customIV == null ? this.randomIV() : this.customIV;
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)this.keySpec, new IvParameterSpec(iv));
            byte[] encryptedData = cipher.doFinal(data);
            if (this.addIvToEncryptedData) {
                byte[] outData = new byte[IV_LEN + encryptedData.length];
                System.arraycopy(iv, 0, outData, 0, IV_LEN);
                System.arraycopy(encryptedData, 0, outData, IV_LEN, encryptedData.length);
                return outData;
            }
            return encryptedData;
        }
        catch (Exception ex) {
            throw new FileException("Failed to decrypt data", ex);
        }
    }

    @Override
    public byte[] decrypt(byte[] data) {
        Objects.requireNonNull(data);
        try {
            byte[] encryptedData;
            byte[] iv;
            if (this.addIvToEncryptedData) {
                iv = new byte[IV_LEN];
                System.arraycopy(data, 0, iv, 0, IV_LEN);
                encryptedData = new byte[data.length - IV_LEN];
                System.arraycopy(data, IV_LEN, encryptedData, 0, data.length - IV_LEN);
            } else {
                iv = this.customIV;
                encryptedData = data;
            }
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)this.keySpec, new IvParameterSpec(iv));
            return cipher.doFinal(encryptedData);
        }
        catch (Exception ex) {
            throw new FileException("Failed to encrypt data", ex);
        }
    }

    public boolean hasProvider(String name) {
        return Security.getProvider(StringUtil.trimToEmpty(name)) != null;
    }

    private byte[] randomIV() {
        byte[] iv = new byte[IV_LEN];
        new SecureRandom().nextBytes(iv);
        return iv;
    }

    public static byte[] emptyToNull(byte[] data) {
        return (byte[])(data != null && data.length == 0 ? null : data);
    }
}

