/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.loadpath;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.util.CollectionUtil;
import com.github.jlangch.venice.impl.util.io.CharsetUtil;
import com.github.jlangch.venice.impl.util.loadpath.Access;
import com.github.jlangch.venice.impl.util.loadpath.DirectoryLoadPath;
import com.github.jlangch.venice.impl.util.loadpath.LoadPath;
import com.github.jlangch.venice.javainterop.ILoadPaths;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class LoadPaths
implements ILoadPaths {
    private final List<LoadPath> paths = new ArrayList<LoadPath>();
    private final boolean unlimitedAccess;

    private LoadPaths(List<LoadPath> paths, boolean unlimitedAccess) {
        this.paths.addAll(paths);
        this.unlimitedAccess = unlimitedAccess;
    }

    public static LoadPaths of(List<File> paths, boolean unlimitedAccess) {
        return new LoadPaths(CollectionUtil.toEmpty(paths).stream().filter(p -> p != null).map(p -> LoadPath.of(p)).collect(Collectors.toList()), unlimitedAccess);
    }

    @Override
    public String loadVeniceFile(File file) {
        if (file == null) {
            return null;
        }
        String path = file.getPath();
        File veniceFile = path.endsWith(".venice") ? file : new File(path + ".venice");
        return this.toString(this.load(veniceFile), CharsetUtil.DEFAULT_CHARSET);
    }

    @Override
    public ByteBuffer loadBinaryResource(File file) {
        return file == null ? null : this.load(file);
    }

    @Override
    public String loadTextResource(File file, Charset charset) {
        return file == null ? null : this.toString(this.load(file), CharsetUtil.charset(charset));
    }

    @Override
    public List<File> getPaths() {
        return this.paths.stream().map(p -> p.path()).collect(Collectors.toList());
    }

    @Override
    public boolean isUnlimitedAccess() {
        return this.unlimitedAccess;
    }

    @Override
    public boolean isOnLoadPath(File file, Access mode) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        if (this.unlimitedAccess) {
            return true;
        }
        try {
            for (LoadPath p : this.paths) {
                if (!p.isOnPath(file, mode)) continue;
                return true;
            }
        }
        catch (VncException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to check if the file '%s' is on the load path", file.getPath()), ex);
        }
        return false;
    }

    @Override
    public boolean isRegularFileOnLoadPath(File file, Access mode) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        try {
            for (LoadPath p : this.paths) {
                boolean exists = p.isRegularFileOnLoadPath(file, mode);
                if (!exists) continue;
                return true;
            }
            if (this.unlimitedAccess) {
                return file.isFile();
            }
            return false;
        }
        catch (VncException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to check if the regular file '%s' exists the load path", file.getPath()), ex);
        }
    }

    @Override
    public boolean isDirectoryOnLoadPath(File file, Access mode) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        try {
            for (LoadPath p : this.paths) {
                boolean exists = p.isDirectoryOnLoadPath(file, mode);
                if (!exists) continue;
                return true;
            }
            if (this.unlimitedAccess) {
                return file.isDirectory();
            }
            return false;
        }
        catch (VncException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to check if the directory '%s' exists the load path", file.getPath()), ex);
        }
    }

    @Override
    public File normalize(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        try {
            if (this.paths.isEmpty()) {
                return file;
            }
            for (LoadPath p : this.paths) {
                File normalized = p.normalize(file);
                if (normalized == null) continue;
                return normalized.getCanonicalFile();
            }
            if (this.unlimitedAccess) {
                return file;
            }
        }
        catch (IOException ex) {
            throw new VncException("Failed to get canonical file", ex);
        }
        throw new VncException(String.format("Failed to normalize the file '%s'", file.getPath()));
    }

    @Override
    public InputStream getInputStream(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        try {
            for (LoadPath p : this.paths) {
                InputStream is = p.getInputStream(file);
                if (is == null) continue;
                return is;
            }
            if (this.unlimitedAccess) {
                if (!file.isAbsolute()) {
                    for (LoadPath p : this.paths) {
                        File f;
                        if (!(p instanceof DirectoryLoadPath) || !(f = new File(p.path(), file.getPath())).exists()) continue;
                        return Files.newInputStream(f.toPath(), new OpenOption[0]);
                    }
                }
                if (file.exists()) {
                    return Files.newInputStream(file.toPath(), new OpenOption[0]);
                }
            }
            throw new VncException("No such file: '" + file.getPath() + "'");
        }
        catch (VncException ex) {
            throw ex;
        }
        catch (FileNotFoundException | NoSuchFileException ex) {
            throw new VncException(String.format("No such file: '%s'", file.getPath()), ex);
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to return an InputStream for the file '%s' on the load path", file.getPath()), ex);
        }
    }

    @Override
    public BufferedReader getBufferedReader(File file, Charset charset) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        try {
            for (LoadPath p : this.paths) {
                BufferedReader br = p.getBufferedReader(file, charset);
                if (br == null) continue;
                return br;
            }
            if (this.unlimitedAccess) {
                if (!file.isAbsolute()) {
                    for (LoadPath p : this.paths) {
                        File f;
                        if (!(p instanceof DirectoryLoadPath) || !(f = new File(p.path(), file.getPath())).exists()) continue;
                        return Files.newBufferedReader(f.toPath(), charset);
                    }
                }
                if (file.exists()) {
                    return Files.newBufferedReader(file.toPath(), charset);
                }
            }
            throw new VncException("No such file: '" + file.getPath() + "'");
        }
        catch (VncException ex) {
            throw ex;
        }
        catch (FileNotFoundException | NoSuchFileException ex) {
            throw new VncException(String.format("No such file: '%s'", file.getPath()), ex);
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to return a BufferedReader for the file '%s' on the load path", file.getPath()), ex);
        }
    }

    @Override
    public OutputStream getOutputStream(File file, OpenOption ... options) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        try {
            for (LoadPath p : this.paths) {
                OutputStream os = p.getOutputStream(file, options);
                if (os == null) continue;
                return os;
            }
            if (this.unlimitedAccess) {
                if (!file.isAbsolute()) {
                    for (LoadPath p : this.paths) {
                        if (!(p instanceof DirectoryLoadPath)) continue;
                        File f = new File(p.path(), file.getPath());
                        return Files.newOutputStream(f.toPath(), options);
                    }
                }
                return Files.newOutputStream(file.toPath(), options);
            }
            return null;
        }
        catch (VncException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to return an OutputStream for the file '%s' on the load path", file.getPath()), ex);
        }
    }

    @Override
    public boolean active() {
        return !this.getPaths().isEmpty();
    }

    private ByteBuffer load(File file) {
        try {
            ByteBuffer dataFromLoadPath = this.loadBinary(file);
            if (dataFromLoadPath != null) {
                return dataFromLoadPath;
            }
            if (this.unlimitedAccess && file.isFile()) {
                return ByteBuffer.wrap(Files.readAllBytes(file.toPath()));
            }
            return null;
        }
        catch (VncException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to load the file '%s'", file.getPath()), ex);
        }
    }

    private ByteBuffer loadBinary(File file) throws IOException {
        for (LoadPath p : this.paths) {
            ByteBuffer buf = p.load(file);
            if (buf == null) continue;
            return buf;
        }
        return null;
    }

    private String toString(ByteBuffer data, Charset charset) {
        return data == null ? null : new String(data.array(), CharsetUtil.charset(charset));
    }
}

