/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.jar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarRewriter {
    public static byte[] addToJar(byte[] existingJar, Manifest manifest, Map<String, byte[]> additions) throws IOException {
        if (existingJar == null || existingJar.length == 0) {
            return JarRewriter.createJar(additions, null);
        }
        HashMap<String, byte[]> toAdd = new HashMap<String, byte[]>();
        for (Map.Entry<String, byte[]> e : additions.entrySet()) {
            toAdd.put(JarRewriter.normalize(e.getKey()), e.getValue());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(existingJar.length + 16384);
        try (JarInputStream jis = new JarInputStream(new ByteArrayInputStream(existingJar));
             JarOutputStream jos = manifest == null ? JarRewriter.copyManifestFirstIfPresent(jis, out) : JarRewriter.replaceManifestFirst(manifest, jis, out);){
            JarEntry in;
            long fixedTime = 0L;
            jos.setLevel(-1);
            HashSet<String> written = new HashSet<String>();
            while ((in = jis.getNextJarEntry()) != null) {
                String name = JarRewriter.normalize(in.getName());
                if (in.isDirectory() || toAdd.containsKey(name)) continue;
                JarEntry outEntry = new JarEntry(name);
                outEntry.setTime(fixedTime);
                jos.putNextEntry(outEntry);
                JarRewriter.copy(jis, jos);
                jos.closeEntry();
                written.add(name);
            }
            HashSet<String> dirs = new HashSet<String>();
            for (String string : toAdd.keySet()) {
                int slash = string.lastIndexOf(47);
                while (slash > 0) {
                    String dir = string.substring(0, slash + 1);
                    if (dirs.add(dir) && !written.contains(dir)) {
                        JarEntry de = new JarEntry(dir);
                        de.setTime(fixedTime);
                        jos.putNextEntry(de);
                        jos.closeEntry();
                    }
                    slash = string.lastIndexOf(47, slash - 1);
                }
            }
            for (Map.Entry entry : toAdd.entrySet()) {
                String path = (String)entry.getKey();
                JarEntry je = new JarEntry(path);
                je.setTime(fixedTime);
                jos.putNextEntry(je);
                jos.write((byte[])entry.getValue());
                jos.closeEntry();
            }
        }
        return out.toByteArray();
    }

    public static byte[] createJar(Map<String, byte[]> entries, Manifest manifest) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(65536);
        JarOutputStream jos = manifest != null ? new JarOutputStream((OutputStream)out, manifest) : new JarOutputStream(out);
        jos.setLevel(-1);
        long fixedTime = 0L;
        HashSet<String> dirs = new HashSet<String>();
        for (String string : entries.keySet()) {
            int slash = string.lastIndexOf(47);
            while (slash > 0) {
                String dir = string.substring(0, slash + 1);
                if (dirs.add(dir)) {
                    JarEntry de = new JarEntry(dir);
                    de.setTime(fixedTime);
                    jos.putNextEntry(de);
                    jos.closeEntry();
                }
                slash = string.lastIndexOf(47, slash - 1);
            }
        }
        for (Map.Entry entry : entries.entrySet()) {
            String path = JarRewriter.normalize((String)entry.getKey());
            JarEntry je = new JarEntry(path);
            je.setTime(fixedTime);
            jos.putNextEntry(je);
            jos.write((byte[])entry.getValue());
            jos.closeEntry();
        }
        jos.close();
        return out.toByteArray();
    }

    public static Manifest manifest(String appName, String version, String mainClass) {
        String now = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"));
        Manifest mf = new Manifest();
        mf.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mf.getMainAttributes().put(Attributes.Name.SPECIFICATION_TITLE, appName);
        mf.getMainAttributes().put(Attributes.Name.SPECIFICATION_VERSION, version);
        mf.getMainAttributes().put(Attributes.Name.MAIN_CLASS, mainClass);
        mf.getMainAttributes().put(new Attributes.Name("Application-Name"), appName);
        mf.getMainAttributes().put(new Attributes.Name("Build-Date"), now);
        return mf;
    }

    public static byte[] demo() throws IOException {
        Manifest mf = new Manifest();
        mf.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mf.getMainAttributes().put(Attributes.Name.MAIN_CLASS, "example.App");
        HashMap<String, byte[]> initial = new HashMap<String, byte[]>();
        initial.put("example/App.class", new byte[]{-54, -2, -70, -66});
        initial.put("config/app.properties", "env=dev\n".getBytes(StandardCharsets.UTF_8));
        byte[] jar = JarRewriter.createJar(initial, mf);
        HashMap<String, byte[]> additions = new HashMap<String, byte[]>();
        additions.put("README.txt", "Hello JAR!\n".getBytes(StandardCharsets.UTF_8));
        additions.put("config/app.properties", "env=prod\n".getBytes(StandardCharsets.UTF_8));
        byte[] updatedJar = JarRewriter.addToJar(jar, null, additions);
        try (ZipInputStream zin = new ZipInputStream(new ByteArrayInputStream(updatedJar));){
            ZipEntry ze;
            System.out.println("JAR entries:");
            while ((ze = zin.getNextEntry()) != null) {
                System.out.println(" - " + ze.getName());
            }
        }
        return updatedJar;
    }

    private static String normalize(String path) {
        String p = path.replace('\\', '/');
        if (p.startsWith("/")) {
            p = p.substring(1);
        }
        return p;
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int r;
        byte[] buf = new byte[8192];
        while ((r = in.read(buf)) != -1) {
            out.write(buf, 0, r);
        }
    }

    private static JarOutputStream copyManifestFirstIfPresent(JarInputStream jis, ByteArrayOutputStream out) throws IOException {
        Manifest mf = jis.getManifest();
        return mf != null ? new JarOutputStream((OutputStream)out, mf) : new JarOutputStream(out);
    }

    private static JarOutputStream replaceManifestFirst(Manifest manifest, JarInputStream jis, ByteArrayOutputStream out) throws IOException {
        return manifest != null ? new JarOutputStream((OutputStream)out, manifest) : new JarOutputStream(out);
    }
}

