/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.jar;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.AutoRunScriptLauncher;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.jar.JarRewriter;
import java.io.File;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Objects;
import java.util.jar.Manifest;

public class AutoRunScriptJarRewriter {
    private static final String BASE_PATH = "com/github/jlangch/venice/auto/";
    public static final String AUTORUN_SCRIPT_PATH = "com/github/jlangch/venice/auto/autorun.venice";
    public static final String AUTORUN_META_PATH = "com/github/jlangch/venice/auto/autorun.meta";

    public static byte[] createAutoRunVeniceJar(byte[] existingVeniceJar, String scriptName, String scriptVersion, String script) {
        Objects.requireNonNull(script);
        if (!StringUtil.trimToEmpty(scriptName).matches("[a-zA-Z0-9-_]+")) {
            throw new VncException("A script name must only contain the characters a-z, A-Z, 0-9, '_', or '-'");
        }
        if (!StringUtil.trimToEmpty(scriptVersion).matches("[a-zA-Z0-9-_.]+")) {
            throw new VncException("A script name must only contain the characters a-z, A-Z, 0-9, '_', '-', or '.'");
        }
        byte[] veniceJar = existingVeniceJar != null ? existingVeniceJar : AutoRunScriptJarRewriter.loadThisVeniceJar();
        String scriptMeta = String.format("script-name=%s\nscript-version=%s\n", scriptName, scriptVersion);
        HashMap<String, byte[]> additions = new HashMap<String, byte[]>();
        additions.put(AUTORUN_SCRIPT_PATH, script.getBytes(StandardCharsets.UTF_8));
        additions.put(AUTORUN_META_PATH, scriptMeta.getBytes(StandardCharsets.UTF_8));
        try {
            Manifest manifest = JarRewriter.manifest(scriptName, scriptVersion, AutoRunScriptLauncher.class.getName());
            return JarRewriter.addToJar(veniceJar, manifest, additions);
        }
        catch (Exception ex) {
            throw new VncException("Failed to create the JAR", ex);
        }
    }

    public static Path createAndSaveAutoRunVeniceJar(byte[] existingVeniceJar, String scriptName, String scriptVersion, String script, Path saveTo) {
        Objects.requireNonNull(saveTo);
        if (!saveTo.toFile().isDirectory()) {
            throw new VncException("The destination directory '" + saveTo.toString() + "' does not exist!");
        }
        byte[] veniceJar = existingVeniceJar != null ? existingVeniceJar : AutoRunScriptJarRewriter.loadThisVeniceJar();
        return AutoRunScriptJarRewriter.saveTo(AutoRunScriptJarRewriter.createAutoRunVeniceJar(veniceJar, scriptName, scriptVersion, script), scriptName, saveTo).normalize().toAbsolutePath();
    }

    public static byte[] loadThisVeniceJar() {
        try {
            URI uri = AutoRunScriptJarRewriter.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            return Files.readAllBytes(new File(uri).toPath());
        }
        catch (Exception ex) {
            throw new VncException("Failed to load Venice JAR!", ex);
        }
    }

    private static Path saveTo(byte[] jar, String scriptName, Path saveTo) {
        try {
            Path dest = Paths.get(saveTo.toString(), scriptName + ".jar");
            Files.write(dest, jar, new OpenOption[0]);
            return dest;
        }
        catch (Exception ex) {
            throw new VncException("Failed to save new JAR!", ex);
        }
    }
}

