/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.io.zip;

import com.github.jlangch.venice.impl.util.io.zip.ZipEntryAttr;
import com.github.jlangch.venice.util.NullOutputStream;
import java.io.PrintStream;
import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class ZipEntryAttrPrinter {
    private static final String ziplist_format = "%10s  %6s  %10s  %4s  %16s  %8s  %s";
    private static final String ziplist_format_short = "%10s  %16s %s";
    private static final DateTimeFormatter ziplist_formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private final PrintStream ps;
    private final boolean verbose;
    private long totCount = 0L;
    private long totSize = 0L;
    private long totCompressedSize = 0L;

    public ZipEntryAttrPrinter(PrintStream ps, boolean verbose) {
        this.ps = ps;
        this.verbose = verbose;
    }

    public static ZipEntryAttrPrinter nullPrinter() {
        return new ZipEntryAttrPrinter(new PrintStream(new NullOutputStream(), true), false);
    }

    public void start() {
        this.totCount = 0L;
        this.totSize = 0L;
        this.totCompressedSize = 0L;
        ZipEntryAttrPrinter.printZipListLineHead(this.ps, this.verbose);
        ZipEntryAttrPrinter.printZipListLineDelim(this.ps, this.verbose);
    }

    public void print(ZipEntryAttr entry) {
        long size = entry.getSize();
        long compressedSize = entry.getCompressedSize();
        ++this.totCount;
        this.totSize += Math.max(0L, size);
        this.totCompressedSize += Math.max(0L, compressedSize);
        ZipEntryAttrPrinter.printZipListLine(this.ps, this.verbose, size, entry.getMethod(), compressedSize, entry.getLastModifiedTime(), entry.getCrc(), entry.getName());
    }

    public void end() {
        ZipEntryAttrPrinter.printZipListLineDelim(this.ps, this.verbose);
        ZipEntryAttrPrinter.printZipListLine(this.ps, this.verbose, this.totSize, null, this.totCompressedSize, null, null, this.totCount == 1L ? "1 file" : String.format("%d files", this.totCount));
    }

    private static void printZipListLine(PrintStream ps, boolean verbose, long size, String method, long compressedSize, FileTime time, Long crc, String name) {
        String sTime;
        String sCompression = String.valueOf(ZipEntryAttrPrinter.compressionPercentage(size, compressedSize)) + "%";
        String string = sTime = time == null ? " " : LocalDateTime.ofInstant(time.toInstant(), ZoneOffset.UTC).format(ziplist_formatter);
        String sCrc = crc == null ? "" : (crc == -1L ? "-" : String.format("%08X", crc & 0xFFFFFFFFFFFFFFFFL));
        ZipEntryAttrPrinter.printZipListLine(ps, verbose, String.valueOf(size), method, String.valueOf(compressedSize), sCompression, sTime, sCrc, name);
    }

    private static void printZipListLine(PrintStream ps, boolean verbose, String length, String method, String size, String compression, String time, String crc, String name) {
        if (verbose) {
            ps.println(String.format(ziplist_format, length, method, size, compression, time, crc, name));
        } else {
            ps.println(String.format(ziplist_format_short, length, time, name));
        }
    }

    private static void printZipListLineHead(PrintStream ps, boolean verbose) {
        ZipEntryAttrPrinter.printZipListLine(ps, verbose, "Length", "Method", "Size", "Cmpr", "Date/Time", "CRC-32", "Name");
    }

    private static void printZipListLineDelim(PrintStream ps, boolean verbose) {
        ZipEntryAttrPrinter.printZipListLine(ps, verbose, "----------", "------", "----------", "----", "----------------", "--------", "--------------------");
    }

    private static long compressionPercentage(long size, long compressedSize) {
        return size <= 0L || compressedSize <= 0L ? 0L : ((size - compressedSize) * 100L + size / 2L) / size;
    }
}

