/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.excel;

import com.github.jlangch.venice.ExcelException;
import com.github.jlangch.venice.util.excel.CellAddr;
import com.github.jlangch.venice.util.excel.CellRangeAddr;
import com.github.jlangch.venice.util.excel.chart.AreaDataSeries;
import com.github.jlangch.venice.util.excel.chart.BarDataSeries;
import com.github.jlangch.venice.util.excel.chart.BarGrouping;
import com.github.jlangch.venice.util.excel.chart.ImageType;
import com.github.jlangch.venice.util.excel.chart.LineDataSeries;
import com.github.jlangch.venice.util.excel.chart.MarkerStyle;
import com.github.jlangch.venice.util.excel.chart.PieDataSeries;
import com.github.jlangch.venice.util.excel.chart.Position;
import java.util.List;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xddf.usermodel.chart.AxisCrossBetween;
import org.apache.poi.xddf.usermodel.chart.AxisPosition;
import org.apache.poi.xddf.usermodel.chart.BarDirection;
import org.apache.poi.xddf.usermodel.chart.ChartTypes;
import org.apache.poi.xddf.usermodel.chart.LegendPosition;
import org.apache.poi.xddf.usermodel.chart.XDDFArea3DChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFAreaChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFBar3DChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFBarChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFChartLegend;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFLine3DChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFLineChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import org.apache.poi.xssf.usermodel.XSSFChart;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelCharts {
    private final Sheet sheet;

    public ExcelCharts(Sheet sheet) {
        this.sheet = sheet;
    }

    public void addImage(CellAddr anchor, byte[] data, ImageType type, Double scaleX, Double scaleY) {
        switch (type) {
            case PNG: {
                this.setImage(anchor, data, 6, scaleX, scaleY);
                break;
            }
            case JPEG: {
                this.setImage(anchor, data, 5, scaleX, scaleY);
                break;
            }
            default: {
                throw new ExcelException(String.format("Excel cell %s in sheet '%s': Invalid image type. Use PNG or JPEG", anchor.mapToOneBased(), this.sheet.getSheetName()));
            }
        }
    }

    public void addLineChart(String title, CellRangeAddr areaCellRangeAddr, Position legendPosition, String categoryAxisTitle, Position categoryAxisPosition, String valueAxisTitle, Position valueAxisPosition, boolean threeDimensional, boolean varyColors, CellRangeAddr categoriesCellRangeAddr, List<LineDataSeries> series) {
        XDDFLine3DChartData data_;
        if (!(this.sheet.getWorkbook() instanceof XSSFWorkbook)) {
            throw new ExcelException("Excel line charts only work with Excel of type XLSX!");
        }
        XSSFDrawing drawing = (XSSFDrawing)this.sheet.createDrawingPatriarch();
        XSSFClientAnchor anchor = this.drawingAnchor(drawing, areaCellRangeAddr);
        XSSFChart chart = drawing.createChart(anchor);
        chart.setTitleText(title);
        chart.setTitleOverlay(false);
        XDDFChartLegend legend = chart.getOrAddLegend();
        legend.setPosition(this.toLegendPosition(legendPosition));
        XDDFCategoryAxis categoryAxis = chart.createCategoryAxis(this.toAxisPosition(categoryAxisPosition));
        categoryAxis.setTitle(categoryAxisTitle);
        XDDFValueAxis valueAxis = chart.createValueAxis(this.toAxisPosition(valueAxisPosition));
        valueAxis.setTitle(valueAxisTitle);
        XDDFDataSource<String> categories = this.stringDataSource(categoriesCellRangeAddr);
        XDDFLine3DChartData data = threeDimensional ? (data_ = (XDDFLine3DChartData)chart.createData(ChartTypes.LINE3D, (XDDFChartAxis)categoryAxis, valueAxis)) : (data_ = (XDDFLineChartData)chart.createData(ChartTypes.LINE, (XDDFChartAxis)categoryAxis, valueAxis));
        data.setVaryColors(Boolean.valueOf(varyColors));
        for (LineDataSeries s : series) {
            XDDFLine3DChartData.Series series_;
            XDDFNumericalDataSource<Double> values = this.numericalDataSource(s.getCellRangeAddr());
            if (threeDimensional) {
                series_ = (XDDFLine3DChartData.Series)data.addSeries(categories, values);
                series_.setTitle(s.getTitle(), null);
                series_.setSmooth(Boolean.valueOf(s.isSmooth()));
                series_.setMarkerStyle(this.toMarkerStyle(s.getMarkerStyle()));
                continue;
            }
            series_ = (XDDFLineChartData.Series)data.addSeries(categories, values);
            series_.setTitle(s.getTitle(), null);
            series_.setSmooth(Boolean.valueOf(s.isSmooth()));
            series_.setMarkerStyle(this.toMarkerStyle(s.getMarkerStyle()));
        }
        chart.plot((XDDFChartData)data);
    }

    public void addBarChart(String title, CellRangeAddr areaCellRangeAddr, Position legendPosition, String categoryAxisTitle, Position categoryAxisPosition, String valueAxisTitle, Position valueAxisPosition, boolean threeDimensional, boolean directionBar, BarGrouping grouping, boolean varyColors, CellRangeAddr categoriesCellRangeAddr, List<BarDataSeries> series) {
        boolean stacked;
        XDDFBar3DChartData data;
        Object data_;
        if (!(this.sheet.getWorkbook() instanceof XSSFWorkbook)) {
            throw new ExcelException("Excel bar charts only work with Excel of type XLSX!");
        }
        XSSFDrawing drawing = (XSSFDrawing)this.sheet.createDrawingPatriarch();
        XSSFClientAnchor anchor = this.drawingAnchor(drawing, areaCellRangeAddr);
        XSSFChart chart = drawing.createChart(anchor);
        chart.setTitleText(title);
        chart.setTitleOverlay(false);
        XDDFChartLegend legend = chart.getOrAddLegend();
        legend.setPosition(this.toLegendPosition(legendPosition));
        XDDFCategoryAxis categoryAxis = chart.createCategoryAxis(this.toAxisPosition(categoryAxisPosition));
        categoryAxis.setTitle(categoryAxisTitle);
        XDDFValueAxis valueAxis = chart.createValueAxis(this.toAxisPosition(valueAxisPosition));
        valueAxis.setTitle(valueAxisTitle);
        valueAxis.setCrossBetween(AxisCrossBetween.BETWEEN);
        XDDFDataSource<String> categories = this.stringDataSource(categoriesCellRangeAddr);
        if (threeDimensional) {
            data_ = (XDDFBar3DChartData)chart.createData(ChartTypes.BAR3D, (XDDFChartAxis)categoryAxis, valueAxis);
            data_.setBarDirection(directionBar ? BarDirection.BAR : BarDirection.COL);
            data_.setBarGrouping(this.toBarGrouping(grouping));
            data = data_;
        } else {
            data_ = (XDDFBarChartData)chart.createData(ChartTypes.BAR, (XDDFChartAxis)categoryAxis, valueAxis);
            data_.setBarDirection(directionBar ? BarDirection.BAR : BarDirection.COL);
            data_.setBarGrouping(this.toBarGrouping(grouping));
            data = data_;
        }
        data.setVaryColors(Boolean.valueOf(varyColors));
        for (BarDataSeries s : series) {
            XDDFNumericalDataSource<Double> values = this.numericalDataSource(s.getCellRangeAddr());
            XDDFChartData.Series series_ = data.addSeries(categories, values);
            series_.setTitle(s.getTitle(), null);
        }
        boolean bl = stacked = grouping == BarGrouping.STACKED || grouping == BarGrouping.PERCENT_STACKED;
        if (stacked) {
            chart.getCTChart().getPlotArea().getBarChartArray(0).addNewOverlap().setVal((Object)100);
        }
        chart.plot((XDDFChartData)data);
    }

    public void addAreaChart(String title, CellRangeAddr areaCellRangeAddr, Position legendPosition, String categoryAxisTitle, Position categoryAxisPosition, String valueAxisTitle, Position valueAxisPosition, boolean threeDimensional, CellRangeAddr categoriesCellRangeAddr, List<AreaDataSeries> series) {
        XDDFArea3DChartData data_;
        if (!(this.sheet.getWorkbook() instanceof XSSFWorkbook)) {
            throw new ExcelException("Excel area charts only work with Excel of type XLSX!");
        }
        XSSFDrawing drawing = (XSSFDrawing)this.sheet.createDrawingPatriarch();
        XSSFClientAnchor anchor = this.drawingAnchor(drawing, areaCellRangeAddr);
        XSSFChart chart = drawing.createChart(anchor);
        chart.setTitleText(title);
        chart.setTitleOverlay(false);
        XDDFChartLegend legend = chart.getOrAddLegend();
        legend.setPosition(this.toLegendPosition(legendPosition));
        XDDFCategoryAxis categoryAxis = chart.createCategoryAxis(this.toAxisPosition(categoryAxisPosition));
        categoryAxis.setTitle(categoryAxisTitle);
        XDDFValueAxis valueAxis = chart.createValueAxis(this.toAxisPosition(valueAxisPosition));
        valueAxis.setTitle(valueAxisTitle);
        XDDFDataSource<String> categories = this.stringDataSource(categoriesCellRangeAddr);
        XDDFArea3DChartData data = threeDimensional ? (data_ = (XDDFArea3DChartData)chart.createData(ChartTypes.AREA3D, (XDDFChartAxis)categoryAxis, valueAxis)) : (data_ = (XDDFAreaChartData)chart.createData(ChartTypes.AREA, (XDDFChartAxis)categoryAxis, valueAxis));
        for (AreaDataSeries s : series) {
            XDDFNumericalDataSource<Double> values = this.numericalDataSource(s.getCellRangeAddr());
            XDDFChartData.Series series_ = data.addSeries(categories, values);
            series_.setTitle(s.getTitle(), null);
        }
        chart.plot((XDDFChartData)data);
    }

    public void addPieChart(String title, CellRangeAddr areaCellRangeAddr, Position legendPosition, boolean threeDimensional, boolean varyColors, CellRangeAddr categoriesCellRangeAddr, List<PieDataSeries> series) {
        if (!(this.sheet.getWorkbook() instanceof XSSFWorkbook)) {
            throw new ExcelException("Excel pie charts only work with Excel of type XLSX!");
        }
        if (series.size() != 1) {
            throw new ExcelException("Excel pie chart must have exactly one series!");
        }
        XSSFDrawing drawing = (XSSFDrawing)this.sheet.createDrawingPatriarch();
        XSSFClientAnchor anchor = this.drawingAnchor(drawing, areaCellRangeAddr);
        XSSFChart chart = drawing.createChart(anchor);
        chart.setTitleText(title);
        chart.setTitleOverlay(false);
        XDDFChartLegend legend = chart.getOrAddLegend();
        legend.setPosition(this.toLegendPosition(legendPosition));
        XDDFDataSource<String> categories = this.stringDataSource(categoriesCellRangeAddr);
        XDDFChartData data = chart.createData(threeDimensional ? ChartTypes.PIE3D : ChartTypes.PIE, null, null);
        data.setVaryColors(Boolean.valueOf(varyColors));
        XDDFNumericalDataSource<Double> values = this.numericalDataSource(series.get(0).getCellRangeAddr());
        XDDFChartData.Series series_ = data.addSeries(categories, values);
        series_.setTitle(series.get(0).getTitle(), null);
        chart.plot(data);
    }

    private void setImage(CellAddr anchorAddr, byte[] data, int imageType, Double scaleX, Double scaleY) {
        CreationHelper helper = this.sheet.getWorkbook().getCreationHelper();
        Drawing drawing = this.sheet.createDrawingPatriarch();
        int pictureIdx = this.sheet.getWorkbook().addPicture(data, imageType);
        ClientAnchor anchor = helper.createClientAnchor();
        anchor.setCol1(anchorAddr.getCol());
        anchor.setRow1(anchorAddr.getRow());
        Picture pict = drawing.createPicture(anchor, pictureIdx);
        if (scaleX == null || scaleY == null) {
            pict.resize();
        } else {
            pict.resize(scaleX.doubleValue(), scaleY.doubleValue());
        }
    }

    private org.apache.poi.xddf.usermodel.chart.MarkerStyle toMarkerStyle(MarkerStyle style) {
        if (style == null) {
            return org.apache.poi.xddf.usermodel.chart.MarkerStyle.NONE;
        }
        switch (style) {
            case CIRCLE: {
                return org.apache.poi.xddf.usermodel.chart.MarkerStyle.CIRCLE;
            }
            case DASH: {
                return org.apache.poi.xddf.usermodel.chart.MarkerStyle.DASH;
            }
            case DIAMOND: {
                return org.apache.poi.xddf.usermodel.chart.MarkerStyle.DIAMOND;
            }
            case DOT: {
                return org.apache.poi.xddf.usermodel.chart.MarkerStyle.DOT;
            }
            case NONE: {
                return org.apache.poi.xddf.usermodel.chart.MarkerStyle.NONE;
            }
            case PICTURE: {
                return org.apache.poi.xddf.usermodel.chart.MarkerStyle.PICTURE;
            }
            case PLUS: {
                return org.apache.poi.xddf.usermodel.chart.MarkerStyle.PLUS;
            }
            case SQUARE: {
                return org.apache.poi.xddf.usermodel.chart.MarkerStyle.SQUARE;
            }
            case STAR: {
                return org.apache.poi.xddf.usermodel.chart.MarkerStyle.STAR;
            }
            case TRIANGLE: {
                return org.apache.poi.xddf.usermodel.chart.MarkerStyle.TRIANGLE;
            }
            case X: {
                return org.apache.poi.xddf.usermodel.chart.MarkerStyle.X;
            }
        }
        return org.apache.poi.xddf.usermodel.chart.MarkerStyle.NONE;
    }

    private org.apache.poi.xddf.usermodel.chart.BarGrouping toBarGrouping(BarGrouping grouping) {
        if (grouping == null) {
            return org.apache.poi.xddf.usermodel.chart.BarGrouping.STANDARD;
        }
        switch (grouping) {
            case STANDARD: {
                return org.apache.poi.xddf.usermodel.chart.BarGrouping.STANDARD;
            }
            case CLUSTERED: {
                return org.apache.poi.xddf.usermodel.chart.BarGrouping.CLUSTERED;
            }
            case STACKED: {
                return org.apache.poi.xddf.usermodel.chart.BarGrouping.STACKED;
            }
            case PERCENT_STACKED: {
                return org.apache.poi.xddf.usermodel.chart.BarGrouping.PERCENT_STACKED;
            }
        }
        return org.apache.poi.xddf.usermodel.chart.BarGrouping.STANDARD;
    }

    private XSSFClientAnchor drawingAnchor(XSSFDrawing drawing, CellRangeAddr addr) {
        return drawing.createAnchor(0, 0, 0, 0, addr.getFirstCol(), addr.getFirstRow(), addr.getLastCol(), addr.getLastRow());
    }

    private XDDFNumericalDataSource<Double> numericalDataSource(CellRangeAddr addr) {
        return XDDFDataSourcesFactory.fromNumericCellRange((XSSFSheet)((XSSFSheet)this.sheet), (CellRangeAddress)new CellRangeAddress(addr.getFirstRow(), addr.getLastRow(), addr.getFirstCol(), addr.getLastCol()));
    }

    private XDDFDataSource<String> stringDataSource(CellRangeAddr addr) {
        return XDDFDataSourcesFactory.fromStringCellRange((XSSFSheet)((XSSFSheet)this.sheet), (CellRangeAddress)new CellRangeAddress(addr.getFirstRow(), addr.getLastRow(), addr.getFirstCol(), addr.getLastCol()));
    }

    private LegendPosition toLegendPosition(Position pos) {
        if (pos == null) {
            return LegendPosition.TOP;
        }
        switch (pos) {
            case BOTTOM: {
                return LegendPosition.BOTTOM;
            }
            case LEFT: {
                return LegendPosition.LEFT;
            }
            case RIGHT: {
                return LegendPosition.RIGHT;
            }
            case TOP: {
                return LegendPosition.TOP;
            }
            case TOP_RIGHT: {
                return LegendPosition.TOP_RIGHT;
            }
        }
        return LegendPosition.TOP;
    }

    private AxisPosition toAxisPosition(Position pos) {
        if (pos == null) {
            return AxisPosition.TOP;
        }
        switch (pos) {
            case BOTTOM: {
                return AxisPosition.BOTTOM;
            }
            case LEFT: {
                return AxisPosition.LEFT;
            }
            case RIGHT: {
                return AxisPosition.RIGHT;
            }
            case TOP: {
                return AxisPosition.TOP;
            }
            case TOP_RIGHT: {
                return AxisPosition.TOP;
            }
        }
        return AxisPosition.TOP;
    }
}

