/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.csv;

import com.github.jlangch.venice.impl.util.csv.CharacterReader;
import com.github.jlangch.venice.impl.util.io.CharsetUtil;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class CSVReader {
    private final char separator;
    private final char quote;

    public CSVReader() {
        this(',', '\"');
    }

    public CSVReader(char separator, char quote) {
        this.separator = separator;
        this.quote = quote;
        if (quote == separator) {
            throw new RuntimeException("The quote and the separator character must not be identical!");
        }
    }

    public List<List<String>> parse(String csv) {
        return this.parse(new CharacterReader(csv));
    }

    public List<List<String>> parse(Reader rd) {
        return this.parse(new CharacterReader(rd));
    }

    public List<List<String>> parse(InputStream is, Charset charset) {
        return this.parse(new CharacterReader(is, CharsetUtil.charset(charset)));
    }

    private List<List<String>> parse(CharacterReader rd) {
        ArrayList<List<String>> records = new ArrayList<List<String>>();
        while (!rd.isEof()) {
            int ch = rd.peek();
            if (ch == 13 || ch == 10) {
                rd.consume();
                continue;
            }
            List<String> record = this.parseRecord(rd);
            if (record.isEmpty()) continue;
            records.add(record);
        }
        return records;
    }

    private List<String> parseRecord(CharacterReader rd) {
        rd.skipAllOfChar('\r');
        if (rd.peek() == 10) {
            rd.consume();
            return new ArrayList<String>();
        }
        if (rd.isEof()) {
            return new ArrayList<String>();
        }
        ArrayList<String> record = new ArrayList<String>();
        while (!rd.isEof()) {
            int ch = rd.peek();
            if (ch == 13) {
                rd.skipAllOfChar('\r');
            } else {
                if (ch == 10) {
                    rd.consume();
                    break;
                }
                if (ch == this.quote) {
                    rd.consume();
                    record.add(this.parseQuotedField(rd));
                } else {
                    record.add(this.parseField(rd));
                }
            }
            if (rd.peek() != this.separator) continue;
            rd.consume();
            rd.skipAllOfChar('\r');
            if (rd.peek() != 10 && !rd.isEof()) continue;
            record.add(null);
        }
        return record;
    }

    private String parseField(CharacterReader rd) {
        int ch;
        StringBuilder sb = new StringBuilder();
        while (!rd.isEof() && (ch = rd.peek()) != this.separator && ch != 13 && ch != 10) {
            if (ch == this.quote) {
                throw new RuntimeException(String.format("The quote char '%c' must not appear in a non quoted field at line %d, col %d.", ch, rd.getLineNr(), rd.getColNr()));
            }
            rd.consume();
            sb.append((char)ch);
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    private String parseQuotedField(CharacterReader rd) {
        StringBuilder sb = new StringBuilder();
        while (!rd.isEof()) {
            int ch = rd.peek();
            if (ch == this.quote) {
                rd.consume();
                int chNext = rd.peek();
                if (chNext != this.quote) break;
                sb.append(this.quote);
                rd.consume();
                continue;
            }
            sb.append((char)ch);
            rd.consume();
        }
        this.readTrailingFieldCharsUpToSeparator(rd);
        return sb.toString().trim();
    }

    private void readTrailingFieldCharsUpToSeparator(CharacterReader rd) {
        rd.skipAllOfChar('\r');
        if (!rd.isEof()) {
            int ch = rd.peek();
            if (ch == this.separator || ch == 10) {
                return;
            }
            throw new RuntimeException(String.format("Unexpected char '%c' after quoted field at line %d, col %d.", ch, rd.getLineNr(), rd.getColNr()));
        }
    }
}

