/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.specialforms;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.CodeLoader;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.namespaces.Namespace;
import com.github.jlangch.venice.impl.namespaces.Namespaces;
import com.github.jlangch.venice.impl.specialforms.util.SpecialFormsContext;
import com.github.jlangch.venice.impl.specialforms.util.SpecialFormsUtil;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncSpecialForm;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;

public class SpecialForms_LoadCodeMacros {
    public static VncSpecialForm load_string = new VncSpecialForm("load-string", (VncVal)VncSpecialForm.meta().arglists("(load-string s)").doc("Sequentially read and evaluate the set of forms contained in the string.").examples("(do                             \n  (load-string \"(def x 1)\")   \n  (+ x 2))                      ").seeAlso("load-file", "load-classpath-file", "loaded-modules").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            SpecialFormsUtil.specialFormCallValidation(ctx, "load-string");
            ArityExceptions.assertArity("load-string", ArityExceptions.FnType.SpecialForm, args, 1);
            1 var5_5 = this;
            synchronized (var5_5) {
                VncVal vncVal;
                Namespace currNS = Namespaces.getCurrentNamespace();
                try {
                    VncVal ast;
                    VncString s = Coerce.toVncString(args.first());
                    vncVal = ast = new CodeLoader().loadCode(s.getValue(), "string", ctx.getInterpreter(), env);
                }
                catch (Throwable throwable) {
                    Namespaces.setCurrentNamespace(currNS);
                    throw throwable;
                }
                Namespaces.setCurrentNamespace(currNS);
                return vncVal;
            }
        }
    };
    public static VncSpecialForm load_module = new VncSpecialForm("load-module", (VncVal)VncSpecialForm.meta().arglists("(load-module m)", "(load-module m force)", "(load-module m nsalias)", "(load-module m force nsalias)").doc("Loads a Venice predefined extension module.\n\nReturns a tuple with the module's name and the keyword `:loaded` if the module has been successfully loaded or `:already-loaded` if the module has been already loaded. Throws an exception on any loading error.\n\nWith 'force' set to `false` (the default) the module is only loaded once and interpreted once. Subsequent load attempts will be skipped. With 'force' set to `true` it is always loaded and interpreted.\n\nLoaded modules are cached by Venice and subsequent loads are just skipped. To enforce a reload call the module load with the force flag set to true: `(load-module :hexdump true)`\n\nAn optional namespace alias can passed:\n`(load-module :hexdump ['hexdump :as 'h])`\n\n`load-module` supports load paths. See the `loadpath/paths` doc for a description of the *load path* feature.").examples("(load-module :trace) ", ";; loading the :trace modul and define a ns alias 't for namespace \n;; 'trace used in the module                                       \n(load-module :trace ['trace :as 't])                               ", ";; reloading a module          \n(do                            \n  (load-module :trace)         \n  ; reload the module          \n  (ns-remove 'trace)           \n  (load-module :trace true))   ", ";; namespace aliases                       \n(do                                        \n  (load-module :hexdump ['hexdump :as 'h]) \n  (h/dump (range 32 64)))                  ", ";; dynamically load a module        \n(let [mname (keyword \"hexdump\")]  \n  (load-module mname))              ").seeAlso("load-file", "load-classpath-file", "load-string", "loaded-modules", "loadpath/paths", "doc").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            SpecialFormsUtil.specialFormCallValidation(ctx, "load-module");
            ArityExceptions.assertArity("load-module", ArityExceptions.FnType.SpecialForm, args, 1, 2, 3);
            VncVal mod = Types.isVncSymbol(args.first()) ? ctx.getEvaluator().evaluate(args.first(), env, false) : args.first();
            VncKeyword module = Coerce.toVncKeyword(mod);
            Options options = SpecialForms_LoadCodeMacros.parseOptions(args, "load-module");
            VncVector aliasOpt = options.alias;
            VncBoolean forceOpt = options.force;
            try {
                boolean force = VncBoolean.isTrue(forceOpt);
                IInterceptor interceptor = ThreadContext.getInterceptor();
                boolean loaded = new CodeLoader().loadModule(module, ctx.getInterpreter(), interceptor, env, force, aliasOpt);
                return VncVector.empty().addAtEnd(module).addAtEnd(new VncKeyword(loaded ? "loaded" : "already-loaded"));
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException("Failed to load the Venice module '" + args.first() + "'", ex);
            }
        }
    };
    public static VncSpecialForm load_file = new VncSpecialForm("load-file", (VncVal)VncSpecialForm.meta().arglists("(load-file f)", "(load-file f force)", "(load-file f nsalias)", "(load-file f force nsalias)").doc("Sequentially read and evaluate the set of forms contained in the file.\n\nIf the file is found on one of the defined load paths it is read and the forms it contains are evaluated. If the file is not found an exception is raised.\n\nReturns a tuple with the file's name and the keyword `:loaded` if the file has been successfully loaded or `:already-loaded` if the file has been already loaded. Throws an exception on any loading error.\n\nWith 'force' set to `false` (the default) the file is only loaded once and interpreted once. Subsequent load attempts will be skipped. With 'force' set to `true` it is always loaded and interpreted.\n\nThe function is restricted to load files with the extension '.venice'. If the file extension is missing '.venice' will be implicitely added.\n\nAn optional namespace alias can passed:\n`(load-file \"coffee.venice\" ['coffee :as 'c])`\n\n`load-file` supports load paths. See the `loadpath/paths` doc for a description of the *load path* feature.").examples(";; With load-paths: [/users/foo/scripts]                              \n;;        -> loads: /users/foo/scripts/coffee.venice                  \n(load-file \"coffee\")                                                ", ";; With load-paths: [/users/foo/scripts]                              \n;;        -> loads: /users/foo/scripts/coffee.venice                  \n(load-file \"coffee.venice\")                                         ", ";; With load-paths: [/users/foo/scripts]                              \n;;        -> loads: /users/foo/scripts/beverages/coffee.venice        \n(load-file \"beverages/coffee\")                                      ", ";; With load-paths: [/users/foo/resources.zip]                        \n;;        -> loads: /users/foo/resources.zip!beverages/coffee.venice  \n(load-file \"beverages/coffee\")                                      ").seeAlso("load-classpath-file", "load-string", "load-module", "loadpath/paths").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            SpecialFormsUtil.specialFormCallValidation(ctx, "load-file");
            ArityExceptions.assertArity("load-file", ArityExceptions.FnType.SpecialForm, args, 1, 2, 3);
            VncString file = SpecialForms_LoadCodeMacros.getVeniceFile(env, args.first(), "load-file");
            Options options = SpecialForms_LoadCodeMacros.parseOptions(args, "load-file");
            VncBoolean forceOpt = options.force;
            VncVector aliasOpt = options.alias;
            3 var9_9 = this;
            synchronized (var9_9) {
                Namespace currNS = Namespaces.getCurrentNamespace();
                try {
                    boolean force = VncBoolean.isTrue(forceOpt);
                    IInterceptor interceptor = ThreadContext.getInterceptor();
                    boolean loaded = new CodeLoader().loadVeniceFile(file, ctx.getInterpreter(), interceptor, env, force, aliasOpt);
                    VncVector vncVector = VncVector.empty().addAtEnd(file).addAtEnd(new VncKeyword(loaded ? "loaded" : "already-loaded"));
                    return vncVector;
                }
                catch (VncException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new VncException("Failed to load the Venice file '" + args.first() + "'", ex);
                }
                finally {
                    Namespaces.setCurrentNamespace(currNS);
                }
            }
        }
    };
    public static VncSpecialForm load_classpath_file = new VncSpecialForm("load-classpath-file", (VncVal)VncSpecialForm.meta().arglists("(load-classpath-file f)", "(load-classpath-file f force)", "(load-classpath-file f nsalias)", "(load-classpath-file f force nsalias)").doc("Sequentially read and evaluate the set of forms contained in the classpath file. The function is restricted to classpath files with the extension '.venice'.\n\nReturns a tuple with the file's name and the keyword `:loaded` if the file has been successfully loaded or `:already-loaded` if the file has been already loaded. Throws an exception on any loading error.\n\nWith 'force' set to `false` (the default) the file is only loaded once and interpreted once. Subsequent load attempts will be skipped. With 'force' set to `true` it is always loaded and interpreted.\n\nLoaded files are cached by Venice and subsequent loads are just skipped. To enforce a reload call the file load with the force flag set to true:\n`(load-classpath-file \"com/github/jlangch/venice/test.venice\" true)`\n\nAn optional namespace alias can passed:\n`(load-classpath-file \"com/github/jlangch/venice/test.venice\" ['test :as 't])`\n\n`load-classpath-file` supports load paths. See the `loadpath/paths` doc for a description of the *load path* feature.").examples("(do                                                                              \n  (load-classpath-file \"com/github/jlangch/venice/test-support.venice\")        \n  (test-support/test-fn \"hello\"))                                              ", "(do                                                                              \n  (load-classpath-file \"com/github/jlangch/venice/test-support.venice\")        \n  (test-support/test-fn \"hello\")                                               \n  ; reload the classpath file                                                    \n  (ns-remove 'test-support)                                                      \n  (load-classpath-file \"com/github/jlangch/venice/test-support.venice\" true)   \n  (test-support/test-fn \"hello\"))                                              ", ";; namespace aliases                                                                             \n(do                                                                                              \n  (load-classpath-file \"com/github/jlangch/venice/test-support.venice\" ['test-support :as 't]) \n  (t/test-fn \"hello\"))                                                                         ").seeAlso("load-file", "load-string", "load-module", "loadpath/paths").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            SpecialFormsUtil.specialFormCallValidation(ctx, "load-classpath-file");
            ArityExceptions.assertArity("load-classpath-file", ArityExceptions.FnType.SpecialForm, args, 1, 2, 3);
            VncString file = SpecialForms_LoadCodeMacros.getVeniceFile(env, args.first(), "load-classpath-file");
            Options options = SpecialForms_LoadCodeMacros.parseOptions(args, "load-classpath-file");
            VncBoolean forceOpt = options.force;
            VncVector aliasOpt = options.alias;
            try {
                boolean force = VncBoolean.isTrue(forceOpt);
                IInterceptor interceptor = ThreadContext.getInterceptor();
                boolean loaded = new CodeLoader().loadVeniceClasspathFile(file, ctx.getInterpreter(), interceptor, env, force, aliasOpt);
                return VncVector.empty().addAtEnd(file).addAtEnd(new VncKeyword(loaded ? "loaded" : "already-loaded"));
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException("Failed to load the Venice classpath file '" + args.first() + "'", ex);
            }
        }
    };
    public static final Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(load_string).add(load_module).add(load_file).add(load_classpath_file).toMap();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Options parseOptions(VncList args, String fnName) {
        VncBoolean force = VncBoolean.False;
        VncVector alias = null;
        if (args.size() == 1) return new Options(force, alias);
        if (args.size() == 2) {
            if (Types.isVncBoolean(args.second())) {
                force = Coerce.toVncBoolean(args.second());
                return new Options(force, alias);
            } else {
                if (!Types.isVncVector(args.second())) throw new VncException(String.format("Function '%s' does not allow %s as 2nd arg! Expected a force flag or a ns alias.", fnName, Types.getType(args.second())));
                alias = Coerce.toVncVector(args.second());
            }
            return new Options(force, alias);
        } else {
            if (!Types.isVncBoolean(args.second())) {
                throw new VncException(String.format("Function '%s' does not allow %s as 2nd arg! Expected a force flag.", fnName, Types.getType(args.second())));
            }
            force = Coerce.toVncBoolean(args.second());
            if (!Types.isVncVector(args.third())) throw new VncException(String.format("Function '%s' does not allow %s as 3rd arg! Expected a ns alias.", fnName, Types.getType(args.third())));
            alias = Coerce.toVncVector(args.third());
        }
        return new Options(force, alias);
    }

    private static VncString getVeniceFile(Env env, VncVal arg, String fnName) {
        if (Types.isVncSymbol(arg)) {
            VncVal v = env.get((VncSymbol)arg);
            return SpecialForms_LoadCodeMacros.getVeniceFile(v, fnName);
        }
        return SpecialForms_LoadCodeMacros.getVeniceFile(arg, fnName);
    }

    private static VncString getVeniceFile(VncVal arg, String fnName) {
        if (Types.isVncString(arg)) {
            return SpecialForms_LoadCodeMacros.addVeniceFileExte((VncString)arg);
        }
        if (Types.isVncJavaObject(arg, File.class)) {
            return SpecialForms_LoadCodeMacros.addVeniceFileExte(new VncString(Coerce.toVncJavaObject(arg, File.class).getPath()));
        }
        if (Types.isVncJavaObject(arg, Path.class)) {
            return SpecialForms_LoadCodeMacros.addVeniceFileExte(new VncString(Coerce.toVncJavaObject(arg, Path.class).toFile().getPath()));
        }
        throw new VncException(String.format("Function '%s' does not allow %s as 1st arg! Expected a string or file.", fnName, Types.getType(arg)));
    }

    private static VncString addVeniceFileExte(VncString f) {
        String s = f.getValue();
        return s.endsWith(".venice") ? f : new VncString(s + ".venice");
    }

    private static class Options {
        final VncBoolean force;
        final VncVector alias;

        public Options(VncBoolean force, VncVector alias) {
            this.force = force;
            this.alias = alias;
        }
    }
}

