/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.impl.util.CommandLineArgs;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.Tuple2;
import com.github.jlangch.venice.impl.util.io.ClassPathResource;
import com.github.jlangch.venice.nanojson.JsonObject;
import com.github.jlangch.venice.nanojson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class ReplConfig {
    public static final String ANSI_RESET = "\u001b[0m";
    private static final String DEFAULT_PROMPT = "venice> ";
    private static final String DEFAULT_SECONDARY_PROMPT = "| ";
    private static final String DEFAULT_RESULT_PREFIX = "=> ";
    private static final List<String> COLOR_NAMES = Arrays.asList("command", "result", "stdout", "stderr", "debug", "error", "system", "interrupt", "prompt");
    private final String configSource;
    private volatile ColorMode colorMode;
    private final String loadFile;
    private final String prompt;
    private final String secondaryPrompt;
    private final String resultPrefix;
    private final boolean syntaxHighlighting;
    private final Level jlineLoglevel;
    private final boolean jlineDumbTerminal;
    private final boolean clearCmdHistoryOnExit;
    private final Map<String, String> colors = new HashMap<String, String>();

    private ReplConfig(String configSource, ColorMode colorMode, String loadFile, String prompt, String secondaryPrompt, String resultPrefix, boolean syntaxHighlighting, Level jlineLoglevel, boolean jlineDumbTerminal, boolean clearCmdHistoryOnExit, Map<String, String> colors) {
        this.configSource = configSource;
        this.colorMode = colorMode;
        this.loadFile = loadFile;
        this.prompt = ReplConfig.orDefault(prompt, DEFAULT_PROMPT);
        this.secondaryPrompt = ReplConfig.orDefault(secondaryPrompt, DEFAULT_SECONDARY_PROMPT);
        this.resultPrefix = ReplConfig.orDefault(resultPrefix, DEFAULT_RESULT_PREFIX);
        this.syntaxHighlighting = syntaxHighlighting;
        this.jlineLoglevel = jlineLoglevel;
        this.jlineDumbTerminal = jlineDumbTerminal;
        this.clearCmdHistoryOnExit = clearCmdHistoryOnExit;
        this.colors.putAll(colors);
    }

    public static ReplConfig load(CommandLineArgs cli) {
        HashMap<String, String> colors = new HashMap<String, String>();
        String loadFile = cli.switchValue("-load-file");
        try {
            Tuple2<JsonObject, String> cfg = ReplConfig.loadJsonConfig();
            JsonObject jsonObj = (JsonObject)cfg._1;
            String jsonConfigSource = (String)cfg._2;
            String prompt = jsonObj.getString("prompt");
            String secondaryPrompt = jsonObj.getString("secondary-prompt");
            String resultPrefix = jsonObj.getString("result-prefix");
            boolean clearCmdHistoryOnExit = jsonObj.getBoolean("clear-cmd-history-on-exit", false);
            ColorMode colorMode = ReplConfig.getColorMode(cli);
            JsonObject obj = (JsonObject)jsonObj.get("colors");
            if (obj != null) {
                for (String cname : COLOR_NAMES) {
                    colors.put("light." + cname, StringUtil.emptyToNull(obj.getString(cname)));
                }
            }
            if ((obj = (JsonObject)jsonObj.get("colors-darkmode")) != null) {
                for (String cname : COLOR_NAMES) {
                    colors.put("dark." + cname, StringUtil.emptyToNull(obj.getString(cname)));
                }
            }
            boolean highlight = true;
            obj = (JsonObject)jsonObj.get("syntax-highlighting");
            if (obj != null) {
                try {
                    highlight = obj.getBoolean("enabled", Boolean.TRUE);
                }
                catch (Exception cname) {
                    // empty catch block
                }
            }
            if (colorMode == ColorMode.None) {
                highlight = false;
            }
            Level jlineLoglevel = null;
            boolean jlineDumbTerminal = false;
            obj = (JsonObject)jsonObj.get("jline");
            if (obj != null) {
                try {
                    jlineLoglevel = Level.parse(obj.getString("loglevel"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    jlineDumbTerminal = obj.getBoolean("dumb-terminal", Boolean.FALSE);
                }
                catch (Exception ex) {
                    jlineDumbTerminal = true;
                }
            }
            return new ReplConfig(jsonConfigSource, colorMode, loadFile, prompt, secondaryPrompt, resultPrefix, highlight, jlineLoglevel, jlineDumbTerminal, clearCmdHistoryOnExit, colors);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to parse REPL json config file", ex);
        }
    }

    public void switchColorMode(ColorMode mode) {
        switch (mode) {
            case Light: {
                this.colorMode = ColorMode.Light;
                break;
            }
            case Dark: {
                this.colorMode = ColorMode.Dark;
                break;
            }
        }
    }

    public String getConfigSource() {
        return this.configSource;
    }

    public ColorMode getColorMode() {
        return this.colorMode;
    }

    public boolean isColorModeLight() {
        return this.colorMode == ColorMode.Light;
    }

    public boolean isColorModeDark() {
        return this.colorMode == ColorMode.Dark;
    }

    public boolean isColorModeNone() {
        return this.colorMode == ColorMode.None;
    }

    public String getColor(String key) {
        switch (this.colorMode) {
            case Light: {
                return this.lookupColor("light." + key);
            }
            case Dark: {
                return this.lookupColor("dark." + key);
            }
        }
        return null;
    }

    public String getLoadFile() {
        return this.loadFile;
    }

    public String getPrompt() {
        return this.getColor("prompt") == null ? this.prompt : this.getColor("prompt") + this.prompt + ANSI_RESET;
    }

    public String getSecondaryPrompt() {
        return this.getColor("secondary-prompt") == null ? this.secondaryPrompt : this.getColor("secondary-prompt") + this.secondaryPrompt + ANSI_RESET;
    }

    public String getResultPrefix() {
        return this.resultPrefix;
    }

    public boolean isSyntaxHighlighting() {
        return this.syntaxHighlighting;
    }

    public Level getJLineLogLevel() {
        return this.jlineLoglevel;
    }

    public boolean isJLineDumbTerminal() {
        return this.jlineDumbTerminal;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getJansiVersion() {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/fusesource/jansi/jansi.properties");){
            if (is == null) return null;
            Properties props = new Properties();
            props.load(is);
            String string = props.getProperty("version");
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public boolean isClearCommandHistoryOnExit() {
        return this.clearCmdHistoryOnExit;
    }

    public static String getDefaultClasspathConfig() {
        return new ClassPathResource("com/github/jlangch/venice/setup/repl.json").getResourceAsString("UTF-8");
    }

    public static String getLauncherScriptName() {
        return System.getProperty("os.name").startsWith("Windows") ? "repl.bat" : "repl.sh";
    }

    public static String getDefaultClasspathLauncherScript() {
        return new ClassPathResource("com/github/jlangch/venice/setup/" + ReplConfig.getLauncherScriptName()).getResourceAsString("UTF-8");
    }

    private String lookupColor(String key) {
        return StringUtil.emptyToNull(this.colors.get(key));
    }

    private static Tuple2<JsonObject, String> loadJsonConfig() throws Exception {
        File fileJson = new File("repl.json");
        if (fileJson.isFile()) {
            try (FileReader reader = new FileReader(fileJson);){
                Tuple2<JsonObject, String> tuple2 = new Tuple2<JsonObject, String>(JsonParser.object().from(reader), "file '" + fileJson.getPath() + "'");
                return tuple2;
            }
        }
        try {
            String clientConfig = new ClassPathResource("repl.json").getResourceAsString("UTF-8");
            if (clientConfig != null) {
                return new Tuple2<JsonObject, String>(JsonParser.object().from(clientConfig), "classpath custom 'repl.json'");
            }
        }
        catch (Exception clientConfig) {
            // empty catch block
        }
        String builtinConfig = ReplConfig.getDefaultClasspathConfig();
        if (builtinConfig != null) {
            return new Tuple2<JsonObject, String>(JsonParser.object().from(builtinConfig), "built-in default 'repl.json'");
        }
        throw new RuntimeException("Failed to find a 'repl.json' configuration");
    }

    private static ColorMode getColorMode(CommandLineArgs cli) {
        if (cli.switchPresent("-colors")) {
            return ColorMode.Light;
        }
        if (cli.switchPresent("-colors-light")) {
            return ColorMode.Light;
        }
        if (cli.switchPresent("-colors-lightmode")) {
            return ColorMode.Light;
        }
        if (cli.switchPresent("-colors-dark")) {
            return ColorMode.Dark;
        }
        if (cli.switchPresent("-colors-darkmode")) {
            return ColorMode.Dark;
        }
        return ColorMode.None;
    }

    private static String orDefault(String s, String sDefault) {
        return s == null ? sDefault : s;
    }

    public static enum ColorMode {
        Light,
        Dark,
        None;

    }
}

