/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.SecurityException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncLazySeq;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.MimeTypes;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.impl.util.VncFileIterator;
import com.github.jlangch.venice.impl.util.VncPathMatcher;
import com.github.jlangch.venice.impl.util.http.BasicAuthentication;
import com.github.jlangch.venice.impl.util.io.CharsetUtil;
import com.github.jlangch.venice.impl.util.io.ClassPathResource;
import com.github.jlangch.venice.impl.util.io.FileUtil;
import com.github.jlangch.venice.impl.util.io.IOStreamUtil;
import com.github.jlangch.venice.impl.util.io.InternetUtil;
import com.github.jlangch.venice.javainterop.IInterceptor;
import com.github.jlangch.venice.javainterop.ILoadPaths;
import com.github.jlangch.venice.util.OS;
import com.github.jlangch.venice.util.StopWatch;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.text.Normalizer;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.stream.Collectors;
import org.repackage.net.lingala.zip4j.util.FileUtils;

public class IOFunctions {
    public static VncFunction io_file = new VncFunction("io/file", (VncVal)VncFunction.meta().arglists("(io/file path)", "(io/file parent child)", "(io/file parent child & children)").doc("Returns a java.io.File from file path, or from a parent path and one or multiple children. The path and parent may be a file or a string (file path), child and children must be strings.").examples("(io/file \"/tmp/test.txt\")", "(io/file \"/temp\" \"test.txt\")", "(io/file \"/\" \"temp\" \"test\" \"test.txt\")", "(io/file (io/file \"/\" \"temp\") \"test\" \"test.txt\")", "(io/file (. :java.io.File :new \"/tmp/test.txt\"))", ";; Windows:\n;;   (io/file \"C:\\\\tmp\\\\test.txt\") \n;;   (io/file \"C:/tmp/test.txt\")", ";;   (io/file \"C:\" \"tmp\" \"test.txt\")").seeAlso("io/file-name", "io/file-parent", "io/file-path", "io/file-absolute", "io/file-canonical", "str/normalize-utf").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            File parent;
            ArityExceptions.assertMinArity(this, args, 1);
            if (args.size() == 1) {
                return new VncJavaObject(IOFunctions.convertToFile(args.first(), "Function 'io/file' does not allow %s as path"));
            }
            File file = parent = IOFunctions.convertToFile(args.first(), "Function 'io/file' does not allow %s as parent");
            for (VncVal child : args.rest()) {
                file = new File(file, Coerce.toVncString(child).getValue());
            }
            return new VncJavaObject(file);
        }
    };
    public static VncFunction io_file_size = new VncFunction("io/file-size", (VncVal)VncFunction.meta().arglists("(io/file-size f)").doc("Returns the size of the file f. f must be a file or a string (file path).").examples("(io/file-size \"/tmp/test.txt\")").seeAlso("io/file").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-size' does not allow %s as f");
            IOFunctions.validateReadableFile(f);
            return new VncLong(f.length());
        }
    };
    public static VncFunction io_file_path = new VncFunction("io/file-path", (VncVal)VncFunction.meta().arglists("(io/file-path f)").doc("Returns the path of the file f as a string. f must be a file or a string (file path).").examples("(io/file-path (io/file \"/tmp/test/x.txt\"))").seeAlso("io/file-absolute", "io/file-canonical", "io/file", "str/normalize-utf").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-path' does not allow %s as f");
            return new VncString(f.getPath());
        }
    };
    public static VncFunction io_file_path_slashify = new VncFunction("io/file-path-slashify", (VncVal)VncFunction.meta().arglists("(io/file-path-slashify f)").doc("Returns the path of the file f as a string, turns backslashes into slashes. \n\nf must be a file or a string (file path).\n\nC:\\Users\\foo\\image.png -> C:/Users/foo/image.png\n\nNote: Windows only. On other OSs works identical to 'io/file-path'.").examples("(io/file-path-slashify (io/file \"C:\" \"Users\" \"foo\" \"image.png\"))").seeAlso("io/file-path").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-path' does not allow %s as f");
            if (OS.isWindows()) {
                String p = f.getPath().replace('\\', '/').replaceAll("//", "/");
                return new VncString(p);
            }
            return new VncString(f.getPath());
        }
    };
    public static VncFunction io_file_canonical = new VncFunction("io/file-canonical", (VncVal)VncFunction.meta().arglists("(io/file-canonical f)").doc("Returns the canonical path of the file f. f must be a file or a string (file path).").examples("(io/file-canonical (io/file \"/tmp/test/../x.txt\"))").seeAlso("io/file-path", "io/file-absolute", "io/file", "str/normalize-utf").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            try {
                VncVal f = args.first();
                if (Types.isVncString(f)) {
                    return new VncString(new File(((VncString)f).getValue()).getCanonicalFile().getPath());
                }
                if (Types.isVncJavaObject(f, File.class)) {
                    return new VncJavaObject(Coerce.toVncJavaObject(f, File.class).getCanonicalFile());
                }
                if (Types.isVncJavaObject(f, Path.class)) {
                    return new VncJavaObject(Coerce.toVncJavaObject(f, Path.class).toFile().getCanonicalFile().toPath());
                }
                throw new VncException(String.format("Function 'io/file-canonical' does not allow %s as file arg", Types.getType(f)));
            }
            catch (IOException ex) {
                throw new VncException("Failed to get canonical file", ex);
            }
        }
    };
    public static VncFunction io_file_absolute = new VncFunction("io/file-absolute", (VncVal)VncFunction.meta().arglists("(io/file-absolute f)").doc("Returns the absolute path of the file f. f must be a file or a string (file path).").examples("(io/file-absolute (io/file \"/tmp/test/x.txt\"))").seeAlso("io/file-path", "io/file-canonical", "io/file", "io/file-absolute?", "str/normalize-utf").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal f = args.first();
            if (Types.isVncString(f)) {
                return new VncString(new File(((VncString)f).getValue()).getAbsolutePath());
            }
            if (Types.isVncJavaObject(f, File.class)) {
                return new VncJavaObject(Coerce.toVncJavaObject(f, File.class).getAbsoluteFile());
            }
            if (Types.isVncJavaObject(f, Path.class)) {
                return new VncJavaObject(Coerce.toVncJavaObject(f, Path.class).toFile().getAbsoluteFile().toPath());
            }
            throw new VncException(String.format("Function 'io/file-absolute' does not allow %s as file arg", Types.getType(f)));
        }
    };
    public static VncFunction io_file_absolute_Q = new VncFunction("io/file-absolute?", (VncVal)VncFunction.meta().arglists("(io/file-absolute? f)").doc("Returns true if file f has an absolute path else false. f must be a file or a string (file path).").examples("(io/file-absolute? (io/file \"/tmp/test/x.txt\"))").seeAlso("io/file-path", "io/file-canonical", "io/file", "io/file-absolute").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal f = args.first();
            if (Types.isVncString(f)) {
                return VncBoolean.of(new File(((VncString)f).getValue()).isAbsolute());
            }
            if (Types.isVncJavaObject(f, File.class)) {
                return VncBoolean.of(Coerce.toVncJavaObject(f, File.class).isAbsolute());
            }
            if (Types.isVncJavaObject(f, Path.class)) {
                return VncBoolean.of(Coerce.toVncJavaObject(f, Path.class).isAbsolute());
            }
            throw new VncException(String.format("Function 'io/file-absolute?' does not allow %s as file arg", Types.getType(f)));
        }
    };
    public static VncFunction io_file_parent = new VncFunction("io/file-parent", (VncVal)VncFunction.meta().arglists("(io/file-parent f)").doc("Returns the parent file of the file f. f must be a file or a string (file path).").examples("(io/file-path (io/file-parent (io/file \"/tmp/test/x.txt\")))").seeAlso("io/file-name", "io/file").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-parent' does not allow %s as f");
            File parent = f.getParentFile();
            return parent == null ? Constants.Nil : new VncJavaObject(parent);
        }
    };
    public static VncFunction io_file_name = new VncFunction("io/file-name", (VncVal)VncFunction.meta().arglists("(io/file-name f)").doc("Returns the name of the file f as a string. f must be a file or a string (file path).").examples("(io/file-name (io/file \"/tmp/test/x.txt\"))").seeAlso("io/file-basename", "io/file-parent", "io/file", "str/normalize-utf").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-name' does not allow %s as f");
            return new VncString(f.getName());
        }
    };
    public static VncFunction io_file_basename = new VncFunction("io/file-basename", (VncVal)VncFunction.meta().arglists("(io/file-basename f)").doc("Returns the base name (file name without file extension) of the file f as a string. f must be a file or a string (file path).").examples("(io/file-basename (io/file \"/tmp/test/x.txt\"))").seeAlso("io/file-name", "io/file-parent", "io/file-ext", "io/file", "str/normalize-utf").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-basename' does not allow %s as f");
            return new VncString(FileUtil.getFileBaseName(f.getName()));
        }
    };
    public static VncFunction io_to_path = new VncFunction("io/->path", (VncVal)VncFunction.meta().arglists("(io/->path f)").doc("Converts to a :java.nio.Path. f must be a file or a string (file path).").examples("(io/->path \"some.txt\")", "(io/->path \"/tmp/test/some.txt\")", "(io/->path (io/file \"/tmp/test/some\"))").seeAlso("io/path?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Path p = IOFunctions.convertToPath(args.first(), "Function 'io/->path' does not allow %s as f");
            return new VncJavaObject(p);
        }
    };
    public static VncFunction io_path_Q = new VncFunction("io/path?", (VncVal)VncFunction.meta().arglists("(io/path f)").doc("Returns true if f is a :java.nio.Path.").examples("(io/path? (io/->path \"some.txt\"))").seeAlso("io/->path").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncJavaObject(args.first(), Path.class));
        }
    };
    public static VncFunction io_file_ext_Q = new VncFunction("io/file-ext?", (VncVal)VncFunction.meta().arglists("(io/file-ext? f ext & exts)").doc("Returns true if the file f hast the extension ext. f must be a file or a string (file path).").examples("(io/file-ext? \"/tmp/test/x.txt\" \"txt\")", "(io/file-ext? (io/file \"/tmp/test/x.txt\") \".txt\")", "(io/file-ext? \"/tmp/test/x.docx\" \"doc\" \"docx\")").seeAlso("io/file-ext").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-ext?' does not allow %s as f");
            if (args.size() == 2) {
                String ext = Coerce.toVncString(args.second()).getValue();
                return VncBoolean.of(f.getName().endsWith(ext.startsWith(".") ? ext : "." + ext));
            }
            Set exts = args.slice(1).stream().map(v -> Coerce.toVncString(args.second()).getValue()).map(s -> s.startsWith(".") ? s.substring(1) : s).collect(Collectors.toSet());
            String fileExt = FileUtils.getFileExtension(f);
            return VncBoolean.of(exts.contains(fileExt));
        }
    };
    public static VncFunction io_file_ext = new VncFunction("io/file-ext", (VncVal)VncFunction.meta().arglists("(io/file-ext f)").doc("Returns the file extension of a file. f must be a file or a string (file path).").examples("(io/file-ext \"some.txt\")", "(io/file-ext \"/tmp/test/some.txt\")", "(io/file-ext \"/tmp/test/some\")").seeAlso("io/file-ext?", "io/file-basename").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-ext' does not allow %s as f");
            String ext = FileUtil.getFileExt(f.getName());
            return ext == null ? Constants.Nil : new VncString(ext);
        }
    };
    public static VncFunction io_file_normalize_utf = new VncFunction("io/file-normalize-utf", (VncVal)VncFunction.meta().arglists("(io/file-normalize-utf file)", "(io/file-normalize-utf file form)").doc("Normalizes the UTF string of a file path.\n\nOn MacOS file names with umlauts like \u00e4 are just encoded as 'a' plus the combining diaresis character. Therefore an '\u00e4' (\\u00FC) and an '\u00e4' (a + \\u0308) from a MacOS file name are different!\nUnder normal circumstances this not problem. But as soon as some file name processing is in place (comparing, matching, ...) this can result in strange behaviour due of the two different technical representations of umlaut characters.\n\nThe *form* argument defaults to :NFC and is one of:\n* :NFD  Canonical decomposition\n* :NFC  Canonical decomposition, followed by canonical composition\n* :NFKD  Compatibility decomposition\n* :NFKC  Compatibility decomposition, followed by canonical composition\n\nReturns an UTF normalized java.io.File from a file path\n\nSee the function `str/normalize-utf` for details on UTF normalization.").examples("(io/file-normalize-utf \"/tmp/test_u\\u0308.txt\")", "(io/file-normalize-utf (io/file \"/tmp/test_u\\u0308.txt\"))").seeAlso("str/normalize-utf").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            File file = IOFunctions.convertToFile(args.first(), "Function 'io/file-normalize-utf' does not allow %s as path");
            if (args.size() == 1) {
                return new VncJavaObject(IOFunctions.normalize(file, Normalizer.Form.NFC));
            }
            VncKeyword form = Coerce.toVncKeyword(args.second());
            switch (form.getValue()) {
                case "NFD": {
                    return new VncJavaObject(IOFunctions.normalize(file, Normalizer.Form.NFD));
                }
                case "NFC": {
                    return new VncJavaObject(IOFunctions.normalize(file, Normalizer.Form.NFC));
                }
                case "NFKD": {
                    return new VncJavaObject(IOFunctions.normalize(file, Normalizer.Form.NFKD));
                }
                case "NFKC": {
                    return new VncJavaObject(IOFunctions.normalize(file, Normalizer.Form.NFKC));
                }
            }
            throw new VncException("Function 'io/file-normalize-utf' invalid form argument " + form + ". Use one of {:NFD, :NFC, :NFKD, :NFKC}!");
        }
    };
    public static VncFunction io_file_Q = new VncFunction("io/file?", (VncVal)VncFunction.meta().arglists("(io/file? f)").doc("Returns true if x is a :java.io.File.").examples("(io/file? (io/file \"/tmp/test.txt\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncJavaObject(args.first(), File.class));
        }
    };
    public static VncFunction io_exists_Q = new VncFunction("io/exists?", (VncVal)VncFunction.meta().arglists("(io/exists? f)").doc("Returns true if the file  or directory f exists. f must be a file or a string (file path).").examples("(io/exists? \"/tmp/test.txt\")").seeAlso("io/exists-file?", "io/exists-dir?", "io/symbolic-link?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/exists?' does not allow %s as f");
            return VncBoolean.of(f.exists());
        }
    };
    public static VncFunction io_exists_file_Q = new VncFunction("io/exists-file?", (VncVal)VncFunction.meta().arglists("(io/exists-file? f)").doc("Returns true if the file f exists and is a file. f must be a file or a string (file path).").examples("(io/exists-file? \"/tmp/test.txt\")").seeAlso("io/exists-dir?", "io/symbolic-link?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/exists-file?' does not allow %s as f");
            return VncBoolean.of(f.isFile());
        }
    };
    public static VncFunction io_exists_dir_Q = new VncFunction("io/exists-dir?", (VncVal)VncFunction.meta().arglists("(io/exists-dir? f)").doc("Returns true if the file f exists and is a directory. f must be a file or a string (file path).").examples("(io/exists-dir? (io/file \"/temp\"))").seeAlso("io/exists-file?", "io/symbolic-link?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/exists-dir?' does not allow %s as f");
            return VncBoolean.of(f.isDirectory());
        }
    };
    public static VncFunction io_file_can_read_Q = new VncFunction("io/file-can-read?", (VncVal)VncFunction.meta().arglists("(io/file-can-read? f)").doc("Returns true if the file or directory f exists and can be read. f must be a file or a string (file path).").examples("(io/file-can-read? \"/tmp/test.txt\")").seeAlso("io/file-set-readable", "io/file-can-write?", "io/file-can-execute?", "io/file-hidden?", "io/symbolic-link?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-can-read?' does not allow %s as f");
            return VncBoolean.of((f.isFile() || f.isDirectory()) && f.canRead());
        }
    };
    public static VncFunction io_file_can_write_Q = new VncFunction("io/file-can-write?", (VncVal)VncFunction.meta().arglists("(io/file-can-write? f)").doc("Returns true if the file or directory f exists and can be written. f must be a file or a string (file path).").examples("(io/file-can-write? \"/tmp/test.txt\")").seeAlso("io/file-set-writable", "io/file-can-read?", "io/file-can-execute?", "io/file-hidden?", "io/symbolic-link?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-can-write?' does not allow %s as f");
            return VncBoolean.of((f.isFile() || f.isDirectory()) && f.canWrite());
        }
    };
    public static VncFunction io_file_can_execute_Q = new VncFunction("io/file-can-execute?", (VncVal)VncFunction.meta().arglists("(io/file-can-execute? f)").doc("Returns true if the file or directory f exists and can be executed. f must be a file or a string (file path).").examples("(io/file-can-execute? \"/tmp/test.txt\")").seeAlso("io/file-set-executable", "io/file-can-read?", "io/file-can-write?", "io/file-hidden?", "io/symbolic-link?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-can-execute?' does not allow %s as f");
            return VncBoolean.of((f.isFile() || f.isDirectory()) && f.canExecute());
        }
    };
    public static VncFunction io_file_set_readable = new VncFunction("io/file-set-readable", (VncVal)VncFunction.meta().arglists("(io/file-set-readable f readable owner-only)").doc("Set the owner\u2019s read permission to the file or directory f. f must be a file or a string (file path).\n\nReturns true if and only if the operation succeeded. The operation will fail if the user does not have permission to change the access permissions of this abstract pathname.  If 'readable' is false and the underlying file system does not implement a read permission, then the operation will fail.\n\nIf 'readable' is true sets the access permission to allow read operations; if false to disallow read operations. \n\nIf 'owner-only' is true the read permission applies only to the owner's read permission; otherwise, it applies to everybody. If the underlying file system can not distinguish the owner's read permission from that of others, then the permission will apply to everybody, regardless of this value.").examples("(io/file-set-readable \"/tmp/test.txt\" true true)").seeAlso("io/file-can-read?", "io/file-set-writable", "io/file-set-executable").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-set-readable' does not allow %s as f");
            boolean on = Coerce.toVncBoolean(args.second()).getValue();
            boolean ownerOnly = Coerce.toVncBoolean(args.third()).getValue();
            return VncBoolean.of(f.setReadable(on, ownerOnly));
        }
    };
    public static VncFunction io_file_set_writable = new VncFunction("io/file-set-writable", (VncVal)VncFunction.meta().arglists("(io/file-set-writable f writable owner-only)").doc("Set the owner\u2019s write permission to the file or directory f. f must be a file or a string (file path).\n\nReturns true if and only if the operation succeeded. The operation will fail if the user does not have permission to change the access permissions of this abstract pathname.  If 'writable' is false and the underlying file system does not implement a read permission, then the operation will fail.\n\nIf 'writable' is true sets the access permission to allow write operations; if false to disallow write operations. \n\nIf 'owner-only' is true the write permission applies only to the owner's write permission; otherwise, it applies to everybody. If the underlying file system can not distinguish the owner's write permission from that of others, then the permission will apply to everybody, regardless of this value.").examples("(io/file-set-writable \"/tmp/test.txt\" true true)").seeAlso("io/file-can-write?", "io/file-set-readable", "io/file-set-executable").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-set-readable' does not allow %s as f");
            boolean on = Coerce.toVncBoolean(args.second()).getValue();
            boolean ownerOnly = Coerce.toVncBoolean(args.third()).getValue();
            return VncBoolean.of(f.setWritable(on, ownerOnly));
        }
    };
    public static VncFunction io_file_set_executable = new VncFunction("io/file-set-executable", (VncVal)VncFunction.meta().arglists("(io/file-set-executable f executable owner-only)").doc("Set the owner\u2019s execute permission to the file or directory f. f must be a file or a string (file path).\n\nReturns true if and only if the operation succeeded. The operation will fail if the user does not have permission to change the access permissions of this abstract pathname.  If 'readable' is false and the underlying file system does not implement a read permission, then the operation will fail.\n\nIf 'executable' is true sets the access permission to allow execute operations; if false to disallow execute operations. \n\nIf 'owner-only' is true the execute permission applies only to the owner's execute permission; otherwise, it applies to everybody. If the underlying file system can not distinguish the owner's execute permission from that of others, then the permission will apply to everybody, regardless of this value.").examples("(io/file-set-executable \"/tmp/test.txt\" true true)").seeAlso("io/file-can-execute?", "io/file-set-readable", "io/file-set-writable").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-set-executable' does not allow %s as f");
            boolean on = Coerce.toVncBoolean(args.second()).getValue();
            boolean ownerOnly = Coerce.toVncBoolean(args.third()).getValue();
            return VncBoolean.of(f.setExecutable(on, ownerOnly));
        }
    };
    public static VncFunction io_file_hidden_Q = new VncFunction("io/file-hidden?", (VncVal)VncFunction.meta().arglists("(io/file-hidden? f)").doc("Returns true if the file or directory f exists and is hidden. f must be a file or a string (file path).").examples("(io/file-hidden? \"/tmp/test.txt\")").seeAlso("io/file-can-read?", "io/file-can-write?", "io/file-can-execute?", "io/symbolic-link?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-hidden?' does not allow %s as f");
            return VncBoolean.of((f.isFile() || f.isDirectory()) && f.isHidden());
        }
    };
    public static VncFunction io_symbolic_link_Q = new VncFunction("io/symbolic-link?", (VncVal)VncFunction.meta().arglists("(io/symbolic-link? f)").doc("Returns true if the file f exists and is a symbolic link. f must be a file or a string (file path).").examples("(io/symbolic-link? \"/tmp/test.txt\")").seeAlso("io/file-hidden?", "io/file-can-read?", "io/file-can-write?", "io/file-can-execute?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/symbolic-link?' does not allow %s as f");
            Path p = f.toPath();
            return VncBoolean.of(Files.isSymbolicLink(p));
        }
    };
    public static VncFunction io_create_symbolic_link = new VncFunction("io/create-symbolic-link", (VncVal)VncFunction.meta().arglists("(io/create-symbolic-link link target)").doc("Creates a symbolic link to a target. \nlink and target must be a file or a string (file path).").examples("(io/create-symbolic-link \"/tmp/sym-link\" \"/tmp/test.txt\")").seeAlso("io/create-hard-link", "io/symbolic-link?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            File link = IOFunctions.convertToFile(args.first(), "Function 'io/create-symbolic-link' does not allow %s as link");
            File target = IOFunctions.convertToFile(args.second(), "Function 'io/create-symbolic-link' does not allow %s as target");
            try {
                Files.createSymbolicLink(link.toPath(), target.toPath(), new FileAttribute[0]);
                return Constants.Nil;
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to create symbolic link %s -> %s", link, target), ex);
            }
        }
    };
    public static VncFunction io_create_hard_link = new VncFunction("io/create-hard-link", (VncVal)VncFunction.meta().arglists("(io/create-hard-link link target)").doc("Creates a hard link to a target. \nlink and target must be a file or a string (file path).").examples("(io/create-hard-link \"/tmp/hard-link\" \"/tmp/test.txt\")").seeAlso("io/create-symbolic-link", "io/symbolic-link?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            File link = IOFunctions.convertToFile(args.first(), "Function 'io/create-hard-link' does not allow %s as link");
            File target = IOFunctions.convertToFile(args.second(), "Function 'io/create-hard-link' does not allow %s as target");
            try {
                Files.createLink(link.toPath(), target.toPath());
                return Constants.Nil;
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to create hard link %s -> %s", link, target), ex);
            }
        }
    };
    public static VncFunction io_file_last_modified = new VncFunction("io/file-last-modified", (VncVal)VncFunction.meta().arglists("(io/file-last-modified f)").doc("Returns the last modification time (a Java LocalDateTime) of f or nil if f does not exist. f must be a file or a string (file path).").examples("(io/file-last-modified \"/tmp/test.txt\")").seeAlso("io/file-can-read?", "io/file-can-write?", "io/file-can-execute?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-last-modified' does not allow %s as f");
            if (f.exists()) {
                long millis = f.lastModified();
                return new VncJavaObject(Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault()).toLocalDateTime());
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_file_within_dir_Q = new VncFunction("io/file-within-dir?", (VncVal)VncFunction.meta().arglists("(io/file-within-dir? dir file)").doc("Returns true if the file is within the dir else false.\n\nThe file and dir args must be absolute paths.").examples("(io/file-within-dir? (io/file \"/temp/foo\")          \n                     (io/file \"/temp/foo/img.png\")) ", "(io/file-within-dir? (io/file \"/temp/foo\")                 \n                     (io/file \"/temp/foo/../bar/img.png\")) ").seeAlso("io/file").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            Path dir = IOFunctions.convertToPath(args.first());
            Path file = IOFunctions.convertToPath(args.second());
            if (file == null) {
                throw new VncException(String.format("Function 'io/file-within-dir?' does not allow %s as file arg", Types.getType(args.second())));
            }
            if (dir == null) {
                throw new VncException(String.format("Function 'io/file-within-dir?' does not allow %s as dir arg", Types.getType(args.first())));
            }
            if (!file.isAbsolute()) {
                throw new VncException("Function 'io/file-within-dir?' required an absolute path for file");
            }
            if (!dir.isAbsolute()) {
                throw new VncException("Function 'io/file-within-dir?' required an absolute path for dir");
            }
            return VncBoolean.of(file.normalize().startsWith(dir.normalize()));
        }
    };
    public static VncFunction io_glob_path_matcher = new VncFunction("io/glob-path-matcher", (VncVal)VncFunction.meta().arglists("(io/glob-path-matcher pattern)").doc("Returns a file matcher for glob file patterns.\n\n" + IOFunctions.globPatternHelp()).examples("(io/glob-path-matcher \"*.log\")", "(io/glob-path-matcher \"**/*.log\")").seeAlso("io/file-matches-glob?", "io/list-files-glob").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            String searchPattern = Coerce.toVncString(args.first()).getValue();
            PathMatcher m = FileSystems.getDefault().getPathMatcher("glob:" + searchPattern);
            return new VncJavaObject(new VncPathMatcher(m));
        }
    };
    public static VncFunction io_file_matches_globQ = new VncFunction("io/file-matches-glob?", (VncVal)VncFunction.meta().arglists("(io/file-matches-glob? glob f)").doc("Returns true if the file f matches the glob pattern. f must be a file or a string (file path).\n\n" + IOFunctions.globPatternHelp()).examples("(io/file-matches-glob? \"*.log\" \"file.log\")", "(io/file-matches-glob? \"**/*.log\" \"x/y/file.log\")", "(io/file-matches-glob? \"**/*.log\" \"file.log\") ; take care, doesn't match!", "(io/file-matches-glob? (io/glob-path-matcher \"*.log\") (io/file \"file.log\"))", "(io/file-matches-glob? (io/glob-path-matcher \"**/*.log\") (io/file \"x/y/file.log\"))").seeAlso("io/glob-path-matcher", "io/list-files-glob").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            PathMatcher m = null;
            if (Types.isVncString(args.first())) {
                String searchPattern = Coerce.toVncString(args.first()).getValue();
                m = FileSystems.getDefault().getPathMatcher("glob:" + searchPattern);
            } else if (Types.isVncJavaObject(args.first(), VncPathMatcher.class)) {
                m = Coerce.toVncJavaObject(args.first(), VncPathMatcher.class).getPathMatcher();
            } else {
                throw new VncException(String.format("Function 'io/file-matches-glob?' does not allow %s as argument one", args.first().getType()));
            }
            File f = IOFunctions.convertToFile(args.second(), "Function 'io/file-matches-glob?' does not allow %s as f");
            return VncBoolean.of(m.matches(f.toPath()));
        }
    };
    public static VncFunction io_to_url = new VncFunction("io/->url", (VncVal)VncFunction.meta().arglists("(io/->url s)", "(io/->url protocol host port file)").doc("Converts s to an URL or builds an URL from its spec elements. \n\ns may be:                   \n\n  * a string (a spec string to be parsed as a URL.)    \n  * a `java.io.File`          \n  * a `java.nio.file.Path`    \n  * a `java.net.URI`\n\nArguments:\u00b6\u2001**protocol**\u2003the name of the protocol to use.\u00b6\u2001**host**\u2003the name of the host.\u00b6\u2001**port**\u2003the port number on the host.\u00b6\u2001**file**\u2003the file on the host").examples("(io/->url \"file:/tmp/test.txt\")", "(io/->url (io/file \"/tmp/test.txt\"))", "(io/->url (io/->uri (io/file \"/tmp/test.txt\")))", "(str (io/->url (io/file \"/tmp/test.txt\")))", ";; to create an URL from spec details: \n(io/->url \"http\" \"foo.org\" 8080 \"/info.html\")").seeAlso("io/file", "io/->uri").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 4);
            try {
                if (args.size() == 1) {
                    VncVal f = args.first();
                    if (Types.isVncString(f)) {
                        return new VncJavaObject(new URL(((VncString)f).getValue()));
                    }
                    if (Types.isVncJavaObject(f, File.class)) {
                        File file = (File)((VncJavaObject)f).getDelegate();
                        return new VncJavaObject(file.toURI().toURL());
                    }
                    if (Types.isVncJavaObject(f, Path.class)) {
                        Path path = (Path)((VncJavaObject)f).getDelegate();
                        return new VncJavaObject(path.toUri().toURL());
                    }
                    if (Types.isVncJavaObject(args.first(), URL.class)) {
                        return args.first();
                    }
                    if (Types.isVncJavaObject(args.first(), URI.class)) {
                        VncJavaObject obj = (VncJavaObject)args.first();
                        return new VncJavaObject(((URI)obj.getDelegate()).toURL());
                    }
                    throw new VncException("Function 'io/->url' does not allow %s as argument");
                }
                VncVal protocol = args.nth(0);
                VncVal host = args.nth(1);
                VncVal port = args.nth(2);
                VncVal file = args.nth(3);
                return new VncJavaObject(new URL(protocol == Constants.Nil ? null : Coerce.toVncString(protocol).getValue(), host == Constants.Nil ? null : Coerce.toVncString(host).getValue(), port == Constants.Nil ? -1 : Coerce.toVncLong(port).getIntValue(), file == Constants.Nil ? null : Coerce.toVncString(file).getValue()));
            }
            catch (MalformedURLException ex) {
                throw new VncException("Malformed URL: " + ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction io_to_uri = new VncFunction("io/->uri", (VncVal)VncFunction.meta().arglists("(io/->uri s)", "(io/->uri scheme user-info host port path)", "(io/->uri scheme user-info host port path query)", "(io/->uri scheme user-info host port path query fragment)").doc("Converts s to an URI or builds an URI from its spec elements.\n\ns may be:                   \n\n  * a string (a spec string to be parsed as a URI.)    \n  * a `java.io.File`          \n  * a `java.nio.file.Path`    \n  * a `java.net.URL`        \n\nArguments:\u00b6\u2001**scheme**\u2003Scheme name\u00b6\u2001**userInfo**\u2003User name and authorization information\u00b6\u2001**host**\u2003Host name\u00b6\u2001**port**\u2003Port number\u00b6\u2001**path**\u2003Path\u00b6\u2001**query**\u2003Query\u00b6\u2001**fragment**\u2003Fragment").examples("(io/->uri \"file:/tmp/test.txt\")", "(io/->uri (io/file \"/tmp/test.txt\"))", "(io/->uri (io/->url (io/file \"/tmp/test.txt\")))", "(str (io/->uri (io/file \"/tmp/test.txt\")))", ";; to create an URL from spec details: \n(io/->uri \"http\" nil \"foo.org\" 8080 \"/info.html\" nil nil)").seeAlso("io/file", "io/->url").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 5, 6, 7);
            try {
                if (args.size() == 1) {
                    VncVal f = args.first();
                    if (Types.isVncString(f)) {
                        return new VncJavaObject(new URI(((VncString)f).getValue()));
                    }
                    if (Types.isVncJavaObject(f, File.class)) {
                        File file = (File)((VncJavaObject)f).getDelegate();
                        return new VncJavaObject(file.toURI());
                    }
                    if (Types.isVncJavaObject(f, Path.class)) {
                        Path path = (Path)((VncJavaObject)f).getDelegate();
                        return new VncJavaObject(path.toUri());
                    }
                    if (Types.isVncJavaObject(args.first(), URI.class)) {
                        return args.first();
                    }
                    if (Types.isVncJavaObject(args.first(), URL.class)) {
                        VncJavaObject obj = (VncJavaObject)args.first();
                        return new VncJavaObject(((URL)obj.getDelegate()).toURI());
                    }
                    throw new VncException(String.format("Function 'io/->uri' does not allow %s as argument", f.getType()));
                }
                VncVal scheme = args.nth(0);
                VncVal userInfo = args.nth(1);
                VncVal host = args.nth(2);
                VncVal port = args.nth(3);
                VncVal path = args.nth(4);
                VncVal query = args.nthOrDefault(5, Constants.Nil);
                VncVal fragment = args.nthOrDefault(6, Constants.Nil);
                return new VncJavaObject(new URI(scheme == Constants.Nil ? null : Coerce.toVncString(scheme).getValue(), userInfo == Constants.Nil ? null : Coerce.toVncString(userInfo).getValue(), host == Constants.Nil ? null : Coerce.toVncString(host).getValue(), port == Constants.Nil ? -1 : Coerce.toVncLong(port).getIntValue(), path == Constants.Nil ? null : Coerce.toVncString(path).getValue(), query == Constants.Nil ? null : Coerce.toVncString(query).getValue(), fragment == Constants.Nil ? null : Coerce.toVncString(fragment).getValue()));
            }
            catch (URISyntaxException ex) {
                throw new VncException("Malformed URI: " + ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction io_truncate_from_start_keep_lines = new VncFunction("io/truncate-from-start-keep-lines", (VncVal)VncFunction.meta().arglists("(io/truncate-from-start-keep-lines f max-size)").doc("Truncates a text file to the given max size beginning at the start, honoring complete lines. \n\nThe ideal `cutoff` position is `file-size - max-size`. If there is no newline found after cutoff, the tail is a single (too long) line; to keep line integrity and size limit, keep nothing. If there is a newline found after cutoff, the effective cutoff will be the character position after the newline.\n\nf must be a file or a string (file path).").examples("(io/truncate-from-start-keep-lines \"/tmp/test.txt\" 1_000_000)").seeAlso("io/file").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/truncate-from-start-keep-lines' does not allow %s as f");
            long maxBytes = Coerce.toVncLong(args.second()).toJavaLong();
            IOFunctions.validateReadableFile(f);
            Path filePath = f.toPath();
            try {
                long startPos;
                long fileSize = Files.size(filePath);
                if (fileSize <= maxBytes) {
                    return Constants.Nil;
                }
                long cutoff = fileSize - maxBytes;
                try (RandomAccessFile raf = new RandomAccessFile(filePath.toFile(), "r");){
                    int b;
                    raf.seek(cutoff);
                    startPos = -1L;
                    while ((b = raf.read()) != -1) {
                        if (b != 10) continue;
                        startPos = raf.getFilePointer();
                        break;
                    }
                    if (startPos == -1L) {
                        startPos = fileSize;
                    }
                }
                Path dir = filePath.getParent();
                if (dir == null) {
                    dir = Paths.get(".", new String[0]);
                }
                Path tempFile = Files.createTempFile(dir, "truncate-", ".tmp", new FileAttribute[0]);
                try {
                    try (FileInputStream in = new FileInputStream(filePath.toFile());
                         FileOutputStream out = new FileOutputStream(tempFile.toFile());){
                        int read;
                        long n;
                        for (long skipped = 0L; skipped < startPos && (n = ((InputStream)in).skip(startPos - skipped)) > 0L; skipped += n) {
                        }
                        byte[] buf = new byte[8192];
                        while ((read = ((InputStream)in).read(buf)) != -1) {
                            ((OutputStream)out).write(buf, 0, read);
                        }
                    }
                    try {
                        Files.move(tempFile, filePath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                    }
                    catch (AtomicMoveNotSupportedException e) {
                        Files.move(tempFile, filePath, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException ex) {
                    try {
                        Files.deleteIfExists(tempFile);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw ex;
                }
            }
            catch (Exception ex) {
                throw new VncException("Failed to truncate text file " + f, ex);
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_delete_file = new VncFunction("io/delete-file", (VncVal)VncFunction.meta().arglists("(io/delete-file f & files)").doc("Deletes one or multiple files. Silently skips delete if the file does not exist. If f is a directory the directory must be empty. f must be a file or a string (file path).").seeAlso("io/delete-files-glob", "io/delete-file-tree", "io/delete-file-on-exit", "io/copy-file", "io/move-file").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 0);
            IInterceptor interceptor = this.sandboxFunctionCallValidation();
            ILoadPaths loadpaths = interceptor.getLoadPaths();
            for (VncVal f : args) {
                try {
                    File file = IOFunctions.convertToFile(f, "Function 'io/delete-file' does not allow %s as f");
                    Path path = loadpaths.normalize(file).toPath();
                    Files.deleteIfExists(path);
                }
                catch (Exception ex) {
                    throw new VncException(String.format("Failed to delete file %s", f.toString()), ex);
                }
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_delete_file_tree = new VncFunction("io/delete-file-tree", (VncVal)VncFunction.meta().arglists("(io/delete-file-tree f & files)").doc("Deletes a file or a directory with all its content. Silently skips delete if the file or directory does not exist. f must be a file or a string (file path)").seeAlso("io/delete-files-glob", "io/delete-file", "io/delete-file-on-exit").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            args.forEach((Consumer<? super VncVal>)((Consumer<VncVal>)f -> {
                File file = IOFunctions.convertToFile(f, "Function 'io/delete-file-tree' does not allow %s as f");
                if (file.isDirectory()) {
                    try {
                        Files.walk(file.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                    }
                    catch (Exception ex) {
                        throw new VncException(String.format("Failed to delete file tree from dir %s", file.toString()), ex);
                    }
                    if (file.isDirectory()) {
                        throw new VncException(String.format("Failed to delete file tree from dir %s", file.toString()));
                    }
                } else if (file.isFile() && !file.delete()) {
                    throw new VncException(String.format("Failed to delete file %s", file.toString()));
                }
            }));
            return Constants.Nil;
        }
    };
    public static VncFunction io_delete_file_on_exit = new VncFunction("io/delete-file-on-exit", (VncVal)VncFunction.meta().arglists("(io/delete-file-on-exit f & fs)").doc("Requests that the files or directories be deleted when the virtual machine terminates. Files (or directories) are deleted in the reverse order that they are registered. Invoking this method to delete a file or directory that is already registered for deletion has no effect. Deletion will be attempted only for normal termination of the virtual machine, as defined by the Java Language Specification.\n\nf must be a file or a string (file path).").examples("(let [file1 (io/temp-file \"test-\", \".data\")    \n      file2 (io/temp-file \"test-\", \".data\")]   \n  (io/delete-file-on-exit file1 file2)             \n  (io/spit file1 \"123\")                          \n  (io/spit file2 \"ABC\"))                         ").seeAlso("io/delete-file", "io/delete-file-tree", "io/delete-files-glob").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            args.forEach((Consumer<? super VncVal>)((Consumer<VncVal>)arg -> {
                File file = IOFunctions.convertToFile(arg, "Function 'io/delete-file-on-exit' does not allow %s as f");
                IOFunctions.validateReadableFileOrDirectory(file);
                try {
                    file.deleteOnExit();
                }
                catch (Exception ex) {
                    throw new VncException(String.format("Failed to mark file %s to be deleted on exit", file.getPath()), ex);
                }
            }));
            return Constants.Nil;
        }
    };
    public static VncFunction io_list_files = new VncFunction("io/list-files", (VncVal)VncFunction.meta().arglists("(io/list-files dir)", "(io/list-files dir filter-fn)").doc("Lists files in a directory. dir must be a file or a string (file path). `filter-fn` is an optional filter that filters the files found. The filter gets a `java.io.File` as argument. \n\nReturns files as `java.io.File`").examples("(io/list-files \"/tmp\")", "(io/list-files \"/tmp\" #(io/file-ext? % \".log\"))").seeAlso("io/list-files-glob", "io/list-file-tree", "io/list-file-tree-lazy").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            this.sandboxFunctionCallValidation();
            File dir = IOFunctions.convertToFile(args.first(), "Function 'io/list-files' does not allow %s as dir");
            IOFunctions.validateReadableDirectory(dir);
            try {
                VncFunction filterFn;
                VncFunction vncFunction = filterFn = args.size() == 2 ? Coerce.toVncFunction(args.second()) : null;
                if (filterFn != null) {
                    filterFn.sandboxFunctionCallValidation();
                }
                ArrayList<VncJavaObject> files = new ArrayList<VncJavaObject>();
                for (File f : dir.listFiles()) {
                    if (filterFn != null && !VncBoolean.isTrue(filterFn.apply(VncList.of(new VncJavaObject(f))))) continue;
                    files.add(new VncJavaObject(f));
                }
                return VncList.ofList(files);
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to list files %s", dir.getPath()), ex);
            }
        }
    };
    public static VncFunction io_list_file_tree = new VncFunction("io/list-file-tree", (VncVal)VncFunction.meta().arglists("(io/list-file-tree dir)", "(io/list-file-tree dir filter-fn)").doc("Lists all files in a directory tree. dir must be a file or a string (file path). `filter-fn` is an optional filter that filters the files found. The filter gets a `java.io.File` as argument. \n\nReturns files as `java.io.File`").examples("(io/list-file-tree \"/tmp\")", "(io/list-file-tree \"/tmp\" #(io/file-ext? % \".log\"))").seeAlso("io/list-file-tree-lazy", "io/list-files", "io/list-files-glob").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            this.sandboxFunctionCallValidation();
            File dir = IOFunctions.convertToFile(args.first(), "Function 'io/list-file-tree' does not allow %s as dir");
            IOFunctions.validateReadableDirectory(dir);
            try {
                VncFunction filterFn;
                VncFunction vncFunction = filterFn = args.size() == 2 ? Coerce.toVncFunction(args.second()) : null;
                if (filterFn != null) {
                    filterFn.sandboxFunctionCallValidation();
                }
                ArrayList files = new ArrayList();
                Files.walk(dir.toPath(), new FileVisitOption[0]).map(Path::toFile).forEach(f -> {
                    if (filterFn == null || VncBoolean.isTrue(filterFn.apply(VncList.of(new VncJavaObject(f))))) {
                        files.add(new VncJavaObject(f));
                    }
                });
                return VncList.ofList(files);
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to list files from %s", dir.getPath()), ex);
            }
        }
    };
    public static VncFunction io_list_file_tree_lazy = new VncFunction("io/list-file-tree-lazy", (VncVal)VncFunction.meta().arglists("(io/list-file-tree-lazy dir)", "(io/list-file-tree-lazy dir filter-fn)").doc("Returns a lazy sequence of all the files in a directory tree. dir must be a file or a string (file path). `filter-fn` is an optional filter that filters the files found. The filter gets a `java.io.File` as argument. \n\nThe lazy sequence returns files as `java.io.File`").examples("(->> (io/list-file-tree-lazy \"/tmp\")  \n     (docoll println))                  ", "(->> (io/list-file-tree-lazy \"/tmp\" #(io/file-ext? % \".log\"))  \n     (docoll println))                                             ").seeAlso("io/list-file-tree", "io/list-files", "io/list-files-glob").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            this.sandboxFunctionCallValidation();
            File dir = IOFunctions.convertToFile(args.first(), "Function 'io/list-file-tree-lazy' does not allow %s as dir");
            IOFunctions.validateReadableDirectory(dir);
            try {
                VncFunction filterFn;
                VncFunction vncFunction = filterFn = args.size() == 2 ? Coerce.toVncFunction(args.second()) : null;
                if (filterFn != null) {
                    filterFn.sandboxFunctionCallValidation();
                }
                return VncLazySeq.ofAll(new VncFileIterator(dir, filterFn), (VncVal)Constants.Nil);
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to list files from %s", dir.getPath()), ex);
            }
        }
    };
    public static VncFunction io_list_files_glob = new VncFunction("io/list-files-glob", (VncVal)VncFunction.meta().arglists("(io/list-files-glob dir glob)").doc("Lists all files in a directory that match the glob pattern. dir must be a file or a string (file path). \nReturns files as `java.io.File`\n\n" + IOFunctions.globPatternHelp()).examples("(io/list-files-glob \".\" \"sample*.txt\")").seeAlso("io/list-files", "io/list-file-tree", "io/list-file-tree-lazy").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            File dir = IOFunctions.convertToFile(args.first(), "Function 'io/list-files-glob' does not allow %s as dir");
            String glob = Coerce.toVncString(args.second()).getValue();
            IOFunctions.validateReadableDirectory(dir);
            ArrayList files = new ArrayList();
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(dir.toPath(), glob);){
                dirStream.forEach(path -> files.add(new VncJavaObject(path.toFile())));
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to list files %s", dir.getPath()), ex);
            }
            return VncList.ofList(files);
        }
    };
    public static VncFunction io_delete_files_glob = new VncFunction("io/delete-files-glob", (VncVal)VncFunction.meta().arglists("(io/delete-files-glob dir glob)").doc("Removes all files in a directory that match the glob pattern. dir must be a file or a string (file path).\n\n" + IOFunctions.globPatternHelp()).examples("(io/delete-files-glob \".\" \"*.log\")").seeAlso("io/delete-file", "io/delete-file-tree", "io/move-files-glob", "io/copy-files-glob", "io/list-files-glob").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            File dir = IOFunctions.convertToFile(args.first(), "Function 'io/delete-files-glob' does not allow %s as dir");
            String glob = Coerce.toVncString(args.second()).getValue();
            IOFunctions.validateReadableDirectory(dir);
            ArrayList files = new ArrayList();
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(dir.toPath(), glob);){
                dirStream.forEach(path -> {
                    files.add(new VncJavaObject(path.toFile()));
                    try {
                        Files.delete(path);
                    }
                    catch (IOException ex) {
                        throw new VncException(String.format("Failed to delete file %s", path), ex);
                    }
                });
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to delete files from %s, glob: %s ", dir.getPath(), glob), ex);
            }
            return VncList.ofList(files);
        }
    };
    public static VncFunction io_copy_file = new VncFunction("io/copy-file", (VncVal)VncFunction.meta().arglists("(io/copy-file source dest & options)").doc("Copies source to dest. Returns nil or throws a VncException. Source must be a file or a string (file path), dest must be a file, a string (file path), or an `java.io.OutputStream`.\n\nOptions: \n\n| [![width: 25%]] | [![width: 75%]] |\n| :replace true/false | e.g.: if true replace an existing file, defaults to false |\n| :copy-attributes true/false | e.g.: if true copy attributes to the new file, defaults to false |\n| :no-follow-links true/false | e.g.: if true do not follow symbolic links, defaults to false |\n").seeAlso("io/copy-files-glob", "io/copy-file-tree", "io/move-file", "io/delete-file", "io/touch-file", "io/copy-stream").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            VncHashMap options = VncHashMap.ofAll(args.rest().rest());
            VncVal replaceOpt = options.get(new VncKeyword("replace"));
            VncVal copyAttrOpt = options.get(new VncKeyword("copy-attributes"));
            VncVal noFollowLinks = options.get(new VncKeyword("no-follow-links"));
            File sourceFile = IOFunctions.convertToFile(args.first(), "Function 'io/copy-file' does not allow %s as source");
            VncVal destVal = args.second();
            File destFile = IOFunctions.convertToFile(destVal);
            if (destFile != null) {
                ArrayList<Enum> copyOptions = new ArrayList<Enum>();
                if (VncBoolean.isTrue(replaceOpt)) {
                    copyOptions.add(StandardCopyOption.REPLACE_EXISTING);
                }
                if (VncBoolean.isTrue(copyAttrOpt)) {
                    copyOptions.add(StandardCopyOption.COPY_ATTRIBUTES);
                }
                if (VncBoolean.isTrue(noFollowLinks)) {
                    copyOptions.add(LinkOption.NOFOLLOW_LINKS);
                }
                try {
                    if (destFile.isDirectory()) {
                        Files.copy(sourceFile.toPath(), destFile.toPath().resolve(sourceFile.getName()), copyOptions.toArray(new CopyOption[0]));
                    }
                    Files.copy(sourceFile.toPath(), destFile.toPath(), copyOptions.toArray(new CopyOption[0]));
                }
                catch (Exception ex) {
                    throw new VncException(String.format("Failed to copy file %s to %s", sourceFile.getPath(), destFile.getPath()), ex);
                }
            } else if (Types.isVncJavaObject(destVal, OutputStream.class)) {
                OutputStream os = (OutputStream)((VncJavaObject)destVal).getDelegate();
                try {
                    IOStreamUtil.copyFileToOS(sourceFile, os);
                }
                catch (Exception ex) {
                    throw new VncException(String.format("Failed to copy file %s to stream", sourceFile.getPath()), ex);
                }
            } else {
                throw new VncException(String.format("Function 'io/copy-file' does not allow %s as dest", Types.getType(destVal)));
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_copy_files_glob = new VncFunction("io/copy-files-glob", (VncVal)VncFunction.meta().arglists("(io/copy-files-glob src-dir dst-dir glob & options)").doc("Copies all files that match the glob pattern from a source to a destination directory. \nsrc-dir and  dst-dir must be a file or a string (file path).\n\n\nOptions: \n\n| [![width: 25%]] | [![width: 75%]] |\n| :replace true/false | e.g.: if true replace an existing file, defaults to false |\n| :copy-attributes true/false | e.g.: if true copy attributes to the new file, defaults to false |\n| :no-follow-links true/false | e.g.: if true do not follow symbolic links, defaults to false |\n\n" + IOFunctions.globPatternHelp()).examples("(io/copy-files-glob \"from\" \"to\" \"*.log\")").seeAlso("io/copy-file", "io/copy-file-tree", "io/move-files-glob", "io/delete-files-glob", "io/list-files-glob").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 3);
            this.sandboxFunctionCallValidation();
            File srcdir = IOFunctions.convertToFile(args.first(), "Function 'io/copy-files-glob' does not allow %s as src-dir");
            File dstdir = IOFunctions.convertToFile(args.second(), "Function 'io/copy-files-glob' does not allow %s as dst-dir");
            String glob = Coerce.toVncString(args.third()).getValue();
            VncHashMap options = VncHashMap.ofAll(args.rest().rest().rest());
            VncVal replaceOpt = options.get(new VncKeyword("replace"));
            VncVal copyAttrOpt = options.get(new VncKeyword("copy-attributes"));
            VncVal noFollowLinks = options.get(new VncKeyword("no-follow-links"));
            ArrayList<Enum> copyOptions = new ArrayList<Enum>();
            if (VncBoolean.isTrue(replaceOpt)) {
                copyOptions.add(StandardCopyOption.REPLACE_EXISTING);
            }
            if (VncBoolean.isTrue(copyAttrOpt)) {
                copyOptions.add(StandardCopyOption.COPY_ATTRIBUTES);
            }
            if (VncBoolean.isTrue(noFollowLinks)) {
                copyOptions.add(LinkOption.NOFOLLOW_LINKS);
            }
            IOFunctions.validateReadableDirectory(srcdir);
            IOFunctions.validateWritableDirectory(dstdir);
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(srcdir.toPath(), glob);){
                dirStream.forEach(path -> {
                    try {
                        Path d = dstdir.toPath().resolve(srcdir.toPath().relativize((Path)path));
                        Files.copy(path, d, copyOptions.toArray(new CopyOption[0]));
                    }
                    catch (Exception ex) {
                        throw new VncException(String.format("Failed to copy file %s", path), ex);
                    }
                });
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to copy files from %s to %s, glob: %s ", srcdir.getPath(), dstdir.getPath(), glob), ex);
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_copy_file_tree = new VncFunction("io/copy-file-tree", (VncVal)VncFunction.meta().arglists("(io/copy-file-tree source dest & options)").doc("Copies a file tree from source to dest. Returns nil or throws a VncException. Source must be a file or a string (file path), dest must be a file, a string (file path), or an `java.io.OutputStream`.\n\nOptions: \n\n| [![width: 25%]] | [![width: 75%]] |\n| :replace true/false | e.g.: if true replace an existing file, defaults to false |\n| :copy-attributes true/false | e.g.: if true copy attributes to the new file, defaults to false |\n| :no-follow-links true/false | e.g.: if true do not follow symbolic links, defaults to false |\n").seeAlso("io/copy-file", "io/copy-files-glob", "io/move-file", "io/delete-file", "io/touch-file", "io/copy-stream").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            VncHashMap options = VncHashMap.ofAll(args.rest().rest());
            VncVal replaceOpt = options.get(new VncKeyword("replace"));
            VncVal copyAttrOpt = options.get(new VncKeyword("copy-attributes"));
            VncVal noFollowLinks = options.get(new VncKeyword("no-follow-links"));
            File sourceFile = IOFunctions.convertToFile(args.first(), "Function 'io/copy-file' does not allow %s as source");
            VncVal destVal = args.second();
            File destFile = IOFunctions.convertToFile(destVal);
            if (destFile != null) {
                ArrayList<Enum> copyOptions = new ArrayList<Enum>();
                if (VncBoolean.isTrue(replaceOpt)) {
                    copyOptions.add(StandardCopyOption.REPLACE_EXISTING);
                }
                if (VncBoolean.isTrue(copyAttrOpt)) {
                    copyOptions.add(StandardCopyOption.COPY_ATTRIBUTES);
                }
                if (VncBoolean.isTrue(noFollowLinks)) {
                    copyOptions.add(LinkOption.NOFOLLOW_LINKS);
                }
                try {
                    Files.walk(sourceFile.toPath(), new FileVisitOption[0]).forEach(s -> {
                        try {
                            Path d = destFile.toPath().resolve(sourceFile.toPath().relativize((Path)s));
                            if (Files.isDirectory(s, new LinkOption[0])) {
                                if (!Files.exists(d, new LinkOption[0])) {
                                    Files.createDirectory(d, new FileAttribute[0]);
                                }
                                return;
                            }
                            Files.copy(s, d, copyOptions.toArray(new CopyOption[0]));
                        }
                        catch (Exception ex) {
                            throw new VncException(String.format("Failed to copy file tree at %s", s.toString()), ex);
                        }
                    });
                }
                catch (Exception ex) {
                    throw new VncException(String.format("Failed to copy file %s to %s", sourceFile.getPath(), destFile.getPath()), ex);
                }
            } else if (Types.isVncJavaObject(destVal, OutputStream.class)) {
                OutputStream os = (OutputStream)((VncJavaObject)destVal).getDelegate();
                try {
                    IOStreamUtil.copyFileToOS(sourceFile, os);
                }
                catch (Exception ex) {
                    throw new VncException(String.format("Failed to copy file %s to stream", sourceFile.getPath()), ex);
                }
            } else {
                throw new VncException(String.format("Function 'io/copy-file' does not allow %s as dest", Types.getType(destVal)));
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_move_file = new VncFunction("io/move-file", (VncVal)VncFunction.meta().arglists("(io/move-file source target & options)").doc("Moves source to target. Returns nil or throws a VncException. Source and target must be a file or a string (file path).\n\nOptions: \n\n| [![width: 20%]] | [![width: 80%]] |\n| :replace true/false | e.g.: if true replace an existing file, defaults to false |\n| :atomic-move true/false | e.g.: if true move the file as an atomic file system operation, defaults to false |\n").seeAlso("io/copy-file", "io/delete-file", "io/touch-file").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            VncHashMap options = VncHashMap.ofAll(args.rest().rest());
            VncVal replaceOpt = options.get(new VncKeyword("replace"));
            VncVal atomicMoveOpt = options.get(new VncKeyword("atomic-move"));
            File from = IOFunctions.convertToFile(args.first(), "Function 'io/move-file' does not allow %s as source");
            File to = IOFunctions.convertToFile(args.second(), "Function 'io/move-file' does not allow %s as target");
            if (!from.isFile()) {
                throw new VncException(String.format("Failed to move file %s to %s. The from file does not exists!", from.getPath(), to.getPath()));
            }
            try {
                ArrayList<StandardCopyOption> moveOptions = new ArrayList<StandardCopyOption>();
                if (VncBoolean.isTrue(replaceOpt)) {
                    moveOptions.add(StandardCopyOption.REPLACE_EXISTING);
                }
                if (VncBoolean.isTrue(atomicMoveOpt)) {
                    moveOptions.add(StandardCopyOption.ATOMIC_MOVE);
                }
                Files.move(from.toPath(), to.toPath(), moveOptions.toArray(new CopyOption[0]));
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to move file %s to %s", from.getPath(), to.getPath()), ex);
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_move_files_glob = new VncFunction("io/move-files-glob", (VncVal)VncFunction.meta().arglists("(io/move-files-glob src-dir dst-dir glob & options)").doc("Move all files that match the glob pattern from a source to a destination directory. \nsrc-dir and  dst-dir must be a file or a string (file path).\n\nOptions: \n\n| [![width: 20%]] | [![width: 80%]] |\n| :replace true/false | e.g.: if true replace an existing file, defaults to false |\n| :atomic-move true/false | e.g.: if true move the file as an atomic file system operation, defaults to false |\n\n" + IOFunctions.globPatternHelp()).examples("(io/move-files-glob \"from\" \"to\" \"*.log\")").seeAlso("io/move-file", "io/move-files-glob", "io/copy-files-glob", "io/delete-files-glob", "io/list-files-glob").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 3);
            this.sandboxFunctionCallValidation();
            File srcdir = IOFunctions.convertToFile(args.first(), "Function 'io/move-files-glob' does not allow %s as src-dir");
            File dstdir = IOFunctions.convertToFile(args.second(), "Function 'io/move-files-glob' does not allow %s as dst-dir");
            String glob = Coerce.toVncString(args.third()).getValue();
            VncHashMap options = VncHashMap.ofAll(args.rest().rest().rest());
            VncVal replaceOpt = options.get(new VncKeyword("replace"));
            VncVal atomicMoveOpt = options.get(new VncKeyword("atomic-move"));
            IOFunctions.validateReadableDirectory(srcdir);
            IOFunctions.validateWritableDirectory(dstdir);
            ArrayList<StandardCopyOption> moveOptions = new ArrayList<StandardCopyOption>();
            if (VncBoolean.isTrue(replaceOpt)) {
                moveOptions.add(StandardCopyOption.REPLACE_EXISTING);
            }
            if (VncBoolean.isTrue(atomicMoveOpt)) {
                moveOptions.add(StandardCopyOption.ATOMIC_MOVE);
            }
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(srcdir.toPath(), glob);){
                dirStream.forEach(path -> {
                    try {
                        Path d = dstdir.toPath().resolve(srcdir.toPath().relativize((Path)path));
                        Files.move(path, d, moveOptions.toArray(new CopyOption[0]));
                    }
                    catch (IOException ex) {
                        throw new VncException(String.format("Failed to move file %s", path), ex);
                    }
                });
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to move files from %s to %s, glob: %s ", srcdir.getPath(), dstdir.getPath(), glob), ex);
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_touch_file = new VncFunction("io/touch-file", (VncVal)VncFunction.meta().arglists("(io/touch-file file)").doc("Updates the *lastModifiedTime* of the file to the current time, or creates a new empty file if the file doesn't already exist. File must be a file or a string (file path). \nReturns the file").seeAlso("io/move-file", "io/copy-file", "io/delete-file").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            File file = IOFunctions.convertToFile(args.first(), "Function 'io/touch-file' does not allow %s as file");
            try {
                Path path = file.toPath();
                if (Files.exists(path, new LinkOption[0])) {
                    Files.setLastModifiedTime(path, FileTime.fromMillis(System.currentTimeMillis()));
                } else {
                    Files.createFile(path, new FileAttribute[0]);
                }
                return new VncJavaObject(file);
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to touch file %s", file.getPath()), ex);
            }
        }
    };
    public static VncFunction io_mkdir = new VncFunction("io/mkdir", (VncVal)VncFunction.meta().arglists("(io/mkdir dir)").doc("Creates the directory. dir must be a file or a string (file path).").seeAlso("io/mkdirs").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            File dir = IOFunctions.convertToFile(args.first(), "Function 'io/mkdir' does not allow %s as dir");
            try {
                if (!dir.mkdir()) {
                    throw new VncException(String.format("Failed to create dir %s", dir.getPath()));
                }
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to create dir %s", dir.getPath()), ex);
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_mkdirs = new VncFunction("io/mkdirs", (VncVal)VncFunction.meta().arglists("(io/mkdirs dir)").doc("Creates the directory including any necessary but nonexistent parent directories. dir must be a file or a string (file path).").seeAlso("io/mkdir").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            File dir = IOFunctions.convertToFile(args.first(), "Function 'io/mkdirs' does not allow %s as dir");
            try {
                if (!dir.mkdirs()) {
                    throw new VncException(String.format("Failed to create dir %s", dir.getPath()));
                }
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to create dir %s", dir.getPath()), ex);
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_tmp_dir = new VncFunction("io/tmp-dir", (VncVal)VncFunction.meta().arglists("(io/tmp-dir)").doc("Returns the tmp dir as a `java.io.File`.").examples("(io/tmp-dir)").seeAlso("io/user-dir", "io/user-home-dir", "io/temp-dir").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            this.sandboxFunctionCallValidation();
            return new VncJavaObject(new File(System.getProperty("java.io.tmpdir")));
        }
    };
    public static VncFunction io_user_dir = new VncFunction("io/user-dir", (VncVal)VncFunction.meta().arglists("(io/user-dir)").doc("Returns the user dir (current working dir) as a java.io.File.").seeAlso("io/tmp-dir", "io/user-home-dir").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            this.sandboxFunctionCallValidation();
            return new VncJavaObject(new File(System.getProperty("user.dir")));
        }
    };
    public static VncFunction io_user_home_dir = new VncFunction("io/user-home-dir", (VncVal)VncFunction.meta().arglists("(io/user-home-dir)").doc("Returns the user's home dir as a `java.io.File`.").seeAlso("user-name", "io/user-dir", "io/tmp-dir").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            this.sandboxFunctionCallValidation();
            return new VncJavaObject(new File(System.getProperty("user.home")));
        }
    };
    public static VncFunction io_download = new VncFunction("io/download", (VncVal)VncFunction.meta().arglists("(io/download uri & options)").doc("Downloads the content from the uri and reads it as text (string) or binary (bytebuf). Supports http and https protocols!\n\nOptions: \n\n| :binary b           | e.g.: `:binary true`, defaults to false |\n| :user-agent agent   | e.g.: `:user-agent \"Mozilla\"`, defaults to nil |\n| :encoding enc       | e.g.: `:encoding :utf-8,` defaults to :utf-8 |\n| :user u             | optional user for basic authentication|\n| :password p         | optional password for basic authentication |\n| :follow-redirects b | e.g.: `:follow-redirects true`, defaults to false |\n| :conn-timeout val   | e.g.: `:conn-timeout 10000`,                         connection timeout in milliseconds. \u00b6                        0 is interpreted as an infinite timeout. |\n| :read-timeout val   | e.g.: `:read-timeout 10000`,                         read timeout in milliseconds. \u00b6                        0 is interpreted as an infinite timeout. |\n| :progress-fn fn     | an optional progress function that takes 2 args \u00b6                        [1] progress (0..100%) \u00b6                        [2] status {:start :progress :end :failed}|\n| :debug-fn fn        | an optional debug function that takes a message as argument |\n\nNote:\u00b6If the server returns the HTTP response status code 403 (*Access Denied*) sending a user agent like \"Mozilla\" may fool the website and solve the problem.\n\nTo debug pass a printing function like: `(io/download https://foo.org/bar :debug-fn println)`").examples("(-<> \"https://live.staticflickr.com/65535/51007202541_ea453871d8_o_d.jpg\"\n     (io/download <> :binary true :user-agent \"Mozilla\")\n     (io/spit \"space-x.jpg\" <>))", "(do \n  (load-module :ansi) \n  (-<> \"https://live.staticflickr.com/65535/51007202541_ea453871d8_o_d.jpg\" \n       (io/download <> :binary true \n                       :user-agent \"Mozilla\" \n                       :progress-fn (ansi/progress :caption \"Download:\")) \n       (io/spit \"space-x.jpg\" <>)))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            StopWatch sw = new StopWatch();
            String uri = Coerce.toVncString(args.first()).getValue();
            VncFunction progressFn = IOFunctions.downloadDummyFn();
            VncFunction debugFn = IOFunctions.downloadDummyFn();
            try {
                VncHashMap options = VncHashMap.ofAll(args.rest());
                VncVal user = options.get(new VncKeyword("user"));
                VncVal password = options.get(new VncKeyword("password"));
                VncVal binary = options.get(new VncKeyword("binary"), VncBoolean.False);
                VncVal followRedirects = options.get(new VncKeyword("follow-redirects"), VncBoolean.False);
                VncVal useragent = options.get(new VncKeyword("user-agent"));
                VncVal encVal = options.get(new VncKeyword("encoding"));
                VncVal progressVal = options.get(new VncKeyword("progress-fn"));
                VncVal connTimeoutMillisVal = options.get(new VncKeyword("conn-timeout"));
                VncVal readTimeoutMillisVal = options.get(new VncKeyword("read-timeout"));
                VncVal debugVal = options.get(new VncKeyword("debug-fn"));
                Charset charset = CharsetUtil.charset(encVal);
                if (debugVal != Constants.Nil) {
                    debugFn = Coerce.toVncFunction(debugVal);
                    debugFn.sandboxFunctionCallValidation();
                }
                if (progressVal != Constants.Nil) {
                    progressFn = Coerce.toVncFunction(progressVal);
                    progressFn.sandboxFunctionCallValidation();
                }
                String authHeader = null;
                if (user != Constants.Nil && password != Constants.Nil) {
                    authHeader = BasicAuthentication.headerValue(Coerce.toVncString(user).getValue(), Coerce.toVncString(password).getValue());
                } else {
                    if (user != Constants.Nil) throw new VncException("io/download needs both the 'user' and the 'password' option for basic authentication!");
                    if (password != Constants.Nil) {
                        throw new VncException("io/download needs both the 'user' and the 'password' option for basic authentication!");
                    }
                }
                debugFn.applyOf(new VncString("URI: " + uri));
                URL url = new URL(uri);
                String protocol = url.getProtocol();
                if (!"http".equals(protocol) && !"https".equals(protocol)) {
                    throw new VncException(String.format("io/download does not support the protocol '%s'! Please use 'http' or 'https'.", protocol));
                }
                IOFunctions.updateDownloadProgress(progressFn, 0L, -1L, new VncKeyword("start"));
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                debugFn.applyOf(new VncString("Orignal url: " + conn.getURL()));
                if (Types.isVncString(useragent)) {
                    conn.addRequestProperty("User-Agent", ((VncString)useragent).getValue());
                }
                if (Types.isVncLong(connTimeoutMillisVal)) {
                    conn.setConnectTimeout(Math.max(0, ((VncLong)connTimeoutMillisVal).toJavaInteger()));
                }
                if (Types.isVncLong(readTimeoutMillisVal)) {
                    conn.setReadTimeout(Math.max(0, ((VncLong)readTimeoutMillisVal).toJavaInteger()));
                }
                if (authHeader != null) {
                    conn.setRequestProperty("Authorization", authHeader);
                    debugFn.applyOf(new VncString("Authorization Header: Basic (base64 " + user + ":xxxxxx)"));
                }
                if (VncBoolean.isTrue(followRedirects)) {
                    conn.setInstanceFollowRedirects(true);
                    debugFn.applyOf(new VncString("Follow redirects: activated"));
                }
                conn.connect();
                debugFn.applyOf(new VncString("Connected url: " + conn.getURL()));
                int responseCode = conn.getResponseCode();
                debugFn.applyOf(new VncString("Response code: " + responseCode));
                for (Map.Entry<String, List<String>> entry : conn.getHeaderFields().entrySet()) {
                    debugFn.applyOf(new VncString("Response header: key => " + entry.getKey() + ",  value => " + entry.getValue()));
                }
                if (responseCode == 200) {
                    try (BufferedInputStream is = new BufferedInputStream(conn.getInputStream());){
                        debugFn.applyOf(new VncString("Redirected url: " + conn.getURL()));
                        byte[] data = IOFunctions.slurpData(is, progressFn, conn.getContentLengthLong());
                        VncVal retVal = VncBoolean.isTrue(binary) ? new VncByteBuffer(data) : new VncString(new String(data, charset));
                        long elapsed = sw.stop().elapsed(TimeUnit.MILLISECONDS);
                        IOFunctions.updateDownloadProgress(progressFn, 100L, elapsed, new VncKeyword("end"));
                        VncVal vncVal = retVal;
                        return vncVal;
                    }
                }
                if (responseCode != 301) throw new VncException("Failed to download data. Server returned HTTP code: " + responseCode);
                String location = conn.getHeaderField("Location");
                throw new VncException("Server returned HTTP code: HTTP_MOVED_PERM (301). New location: " + location);
                finally {
                    conn.disconnect();
                }
            }
            catch (Exception ex) {
                IOFunctions.updateDownloadProgress(progressFn, 0L, -1L, new VncKeyword("failed"));
                throw new VncException("Failed to download data from the URI: " + uri, ex);
            }
        }
    };
    public static VncFunction io_internet_avail_Q = new VncFunction("io/internet-avail?", (VncVal)VncFunction.meta().arglists("(io/internet-avail?)", "(io/internet-avail? url)").doc("Checks if an internet connection is present for a given url. Defaults to URL *http://www.google.com*.").examples("(io/internet-avail?)", "(io/internet-avail? \"http://www.google.com\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0, 1);
            String sURL = args.isEmpty() ? "http://www.google.com" : Coerce.toVncString(args.first()).getValue();
            return VncBoolean.of(InternetUtil.isInternetAvailable(sURL));
        }
    };
    public static VncFunction io_mime_type = new VncFunction("io/mime-type", (VncVal)VncFunction.meta().arglists("(io/mime-type file)").doc("Returns the mime-type for the file if available else nil.").examples("(io/mime-type \"document.pdf\")", "(io/mime-type (io/file \"document.pdf\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            VncVal file = args.first();
            if (Types.isVncString(file)) {
                return new VncString(MimeTypes.getMimeTypeFromFileName(((VncString)file).getValue()));
            }
            if (Types.isVncJavaObject(file, File.class)) {
                return new VncString(MimeTypes.getMimeTypeFromFile((File)Coerce.toVncJavaObject(file).getDelegate()));
            }
            throw new VncException(String.format("Function 'io/mime-type' does not allow %s as fs", Types.getType(file)));
        }
    };
    public static VncFunction io_log_filehandler = new VncFunction("io/log-filehandler", (VncVal)VncFunction.meta().arglists("(io/log-filehandler logger-name file-name-pattern)", "(io/log-filehandler logger-name file-name-pattern file-size-limit)", "(io/log-filehandler logger-name file-name-pattern file-size-limit max-file-count)", "(io/log-filehandler logger-name file-name-pattern file-size-limit max-file-count, formatter)").doc("Creates a file handler for a Java Util Logger (JUL).           \n                                                               \nThe file name pattern determines the output file location and  \nnaming scheme:                                                 \n                                                               \n * %t = system temp directory                                  \n * %h = user home directory                                    \n * %u = unique number to resolve conflicts                     \n * %g = generation number for rotated logs                     \n * %% = escapes the % character                                \n                                                               \nIf no \"%g\" field has been specified and the file count is    \ngreater than one, then the generation number will be added to  \nthe end of the generated filename, after a dot.                \nThus for example a pattern of \"%t/java%g.log\" with a count   \nof 2 would typically cause log files to be written on Linux to \n/var/tmp/java0.log and /var/tmp/java1.log whereas on Windows   \nthey would be typically written to C:\\TEMP\\java0.log and     \nC:\\TEMP\\java1.log                                            \n                                                               \nGeneration numbers follow the sequence 0, 1, 2, etc.           \n                                                               \nNormally the \"%u\" unique field is set to 0. However, if the  \nFileHandler tries to open the filename and finds the file is   \ncurrently in use by another process it will increment the      \nunique number field and try again. This will be repeated       \nuntil FileHandler finds a file name that is not currently in   \nuse. If there is a conflict and no \"%u\" field has been       \nspecified, it will be added at the end of the filename after   \na dot. (This will be after any automatically added generation  \nnumber.)                                                       \n                                                               \nThus if three processes were all trying to log to              \nfred%u.%g.txt then they might end up using fred0.0.txt,        \nfred1.0.txt, fred2.0.txt as the first file in their            \nrotating sequences.                                            \n                                                               \nNote that the use of unique ids to avoid conflicts is only     \nguaranteed to work reliably when using a local disk file       \nsystem.                                                        \n                                                               \nExamples:                                                      \n                                                               \n * `/var/log/myapp/app.log`                                    \n * `/var/log/myapp/app_%g.log`                                 \n * `%t/app_%g.log`                                             \n * `%h/app_%g.log`                                             ").examples("(do                                                              \n  ;; note: define the log filehandler just once at app startup!  \n  (io/log-filehandler \"venice\"                                 \n                      \"/var/log/myapp/venice_%g.log\"           \n                      16_000_000                                 \n                      8)                                         \n                                                                 \n  (io/log \"venice\" :info    \"message 1\")                     \n  (io/log \"venice\" :warning \"message 2\")                     \n  (io/log \"venice\" :severe  \"message 3\"))                    ", "(do                                                              \n  (def tf (time/formatter \"yyyy-MM-dd HH:mm:ss.SSS\"))          \n                                                                 \n  (defn formatter [log-record]                                   \n     (str/format \"%s|%s|%s%s%n\"                                \n                 (time/format (:timestamp log-record) tf)        \n                 (:level log-record)                             \n                 (:message log-record)                           \n                 (:throwable log-record)))                       \n                                                                 \n  ;; note: define the log filehandler just once at app startup!  \n  (io/log-filehandler \"venice\"                                 \n                      \"/var/log/myapp/venice_%g.log\"           \n                      16_000_000                                 \n                      8                                          \n                      formatter)                                 \n                                                                 \n  (io/log \"venice\" :info    \"message 1\")                     \n  (io/log \"venice\" :warning \"message 2\")                     \n  (io/log \"venice\" :severe  \"message 3\" (ex :VncException \"test\"))) ").seeAlso("io/log").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2, 3, 4, 5);
            this.sandboxFunctionCallValidation();
            String loggerName = Coerce.toVncString(args.first()).getValue();
            String pattern = Coerce.toVncString(args.second()).getValue();
            int limit = args.size() > 2 ? Coerce.toVncLong(args.third()).getIntValue() : 0;
            int count = args.size() > 3 ? Coerce.toVncLong(args.fourth()).getIntValue() : 1;
            final VncFunction formatFn = args.size() > 4 ? Coerce.toVncFunction(args.nth(4)) : null;
            try {
                FileHandler handler = new FileHandler(pattern, limit, count, true);
                handler.setEncoding("UTF-8");
                handler.setFormatter(formatFn == null ? new SimpleFormatter(){
                    private static final String format = "%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL|%2$s|%3$s%4$s%n";

                    @Override
                    public synchronized String format(LogRecord record) {
                        return String.format(format, new Date(record.getMillis()), record.getLevel().getLocalizedName(), record.getMessage(), IOFunctions.toString(record.getThrown()));
                    }
                } : new SimpleFormatter(){

                    @Override
                    public synchronized String format(LogRecord record) {
                        VncHashMap map = VncHashMap.of(new VncKeyword("timestamp"), new VncJavaObject(Instant.ofEpochMilli(record.getMillis()).atZone(ZoneId.systemDefault()).toLocalDateTime()), new VncKeyword("level"), new VncString(record.getLevel().getLocalizedName()), new VncKeyword("message"), new VncString(record.getMessage()), new VncKeyword("throwable"), new VncString(IOFunctions.toString(record.getThrown())));
                        return formatFn.applyOf(map).toString();
                    }
                });
                Logger logger = Logger.getLogger(loggerName);
                logger.addHandler(handler);
                logger.setUseParentHandlers(false);
                return Constants.Nil;
            }
            catch (IOException ex) {
                throw new VncException("Failed to create file handler for logger '" + loggerName + "'!", ex);
            }
        }
    };
    public static VncFunction io_log = new VncFunction("io/log", (VncVal)VncFunction.meta().arglists("(io/log logger-name level message)", "(io/log logger-name level message exception)").doc("Logs a message at a given level to a Java Util Logger (JUL).").examples("(do                                                              \n  ;; note: define the log filehandler just once at app startup!  \n  (io/log-filehandler \"venice\"                                 \n                      \"/var/log/myapp/venice_%g.log\"           \n                      16_000_000                                 \n                      8)                                         \n                                                                 \n  (io/log \"venice\" :info    \"message 1\")                     \n  (io/log \"venice\" :warning \"message 2\")                     \n  (io/log \"venice\" :severe  \"message 3\" (ex :VncException \"test\"))) ").seeAlso("io/log-filehandler").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3, 4);
            this.sandboxFunctionCallValidation();
            String loggerName = Coerce.toVncString(args.first()).getValue();
            String level = Coerce.toVncKeyword(args.second()).getSimpleName().toUpperCase();
            String message = Coerce.toVncString(args.third()).getValue();
            Throwable th = args.size() > 3 ? Coerce.toVncJavaObject(args.fourth(), Throwable.class) : null;
            Logger logger = Logger.getLogger(loggerName);
            try {
                logger.log(Level.parse(level), message, th);
            }
            catch (IllegalArgumentException ex) {
                throw new VncException("Invalid log level '" + level + "'! Use one of { :severe, :warning, :info, :config, :fine, :finer, :finest}.");
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_temp_file = new VncFunction("io/temp-file", (VncVal)VncFunction.meta().arglists("(io/temp-file prefix suffix)").doc("Creates an empty temp file with the given prefix and suffix. Returns a :java.io.File.").examples("(do \n  (let [file (io/temp-file \"test-\", \".txt\")] \n    (io/spit file \"123456789\" :append true) \n    (io/slurp file :binary false :remove true)) \n)").seeAlso("io/temp-dir", "io/delete-file-on-exit").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            String prefix = Coerce.toVncString(args.first()).getValue();
            String suffix = Coerce.toVncString(args.second()).getValue();
            try {
                File file = Files.createTempFile(prefix, suffix, new FileAttribute[0]).normalize().toFile();
                return new VncJavaObject(file);
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction io_temp_dir = new VncFunction("io/temp-dir", (VncVal)VncFunction.meta().arglists("(io/temp-dir prefix)").doc("Creates a new temp directory with prefix. Returns a :java.io.File.").examples("(io/temp-dir \"test-\")").seeAlso("io/tmp-dir", "io/temp-file").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            String prefix = Coerce.toVncString(args.first()).getValue();
            try {
                return new VncJavaObject(Files.createTempDirectory(prefix, new FileAttribute[0]).normalize().toFile());
            }
            catch (Exception ex) {
                throw new VncException("Failed to create a temp directory", ex);
            }
        }
    };
    public static VncFunction io_filesystem_total_space = new VncFunction("io/filesystem-total-space", (VncVal)VncFunction.meta().arglists("(io/filesystem-total-space)", "(io/filesystem-total-space file)").doc("Returns the total diskspace in bytes. \nWith no args returns the total disk space of the current working directory's file store. With a file argument returns the total disk space of the file store the file is located.").examples("(io/filesystem-total-space)").seeAlso("io/filesystem-usable-space").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0, 1);
            File file = args.isEmpty() ? new File(".") : IOFunctions.convertToFile(args.first(), "Function 'io/filesystem-total-space' does not allow %s as file");
            try {
                FileStore store = Files.getFileStore(file.toPath());
                return new VncLong(store.getTotalSpace());
            }
            catch (Exception ex) {
                throw new VncException("Failed to get total disk space", ex);
            }
        }
    };
    public static VncFunction io_filesystem_usable_space = new VncFunction("io/filesystem-usable-space", (VncVal)VncFunction.meta().arglists("(io/filesystem-usable-space)", "(io/filesystem-usable-space file)").doc("Returns the usable diskspace in bytes. \nWith no args returns the usable disk space of the current working directory's file store. With a file argument returns the usable disk space of the file store the file is located.").examples("(io/filesystem-usable-space)").seeAlso("io/filesystem-total-space").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0, 1);
            File file = args.isEmpty() ? new File(".") : IOFunctions.convertToFile(args.first(), "Function 'io/filesystem-usable-space' does not allow %s as file");
            try {
                FileStore store = Files.getFileStore(file.toPath());
                return new VncLong(store.getUsableSpace());
            }
            catch (Exception ex) {
                throw new VncException("Failed to get usable disk space", ex);
            }
        }
    };
    public static VncFunction io_load_classpath_resource = new VncFunction("io/load-classpath-resource", (VncVal)VncFunction.meta().arglists("(io/load-classpath-resource name)").doc("Loads a classpath resource. Returns a bytebuf").examples("(io/load-classpath-resource \"com/github/jlangch/venice/images/venice.png\")").seeAlso("io/classpath-resource?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            VncVal name = args.first();
            try {
                if (Types.isVncString(name)) {
                    String res = ((VncString)args.first()).getValue();
                    byte[] data = ThreadContext.getInterceptor().onLoadClassPathResource(res);
                    return data == null ? Constants.Nil : new VncByteBuffer(data);
                }
                if (Types.isVncKeyword(name)) {
                    String res = ((VncKeyword)args.first()).getValue();
                    byte[] data = ThreadContext.getInterceptor().onLoadClassPathResource(res);
                    return data == null ? Constants.Nil : new VncByteBuffer(data);
                }
                if (Types.isVncSymbol(name)) {
                    String res = ((VncSymbol)args.first()).getName();
                    byte[] data = ThreadContext.getInterceptor().onLoadClassPathResource(res);
                    return data == null ? Constants.Nil : new VncByteBuffer(data);
                }
                return Constants.Nil;
            }
            catch (SecurityException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException("Failed to load classpath resource: " + name.toString(), ex);
            }
        }
    };
    public static VncFunction io_classpath_resource_Q = new VncFunction("io/classpath-resource?", (VncVal)VncFunction.meta().arglists("(io/classpath-resource? name)").doc("Returns true if the classpath resource exists otherwise false.").examples("(io/classpath-resource? \"com/github/jlangch/venice/images/venice.png\")").seeAlso("io/load-classpath-resource").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal name = args.first();
            try {
                if (Types.isVncString(name)) {
                    String path = ((VncString)args.first()).getValue();
                    return VncBoolean.of(new ClassPathResource(path).getResource() != null);
                }
                if (Types.isVncKeyword(name)) {
                    String path = ((VncKeyword)args.first()).getValue();
                    return VncBoolean.of(new ClassPathResource(path).getResource() != null);
                }
                if (Types.isVncSymbol(name)) {
                    String path = ((VncSymbol)args.first()).getName();
                    return VncBoolean.of(new ClassPathResource(path).getResource() != null);
                }
                return VncBoolean.False;
            }
            catch (Exception ex) {
                return VncBoolean.False;
            }
        }
    };
    public static VncFunction io_default_charset = new VncFunction("io/default-charset", (VncVal)VncFunction.meta().arglists("(io/default-charset)").doc("Returns the default charset.").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncString(Charset.defaultCharset().name());
        }
    };
    public static VncFunction io_make_venice_filename = new VncFunction("io/make-venice-filename", (VncVal)VncFunction.meta().arglists("(io/make-venice-filename f)").doc("Returns the file f with the extension '.venice'. f must be a file or a string (file path).").examples("(io/make-venice-filename \"/tmp/foo\")", "(io/make-venice-filename \"/tmp/foo.venice\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal f = args.first();
            if (Types.isVncString(f)) {
                String s = Coerce.toVncString(f).getValue();
                return s.endsWith(".venice") ? f : new VncString(s + ".venice");
            }
            if (Types.isVncJavaObject(f, File.class)) {
                File file = Coerce.toVncJavaObject(f, File.class);
                String name = file.getName();
                return name.endsWith(".venice") ? f : new VncJavaObject(new File(file.getParentFile(), name + ".venice"));
            }
            if (Types.isVncJavaObject(f, Path.class)) {
                File file = Coerce.toVncJavaObject(f, Path.class).toFile();
                String name = file.getName();
                return name.endsWith(".venice") ? f : new VncJavaObject(new File(file.getParentFile(), name + ".venice").toPath());
            }
            throw new VncException(String.format("Function 'io/make-venice-filename' does not allow %s as fs", Types.getType(f)));
        }
    };
    public static final Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(io_file).add(io_file_Q).add(io_file_path).add(io_file_path_slashify).add(io_file_canonical).add(io_file_absolute).add(io_file_parent).add(io_file_name).add(io_file_basename).add(io_to_path).add(io_path_Q).add(io_file_ext_Q).add(io_file_ext).add(io_file_normalize_utf).add(io_file_size).add(io_file_last_modified).add(io_exists_Q).add(io_exists_file_Q).add(io_exists_dir_Q).add(io_file_can_read_Q).add(io_file_can_write_Q).add(io_file_can_execute_Q).add(io_file_set_readable).add(io_file_set_writable).add(io_file_set_executable).add(io_file_hidden_Q).add(io_create_symbolic_link).add(io_create_hard_link).add(io_symbolic_link_Q).add(io_file_absolute_Q).add(io_glob_path_matcher).add(io_file_matches_globQ).add(io_file_within_dir_Q).add(io_to_url).add(io_to_uri).add(io_list_files).add(io_list_file_tree).add(io_list_file_tree_lazy).add(io_list_files_glob).add(io_delete_file).add(io_delete_file_on_exit).add(io_delete_file_tree).add(io_delete_files_glob).add(io_truncate_from_start_keep_lines).add(io_copy_file).add(io_copy_files_glob).add(io_copy_file_tree).add(io_move_file).add(io_move_files_glob).add(io_touch_file).add(io_mkdir).add(io_mkdirs).add(io_temp_file).add(io_temp_dir).add(io_tmp_dir).add(io_user_dir).add(io_user_home_dir).add(io_filesystem_usable_space).add(io_filesystem_total_space).add(io_download).add(io_internet_avail_Q).add(io_mime_type).add(io_default_charset).add(io_load_classpath_resource).add(io_classpath_resource_Q).add(io_make_venice_filename).add(io_log_filehandler).add(io_log).toMap();

    public static File convertToFile(VncVal f, String errFormat) {
        File file = IOFunctions.convertToFile(f);
        if (file == null) {
            throw new VncException(String.format(errFormat, Types.getType(f)));
        }
        return file;
    }

    private static File convertToFile(VncVal f) {
        if (Types.isVncString(f)) {
            return new File(((VncString)f).getValue());
        }
        if (Types.isVncJavaObject(f, File.class)) {
            return Coerce.toVncJavaObject(f, File.class);
        }
        if (Types.isVncJavaObject(f, Path.class)) {
            return Coerce.toVncJavaObject(f, Path.class).toFile();
        }
        return null;
    }

    private static Path convertToPath(VncVal f) {
        if (Types.isVncString(f)) {
            return new File(((VncString)f).getValue()).toPath();
        }
        if (Types.isVncJavaObject(f, File.class)) {
            return Coerce.toVncJavaObject(f, File.class).toPath();
        }
        if (Types.isVncJavaObject(f, Path.class)) {
            return Coerce.toVncJavaObject(f, Path.class);
        }
        return null;
    }

    private static Path convertToPath(VncVal f, String errFormat) {
        Path path = IOFunctions.convertToPath(f);
        if (path == null) {
            throw new VncException(String.format(errFormat, Types.getType(f)));
        }
        return path;
    }

    public static void validateReadableFile(File file) {
        if (!file.isFile()) {
            throw new VncException(String.format("'%s' is not a file", file.getPath()));
        }
        if (!file.canRead()) {
            throw new VncException(String.format("The file '%s' has no read permission", file.getPath()));
        }
    }

    public static void validateReadableDirectory(File file) {
        if (!file.isDirectory()) {
            throw new VncException(String.format("'%s' is not a directory", file.getPath()));
        }
        if (!file.canRead()) {
            throw new VncException(String.format("The directory '%s' has no read permission", file.getPath()));
        }
    }

    public static void validateReadableFileOrDirectory(File file) {
        if (!file.isDirectory() && !file.isFile()) {
            throw new VncException(String.format("'%s' is not a file or a directory", file.getPath()));
        }
        if (file.isFile() && !file.canRead()) {
            throw new VncException(String.format("The file '%s' has no read permission", file.getPath()));
        }
        if (file.isDirectory() && !file.canRead()) {
            throw new VncException(String.format("The directory '%s' has no read permission", file.getPath()));
        }
    }

    public static void validateWritableDirectory(File file) {
        if (!file.isDirectory()) {
            throw new VncException(String.format("'%s' is not a directory", file.getPath()));
        }
        if (!file.canWrite()) {
            throw new VncException(String.format("The directory '%s' has no write permission", file.getPath()));
        }
    }

    private static void updateDownloadProgress(VncFunction fn, long percentage, long elapsedMillis, VncKeyword status) {
        if (fn != null) {
            try {
                int arity = fn.getFixedArgsCount();
                if (arity == 3) {
                    fn.apply(VncList.of(new VncLong(percentage), status, new VncLong(elapsedMillis)));
                } else {
                    fn.apply(VncList.of(new VncLong(percentage), status));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] slurpData(BufferedInputStream is, VncFunction progressFn, long contentLength) throws Exception {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int n;
            IOFunctions.updateDownloadProgress(progressFn, 0L, -1L, new VncKeyword("progress"));
            byte[] buffer = new byte[16384];
            long total = 0L;
            long progressLast = 0L;
            while (-1 != (n = is.read(buffer))) {
                output.write(buffer, 0, n);
                long progress = Math.max(0L, Math.min(100L, (total += (long)n) * 100L / contentLength));
                if (progress != progressLast && progress < 100L) {
                    IOFunctions.updateDownloadProgress(progressFn, progress, -1L, new VncKeyword("progress"));
                }
                progressLast = progress;
            }
            IOFunctions.updateDownloadProgress(progressFn, 100L, -1L, new VncKeyword("progress"));
            Thread.sleep(100L);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    private static File normalize(File file, Normalizer.Form form) {
        return new File(Normalizer.normalize(file.getPath(), form));
    }

    private static String toString(Throwable th) {
        if (th != null) {
            if (th instanceof VncException) {
                return ((VncException)th).getCallStackAsString(null);
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println();
            th.printStackTrace(pw);
            pw.close();
            return sw.toString();
        }
        return "";
    }

    private static final String globPatternHelp() {
        return "**Globbing patterns**\n\n| [![width: 20%]] | [![width: 80%]] |\n| `*.txt`       | Matches a path that represents a file name ending in .txt |\n| `*.*`         | Matches file names containing a dot |\n| `*.{txt,xml}` | Matches file names ending with .txt or .xml |\n| `foo.?[xy]`   | Matches file names starting with foo. and a single character extension followed by a 'x' or 'y' character |\n| `/home/*/*`   | Matches `/home/gus/data` on UNIX platforms |\n| `/home/**`    | Matches `/home/gus` and `/home/gus/data` on UNIX platforms |\n| `C:\\\\*`     | Matches `C:\\\\foo` and `C:\\\\bar` on the Windows platform |\n\n*Ranges*\n\nThe pattern `[A-E]` would match any character that included ABCDE. Ranges can be used in conjunction with each other to make powerful patterns. Alphanumerical strings are matched by `[A-Za-z0-9]`. This would match the following:\n\n * `[A-Z]` All uppercase letters from A to Z\n * `[a-z]` All lowercase letters from a to z\n * `[0-9]` All numbers from 0 to 9\n\n*Complementation*\n\nGlobs can be used in complement with special characters that can change how the pattern works. The two complement characters are exclamation marks `(!)` and backslashes `(\\)`.\n\nThe exclamation mark can negate a pattern that it is put in front of. As `[CBR]at` matches Cat, Bat, or Rat the negated pattern `[!CBR]at` matches\nanything like Kat, Pat, or Vat.\n\nBackslashes are used to remove the special meaning of single characters `'?'`, `'*'`, and `'['`, so that they can be used in patterns.";
    }

    private static VncFunction downloadDummyFn() {
        return new VncFunction(VncFunction.createAnonymousFuncName("download-dummy")){
            private static final long serialVersionUID = 1L;

            @Override
            public VncVal apply(VncList args) {
                return Constants.Nil;
            }
        };
    }
}

