/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.FunctionArgsTypeHints;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMapEntry;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.callstack.CallFrame;
import com.github.jlangch.venice.impl.util.callstack.WithCallStack;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Destructuring {
    private static final VncKeyword KEYWORD_AS = new VncKeyword(":as");
    private static final VncKeyword KEYWORD_OR = new VncKeyword(":or");
    private static final VncKeyword KEYWORD_KEYS = new VncKeyword(":keys");
    private static final VncKeyword KEYWORD_SYMS = new VncKeyword(":syms");
    private static final VncKeyword KEYWORD_STRS = new VncKeyword(":strs");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Var> destructure(VncVal symVal, VncVal bindVal) {
        ArrayList<Var> bindings = new ArrayList<Var>();
        if (Types.isVncSymbol(symVal)) {
            bindings.add(new Var((VncSymbol)symVal, bindVal, Var.Scope.Local));
            return bindings;
        }
        if (Types.isVncSequence(symVal)) {
            if (Types.isVncSequence(bindVal)) {
                Destructuring.sequential_list_destructure((VncSequence)symVal, (VncSequence)bindVal, bindVal, bindings);
                return bindings;
            }
            if (Types.isVncString(bindVal)) {
                Destructuring.sequential_list_destructure((VncSequence)symVal, ((VncString)bindVal).toVncList(), (VncString)bindVal, bindings);
                return bindings;
            }
            if (Types.isVncMapEntry(bindVal)) {
                Destructuring.sequential_list_destructure((VncSequence)symVal, ((VncMapEntry)bindVal).toVector(), bindVal, bindings);
                return bindings;
            }
            if (bindVal == Constants.Nil) {
                Destructuring.sequential_list_destructure((VncSequence)symVal, VncList.empty(), bindVal, bindings);
                return bindings;
            }
            WithCallStack cs = new WithCallStack(Destructuring.callframe(bindVal));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException(String.format("Invalid sequential destructuring bind value type %s. Expected list, vector, or string.", Types.getType(bindVal)));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs == null) throw throwable3;
                if (throwable == null) {
                    cs.close();
                    throw throwable3;
                }
                try {
                    cs.close();
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throwable.addSuppressed(throwable4);
                    throw throwable3;
                }
            }
        }
        if (Types.isVncMap(symVal)) {
            if (Types.isVncMap(bindVal)) {
                Destructuring.associative_map_destructure((VncMap)symVal, (VncMap)bindVal, bindings);
                return bindings;
            }
            if (Types.isVncVector(bindVal)) {
                WithCallStack cs = new WithCallStack(Destructuring.callframe(bindVal));
                Throwable throwable = null;
                try {
                    try {
                        throw new VncException(String.format("Associative destructuring on vector is not yet implemented.", new Object[0]));
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                catch (Throwable throwable6) {
                    if (cs == null) throw throwable6;
                    if (throwable == null) {
                        cs.close();
                        throw throwable6;
                    }
                    try {
                        cs.close();
                        throw throwable6;
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                        throw throwable6;
                    }
                }
            }
            if (bindVal == Constants.Nil) {
                Destructuring.associative_map_destructure((VncMap)symVal, new VncHashMap(), bindings);
                return bindings;
            }
            WithCallStack cs = new WithCallStack(Destructuring.callframe(bindVal));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException(String.format("Invalid associative destructuring bind value type %s. Expected map.", Types.getType(bindVal)));
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
            }
            catch (Throwable throwable9) {
                if (cs == null) throw throwable9;
                if (throwable == null) {
                    cs.close();
                    throw throwable9;
                }
                try {
                    cs.close();
                    throw throwable9;
                }
                catch (Throwable throwable10) {
                    throwable.addSuppressed(throwable10);
                    throw throwable9;
                }
            }
        }
        WithCallStack cs = new WithCallStack(Destructuring.callframe(symVal));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Invalid destructuring sym value type %s. Expected symbol.", Types.getType(symVal)));
            }
            catch (Throwable throwable11) {
                throwable = throwable11;
                throw throwable11;
            }
        }
        catch (Throwable throwable12) {
            if (cs == null) throw throwable12;
            if (throwable == null) {
                cs.close();
                throw throwable12;
            }
            try {
                cs.close();
                throw throwable12;
            }
            catch (Throwable throwable13) {
                throwable.addSuppressed(throwable13);
                throw throwable12;
            }
        }
    }

    public static boolean isFnParamsWithoutDestructuring(VncVector params) {
        for (int ii = 0; ii < params.size(); ++ii) {
            VncVal param = params.nth(ii);
            if (param instanceof VncSymbol) {
                String sym = ((VncSymbol)param).getName();
                if (!sym.equals("_") && !sym.equals("&")) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static void sequential_list_destructure(VncSequence symVals, VncSequence bindVals, VncVal originalBindVal, List<Var> bindings) {
        VncSequence symValsRest = symVals;
        VncSequence bindValsRest = bindVals;
        while (!symValsRest.isEmpty()) {
            VncVal bindVal;
            VncVal symVal = symValsRest.first();
            symValsRest = symValsRest.rest();
            if (Types.isVncSymbol(symVal)) {
                VncVal bindVal2;
                VncSymbol sym;
                String symName = ((VncSymbol)symVal).getName();
                if (symName.equals("_")) {
                    bindValsRest = bindValsRest.rest();
                    continue;
                }
                if (symName.equals("&")) {
                    sym = (VncSymbol)symValsRest.first();
                    symValsRest = symValsRest.rest();
                    bindVal2 = bindValsRest.isEmpty() ? Constants.Nil : bindValsRest;
                    bindValsRest = VncList.empty();
                    bindings.add(new Var(sym, bindVal2, Var.Scope.Local));
                    continue;
                }
                sym = (VncSymbol)symVal;
                bindVal2 = bindValsRest.first();
                bindValsRest = bindValsRest.rest();
                FunctionArgsTypeHints.validate(sym, bindVal2);
                bindings.add(new Var(sym, bindVal2, Var.Scope.Local));
                continue;
            }
            if (Destructuring.isAsKeyword(symVal)) {
                VncSymbol sym = (VncSymbol)symValsRest.first();
                symValsRest = symValsRest.rest();
                bindings.add(new Var(sym, originalBindVal, Var.Scope.Local));
                continue;
            }
            if (Types.isVncSequence(symVal)) {
                bindVal = bindValsRest.isEmpty() ? VncList.empty() : bindValsRest.first();
                bindValsRest = bindValsRest.rest();
                bindings.addAll(Destructuring.destructure(symVal, bindVal));
                continue;
            }
            if (!Types.isVncMap(symVal)) continue;
            bindVal = bindValsRest.isEmpty() ? VncHashMap.empty() : bindValsRest.first();
            bindValsRest = bindValsRest.rest();
            Destructuring.associative_map_destructure((VncMap)symVal, (VncMap)bindVal, bindings);
        }
    }

    private static void associative_map_destructure(VncMap symVals, VncMap bindVals, List<Var> bindings) {
        ArrayList<Var> local_bindings = new ArrayList<Var>();
        List<VncVal> symbols = Destructuring.sortAssociativeNames(symVals.keys());
        for (int ii = 0; ii < symbols.size(); ++ii) {
            VncSequence nestedBindVals;
            Iterator<Map.Entry<VncVal, VncVal>> cs;
            VncVal v;
            Serializable sym2;
            VncVal symbol;
            VncVal symValName = symbols.get(ii);
            if (symValName.equals(KEYWORD_KEYS)) {
                symbol = symVals.get(KEYWORD_KEYS);
                if (Types.isVncVector(symbol)) {
                    for (Serializable sym2 : (VncVector)symbol) {
                        VncSymbol s = (VncSymbol)sym2;
                        v = bindVals.get(new VncKeyword(s.getName()));
                        FunctionArgsTypeHints.validate(s, v);
                        local_bindings.add(new Var(s, v, Var.Scope.Local));
                    }
                    continue;
                }
                cs = new WithCallStack(Destructuring.callframe(symbol));
                sym2 = null;
                try {
                    try {
                        throw new VncException(String.format("Invalid associative destructuring with :keys symbol type %s. Expected vector.", Types.getType(symbol)));
                    }
                    catch (Throwable s) {
                        sym2 = s;
                        throw s;
                    }
                }
                catch (Throwable throwable) {
                    if (cs != null) {
                        if (sym2 != null) {
                            try {
                                ((WithCallStack)((Object)cs)).close();
                            }
                            catch (Throwable throwable2) {
                                ((Throwable)sym2).addSuppressed(throwable2);
                            }
                        } else {
                            ((WithCallStack)((Object)cs)).close();
                        }
                    }
                    throw throwable;
                }
            }
            if (symValName.equals(KEYWORD_SYMS)) {
                symbol = symVals.get(KEYWORD_SYMS);
                if (Types.isVncVector(symbol)) {
                    for (Serializable sym2 : (VncVector)symbol) {
                        VncSymbol s = (VncSymbol)sym2;
                        v = bindVals.get(s);
                        FunctionArgsTypeHints.validate(s, v);
                        local_bindings.add(new Var(s, v, Var.Scope.Local));
                    }
                    continue;
                }
                cs = new WithCallStack(Destructuring.callframe(symbol));
                sym2 = null;
                try {
                    try {
                        throw new VncException(String.format("Invalid associative destructuring with :syms symbol type %s. Expected vector.", Types.getType(symbol)));
                    }
                    catch (Throwable s) {
                        sym2 = s;
                        throw s;
                    }
                }
                catch (Throwable throwable) {
                    if (cs != null) {
                        if (sym2 != null) {
                            try {
                                ((WithCallStack)((Object)cs)).close();
                            }
                            catch (Throwable throwable3) {
                                ((Throwable)sym2).addSuppressed(throwable3);
                            }
                        } else {
                            ((WithCallStack)((Object)cs)).close();
                        }
                    }
                    throw throwable;
                }
            }
            if (symValName.equals(KEYWORD_STRS)) {
                symbol = symVals.get(KEYWORD_STRS);
                if (Types.isVncVector(symbol)) {
                    for (Serializable sym2 : (VncVector)symbol) {
                        VncSymbol s = (VncSymbol)sym2;
                        v = bindVals.get(new VncString(s.getName()));
                        FunctionArgsTypeHints.validate(s, v);
                        local_bindings.add(new Var(s, v, Var.Scope.Local));
                    }
                    continue;
                }
                cs = new WithCallStack(Destructuring.callframe(symbol));
                sym2 = null;
                try {
                    try {
                        throw new VncException(String.format("Invalid associative destructuring with :strs symbol type %s. Expected vector.", Types.getType(symbol)));
                    }
                    catch (Throwable s) {
                        sym2 = s;
                        throw s;
                    }
                }
                catch (Throwable throwable) {
                    if (cs != null) {
                        if (sym2 != null) {
                            try {
                                ((WithCallStack)((Object)cs)).close();
                            }
                            catch (Throwable throwable4) {
                                ((Throwable)sym2).addSuppressed(throwable4);
                            }
                        } else {
                            ((WithCallStack)((Object)cs)).close();
                        }
                    }
                    throw throwable;
                }
            }
            if (symValName.equals(KEYWORD_OR)) {
                symbol = symVals.get(KEYWORD_OR);
                if (symbol == Constants.Nil || !Types.isVncMap(symbol)) continue;
                for (Map.Entry<VncVal, VncVal> e : ((VncMap)symbol).getJavaMap().entrySet()) {
                    int bIdx = Var.getVarIndex((VncSymbol)e.getKey(), local_bindings);
                    if (bIdx == -1) {
                        local_bindings.add(new Var((VncSymbol)e.getKey(), e.getValue(), Var.Scope.Local));
                        continue;
                    }
                    Var b = (Var)local_bindings.get(bIdx);
                    if (b.getVal() != Constants.Nil) continue;
                    local_bindings.set(bIdx, new Var((VncSymbol)e.getKey(), e.getValue(), Var.Scope.Local));
                }
                continue;
            }
            if (symValName.equals(KEYWORD_AS)) {
                symbol = symVals.get(KEYWORD_AS);
                if (symbol == Constants.Nil || !Types.isVncSymbol(symbol)) continue;
                local_bindings.add(new Var((VncSymbol)symbol, bindVals, Var.Scope.Local));
                continue;
            }
            if (Types.isVncMap(symValName)) {
                VncVal v2 = bindVals.get(symVals.get(symValName));
                Destructuring.associative_map_destructure((VncMap)symValName, v2 == Constants.Nil ? new VncHashMap() : (VncMap)v2, local_bindings);
                continue;
            }
            if (Types.isVncVector(symValName)) {
                nestedBindVals = (VncSequence)bindVals.get(symVals.get(symValName));
                Destructuring.sequential_list_destructure((VncVector)symValName, nestedBindVals, nestedBindVals, local_bindings);
                continue;
            }
            if (Types.isVncList(symValName)) {
                nestedBindVals = (VncSequence)bindVals.get(symVals.get(symValName));
                Destructuring.sequential_list_destructure((VncList)symValName, nestedBindVals, nestedBindVals, local_bindings);
                continue;
            }
            if (Types.isVncSymbol(symValName)) {
                VncVal s = symVals.get(symValName);
                VncVal v3 = bindVals.get(s);
                local_bindings.add(new Var((VncSymbol)symValName, v3, Var.Scope.Local));
                continue;
            }
            WithCallStack cs2 = new WithCallStack(Destructuring.callframe(symValName));
            Object object = null;
            try {
                try {
                    throw new VncException(String.format("Invalid associative destructuring name type %s.", Types.getType(symValName)));
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                if (cs2 != null) {
                    if (object != null) {
                        try {
                            cs2.close();
                        }
                        catch (Throwable throwable5) {
                            ((Throwable)object).addSuppressed(throwable5);
                        }
                    } else {
                        cs2.close();
                    }
                }
                throw throwable;
            }
        }
        bindings.addAll(local_bindings);
    }

    private static boolean isAsKeyword(VncVal val) {
        return Types.isVncKeyword(val) && ((VncKeyword)val).equals(KEYWORD_AS);
    }

    private static List<VncVal> sortAssociativeNames(VncList names) {
        ArrayList<VncVal> sorted = new ArrayList<VncVal>();
        for (VncVal n : names) {
            if (!Destructuring.is_KEYS_SYMS_STRS(n)) continue;
            sorted.add(n);
        }
        for (VncVal n : names) {
            if (n == Constants.Nil || Destructuring.is_KEYS_SYMS_STRS(n) || Destructuring.is_AS_OR(n)) continue;
            sorted.add(n);
        }
        for (VncVal n : names) {
            if (!Destructuring.is_AS_OR(n)) continue;
            sorted.add(n);
        }
        return sorted;
    }

    private static boolean is_KEYS_SYMS_STRS(VncVal n) {
        return n.equals(KEYWORD_KEYS) || n.equals(KEYWORD_SYMS) || n.equals(KEYWORD_STRS);
    }

    private static boolean is_AS_OR(VncVal n) {
        return n.equals(KEYWORD_AS) || n.equals(KEYWORD_OR);
    }

    private static CallFrame callframe(VncVal val) {
        return new CallFrame("destructuring", val.getMeta());
    }
}

