/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.examples;

import com.github.jlangch.venice.IServiceDiscovery;
import com.github.jlangch.venice.Venice;
import com.github.jlangch.venice.VncException;

public class Embed_13_DynServiceRegistry {
    public static void main(String[] args) {
        try {
            Embed_13_DynServiceRegistry.run();
            System.exit(0);
        }
        catch (VncException ex) {
            ex.printVeniceStackTrace();
            System.exit(1);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public static void run() {
        Venice venice = new Venice();
        venice.getServiceRegistry().registerServiceDiscovery(new TestServiceDiscovery());
        System.out.println(venice.eval("(service :Calculator :add 10 20)"));
        System.out.println(venice.eval("(service :Calculator :multiply 10 20)"));
        venice.eval("(service :Logger :log \"Test message\")");
    }

    public static class Logger {
        public void log(String message) {
            System.out.println(message);
        }
    }

    public static class Calculator {
        public long add(long v1, long v2) {
            return v1 + v2;
        }

        public long multiply(long v1, long v2) {
            return v1 * v2;
        }
    }

    public static class TestServiceDiscovery
    implements IServiceDiscovery {
        private final Calculator calculator = new Calculator();
        private final Logger logger = new Logger();

        @Override
        public Object lookup(String name) {
            if (name == null) {
                throw new IllegalArgumentException("A service name must not be null");
            }
            switch (name) {
                case "Calculator": {
                    return this.calculator;
                }
                case "Logger": {
                    return this.logger;
                }
            }
            return null;
        }
    }
}

