/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.io.timeandspace.cronscheduler;

import java.time.Clock;
import net.jcip.annotations.NotThreadSafe;
import org.repackage.io.timeandspace.cronscheduler.CronTask;
import org.repackage.io.timeandspace.cronscheduler.MathUtils;
import org.repackage.io.timeandspace.cronscheduler.PeriodicScheduling;

@NotThreadSafe
final class FixedRatePeriodicScheduling<V>
extends PeriodicScheduling<V> {
    private final long periodMillis;
    private final boolean skippingToLatest;
    private long nextScheduledRunTimeMillis;

    FixedRatePeriodicScheduling(Clock timeProvider, CronTask task, long triggerTimeMillis, long periodMillis, boolean skippingToLatest) {
        super(timeProvider, task);
        this.periodMillis = periodMillis;
        this.skippingToLatest = skippingToLatest;
        this.nextScheduledRunTimeMillis = triggerTimeMillis;
    }

    @Override
    public V call() throws Exception {
        long lagMillis;
        if (this.skippingToLatest && (lagMillis = this.timeProvider.millis() - this.nextScheduledRunTimeMillis) >= this.periodMillis) {
            long skipMillis = MathUtils.roundDown(lagMillis, this.periodMillis);
            this.nextScheduledRunTimeMillis += skipMillis;
        }
        this.task.run(this.nextScheduledRunTimeMillis);
        return null;
    }

    @Override
    public void setNextRunTime() {
        this.nextScheduledRunTimeMillis += this.periodMillis;
    }

    @Override
    public boolean rewind(long newTimeMillis) {
        if (this.nextScheduledRunTimeMillis <= newTimeMillis) {
            return false;
        }
        this.nextScheduledRunTimeMillis -= MathUtils.roundUp(this.nextScheduledRunTimeMillis - newTimeMillis, this.periodMillis);
        return true;
    }

    @Override
    public long nextScheduledRunTimeMillis() {
        return this.nextScheduledRunTimeMillis;
    }
}

