/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.com.github.jlangch.aviron.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.repackage.com.github.jlangch.aviron.util.DirCycler;
import org.repackage.com.github.jlangch.aviron.util.IDirCycler;

public class DemoFilestore
implements Closeable {
    private static final String eicar = "X_5_O_!_P_%_@_A_P_[_4_\\_P_Z_X_5_4_(_P_^_)_7_C_C_)_7_}_$_E_I_C_A_R_-_S_T_A_N_D_A_R_D_-_A_N_T_I_V_I_R_U_S_-_T_E_S_T_-_F_I_L_E_!_$_H_+_H_*";
    private final File rootDir = this.createTempDir();
    private final File filestoreDir = new File(this.rootDir, "filestore");
    private final File quarantineDir = new File(this.rootDir, "quarantine");
    private final IDirCycler dirCycler;

    public DemoFilestore() {
        this.filestoreDir.mkdir();
        this.quarantineDir.mkdir();
        this.dirCycler = new DirCycler(this.filestoreDir);
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public File getFilestoreDir() {
        return this.filestoreDir;
    }

    public File getQuarantineDir() {
        return this.quarantineDir;
    }

    public File getClamdPidFile() {
        return new File(this.rootDir, "clamd.pid");
    }

    @Override
    public void close() {
        try {
            Files.walk(this.rootDir.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to remove demo filestore", ex);
        }
    }

    public void populateWithDemoFiles(int dirs, int filesPerDir) {
        for (int d = 0; d < Math.min(100, dirs); ++d) {
            String dir = String.format("%03d", d);
            this.createFilestoreSubDir(dir);
            for (int f = 0; f < Math.min(100, filesPerDir); ++f) {
                this.createFilestoreFile(dir, String.format(dir, "file-%03d.txt", "TEST"));
            }
        }
    }

    public File createFilestoreSubDir(String name) {
        File dir = new File(this.filestoreDir, name);
        dir.mkdir();
        return dir;
    }

    public List<File> listFilestoreSubDirs() {
        return Arrays.stream(this.filestoreDir.listFiles()).filter(f -> f.isDirectory()).sorted().collect(Collectors.toList());
    }

    public File createFilestoreFile(String subDir, String filename) {
        return this.createFilestoreFile(subDir, filename, "TEST");
    }

    public File createFilestoreFile(String subDir, String filename, String data) {
        String fsFile = new File(subDir).getName() + "/" + new File(filename).getName();
        File file = new File(this.filestoreDir, fsFile);
        try {
            Files.write(file.toPath(), this.toBytes(data), new OpenOption[0]);
            return file;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to create file store file " + fsFile, ex);
        }
    }

    public File touchFilestoreFile(String subDir, String filename) {
        String fsFile = new File(subDir).getName() + "/" + new File(filename).getName();
        File file = new File(this.filestoreDir, fsFile);
        try {
            Path path = file.toPath();
            if (Files.exists(path, new LinkOption[0])) {
                Files.setLastModifiedTime(path, FileTime.fromMillis(System.currentTimeMillis()));
            } else {
                Files.createFile(path, new FileAttribute[0]);
            }
            return file;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to touch file store file " + fsFile, ex);
        }
    }

    public File appendToFilestoreFile(String subDir, String filename) {
        String fsFile = new File(subDir).getName() + "/" + new File(filename).getName();
        File file = new File(this.filestoreDir, fsFile);
        if (file.isFile()) {
            try {
                Files.write(file.toPath(), this.toBytes(",TEST"), StandardOpenOption.APPEND);
                return file;
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to append to the file store file " + fsFile, ex);
            }
        }
        throw new RuntimeException("Failed to append to file store file " + fsFile + "! It does not exist!");
    }

    public void deleteFilestoreFile(String subDir, String filename) {
        String fsFile = new File(subDir).getName() + "/" + new File(filename).getName();
        File file = new File(this.filestoreDir, fsFile);
        try {
            if (file.isFile() && !file.delete()) {
                throw new RuntimeException("Failed to remove file store file " + fsFile);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to remove file store file " + fsFile);
        }
    }

    public File createEicarAntiMalwareTestFile(String subDir) {
        String fsFile = new File(subDir).getName() + "/eicar.txt";
        File file = new File(this.filestoreDir, fsFile);
        try {
            Files.write(file.toPath(), this.toBytes(eicar.replace("_", "")), new OpenOption[0]);
            return file;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to append to the file store file " + fsFile, ex);
        }
    }

    public long countFilestoreFiles() {
        try {
            return Files.walk(this.filestoreDir.toPath(), new FileVisitOption[0]).map(Path::toFile).filter(f -> f.isFile()).count();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed count filestore files", ex);
        }
    }

    public long countQuarantineFiles() {
        return Arrays.stream(this.quarantineDir.listFiles()).filter(f -> f.isFile()).filter(f -> !f.getName().endsWith(".virus")).count();
    }

    public void clearQuarantine() {
        try {
            Files.walk(this.quarantineDir.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            this.quarantineDir.mkdir();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to remove demo filestore", ex);
        }
    }

    public IDirCycler getFilestoreDirCycler() {
        return this.dirCycler;
    }

    private File createTempDir() {
        try {
            return Files.createTempDirectory("demo_", new FileAttribute[0]).toFile();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to create demo file store", ex);
        }
    }

    private byte[] toBytes(String text) {
        return text.getBytes(Charset.defaultCharset());
    }
}

