/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.com.github.jlangch.aviron.processor;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.repackage.com.github.jlangch.aviron.events.FileWatchErrorEvent;
import org.repackage.com.github.jlangch.aviron.events.FileWatchFileEvent;
import org.repackage.com.github.jlangch.aviron.events.RealtimeScanEvent;
import org.repackage.com.github.jlangch.aviron.ex.FileWatcherException;
import org.repackage.com.github.jlangch.aviron.filewatcher.FileWatcherQueue;
import org.repackage.com.github.jlangch.aviron.filewatcher.IFileWatcher;
import org.repackage.com.github.jlangch.aviron.util.service.Service;
import org.repackage.com.github.jlangch.aviron.util.service.ServiceStatus;

public class RealtimeFileProcessor
extends Service {
    private static final int BATCH_SIZE = 100;
    private static final int MAX_QUEUE_SIZE = 5000;
    private static final int MAX_ERROR_COUNT = 1000;
    private final IFileWatcher watcher;
    private final Consumer<RealtimeScanEvent> scanListener;
    private final int sleepTimeSecondsOnIdle;
    private AtomicLong errorCount = new AtomicLong();
    private AtomicReference<FileWatcherQueue> fileWatcherQueue = new AtomicReference();

    public RealtimeFileProcessor(IFileWatcher watcher, int sleepTimeSecondsOnIdle, Consumer<RealtimeScanEvent> scanListener, Consumer<FileWatchErrorEvent> errorListener) {
        if (watcher == null) {
            throw new IllegalArgumentException("A 'watcher' must not be null!");
        }
        if (scanListener == null) {
            throw new IllegalArgumentException("A 'scanListener' must not be null!");
        }
        this.watcher = watcher;
        this.sleepTimeSecondsOnIdle = Math.max(1, sleepTimeSecondsOnIdle);
        this.scanListener = scanListener;
        watcher.setFileListener(this::onFileEvent);
        watcher.setErrorListener(errorListener);
        watcher.setTerminationListener(null);
    }

    @Override
    protected String name() {
        return this.getClass().getSimpleName();
    }

    @Override
    protected void onStart() {
        this.fileWatcherQueue.set(new FileWatcherQueue(5000));
        try {
            this.watcher.start();
        }
        catch (Exception ex) {
            throw new FileWatcherException(String.format("Failed to start FileWatcher on dir '%s'", this.watcher.getMainDir().toString()), ex);
        }
        this.startServiceThread(this.createWorker());
    }

    @Override
    protected void onClose() throws IOException {
        if (this.watcher.getStatus() == ServiceStatus.RUNNING) {
            this.watcher.close();
        }
    }

    private Runnable createWorker() {
        return () -> {
            FileWatcherQueue queue = this.fileWatcherQueue.get();
            this.enteredRunningState();
            while (this.isInRunningState()) {
                try {
                    int ii;
                    for (ii = 0; ii < 100 && this.isInRunningState(); ++ii) {
                        File file = queue.pop(true);
                        if (file == null || !file.isFile()) continue;
                        this.fireEvent(new RealtimeScanEvent(file.toPath()));
                    }
                    if (!queue.isEmpty()) continue;
                    if (this.sleepTimeSecondsOnIdle == 0 && this.isInRunningState()) {
                        this.sleep(100);
                        continue;
                    }
                    for (ii = 0; ii < this.sleepTimeSecondsOnIdle && this.isInRunningState(); ++ii) {
                        this.sleep(1000);
                    }
                }
                catch (Exception ex) {
                    if (this.errorCount.incrementAndGet() > 1000L) {
                        throw new FileWatcherException("Realtime file scanner exceeded the max error count! Scanning stopped!");
                    }
                    this.sleep(5000);
                }
            }
        };
    }

    private void onFileEvent(FileWatchFileEvent event) {
        FileWatcherQueue queue = this.fileWatcherQueue.get();
        if (event.isFile()) {
            switch (event.getType()) {
                case CREATED: 
                case MODIFIED: {
                    queue.push(event.getPath().toFile());
                    break;
                }
                case DELETED: {
                    queue.remove(event.getPath().toFile());
                    break;
                }
            }
        }
    }

    private void fireEvent(RealtimeScanEvent event) {
        this.safeRun(() -> this.scanListener.accept(event));
    }

    private void safeRun(Runnable r) {
        try {
            r.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

