/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.com.github.jlangch.aviron.processor;

import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import org.repackage.com.github.jlangch.aviron.events.FilestoreScanEvent;
import org.repackage.com.github.jlangch.aviron.util.IDirCycler;
import org.repackage.com.github.jlangch.aviron.util.service.Service;

public class FilestoreDirProcessor
extends Service {
    private final IDirCycler cycler;
    private final Consumer<FilestoreScanEvent> scanListener;
    private final int sleepTimeSecondsOnIdle;
    private final int sleepTimeSecondsAtRollover;

    public FilestoreDirProcessor(IDirCycler cycler, int sleepTimeSecondsOnIdle, int sleepTimeSecondsAtRollover, Consumer<FilestoreScanEvent> scanListener) {
        if (cycler == null) {
            throw new IllegalArgumentException("A 'cycler' must not be null!");
        }
        if (scanListener == null) {
            throw new IllegalArgumentException("A 'scanListener' must not be null!");
        }
        this.cycler = cycler;
        this.sleepTimeSecondsOnIdle = Math.max(1, sleepTimeSecondsOnIdle);
        this.sleepTimeSecondsAtRollover = Math.max(1, sleepTimeSecondsAtRollover);
        this.scanListener = scanListener;
    }

    @Override
    protected String name() {
        return this.getClass().getSimpleName();
    }

    @Override
    protected void onStart() {
        this.cycler.refresh();
        this.startServiceThread(this.createWorker());
    }

    @Override
    protected void onClose() throws IOException {
    }

    private Runnable createWorker() {
        return () -> {
            this.enteredRunningState();
            while (this.isInRunningState()) {
                try {
                    if (this.cycler.isEmpty()) {
                        Thread.sleep(this.sleepTimeSecondsOnIdle * 1000);
                        continue;
                    }
                    File dir = this.cycler.nextDir();
                    this.fireEvent(new FilestoreScanEvent(dir.toPath()));
                    if (!this.cycler.isLast()) continue;
                    Thread.sleep(this.sleepTimeSecondsAtRollover * 1000);
                }
                catch (Exception ex) {
                    this.sleep(5000);
                }
            }
        };
    }

    private void fireEvent(FilestoreScanEvent event) {
        this.safeRun(() -> this.scanListener.accept(event));
    }

    private void safeRun(Runnable r) {
        try {
            r.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

