/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.com.github.jlangch.aviron.limiter;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.repackage.com.github.jlangch.aviron.limiter.CpuProfile;

public class DynamicCpuLimit {
    private static String[] DAYS = new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
    private final Function<LocalDateTime, Integer> dynamicLimitFn;
    private final List<CpuProfile> dayOfWeekProfiles = new ArrayList<CpuProfile>();

    public DynamicCpuLimit() {
        this((CpuProfile)null);
    }

    public DynamicCpuLimit(CpuProfile profile) {
        CpuProfile p = profile != null ? profile : CpuProfile.defaultProfile();
        this.dynamicLimitFn = ts -> p.getLimit(ts.toLocalTime());
        this.dayOfWeekProfiles.add(profile);
    }

    public DynamicCpuLimit(List<CpuProfile> dayOfWeekProfiles) {
        if (dayOfWeekProfiles == null) {
            throw new IllegalArgumentException("A dayOfWeekProfiles list must not be null");
        }
        if (dayOfWeekProfiles.size() != 7) {
            throw new IllegalArgumentException("A dayOfWeekProfiles list must provide 7 entries (Mon to Sun)");
        }
        if (dayOfWeekProfiles.stream().anyMatch(p -> p == null)) {
            throw new IllegalArgumentException("At least one item of the dayOfWeekProfiles list is null!");
        }
        ArrayList<CpuProfile> profiles = new ArrayList<CpuProfile>(dayOfWeekProfiles);
        this.dynamicLimitFn = ts -> {
            int dayOfWeek = ts.getDayOfWeek().getValue();
            return ((CpuProfile)profiles.get(dayOfWeek - 1)).getLimit(ts.toLocalTime());
        };
        this.dayOfWeekProfiles.addAll(dayOfWeekProfiles);
    }

    public DynamicCpuLimit(Function<LocalDateTime, Integer> dynamicLimitFn) {
        if (dynamicLimitFn == null) {
            throw new IllegalArgumentException("A dynamicLimitFn function must not be null");
        }
        this.dynamicLimitFn = dynamicLimitFn;
    }

    public int computeCpuLimit() {
        return this.computeCpuLimit(LocalDateTime.now());
    }

    public int computeCpuLimit(LocalDateTime ts) {
        if (ts == null) {
            throw new IllegalArgumentException("A ts must not be null");
        }
        int limit = this.dynamicLimitFn.apply(ts);
        return Math.max(0, limit);
    }

    public String formatProfilesAsTableByHour() {
        StringBuilder sb = new StringBuilder();
        sb.append("---------------------------------------------------------");
        sb.append(System.lineSeparator());
        sb.append("Time        Mon    Tue    Wed    Thu    Fri    Sat    Sun");
        sb.append(System.lineSeparator());
        sb.append("---------------------------------------------------------");
        sb.append(System.lineSeparator());
        for (int hour = 0; hour < 24; ++hour) {
            sb.append(String.format("%02d:00     %4d%%  %4d%%  %4d%%  %4d%%  %4d%%  %4d%%  %4d%%", hour, this.computeCpuLimit(LocalDateTime.of(2025, 7, 21, hour, 0, 0)), this.computeCpuLimit(LocalDateTime.of(2025, 7, 22, hour, 0, 0)), this.computeCpuLimit(LocalDateTime.of(2025, 7, 23, hour, 0, 0)), this.computeCpuLimit(LocalDateTime.of(2025, 7, 24, hour, 0, 0)), this.computeCpuLimit(LocalDateTime.of(2025, 7, 25, hour, 0, 0)), this.computeCpuLimit(LocalDateTime.of(2025, 7, 26, hour, 0, 0)), this.computeCpuLimit(LocalDateTime.of(2025, 7, 27, hour, 0, 0))));
            sb.append(System.lineSeparator());
        }
        sb.append("---------------------------------------------------------");
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.dayOfWeekProfiles.isEmpty()) {
            sb.append("Compute Function (fn[LocalDateTime] -> int)");
        } else if (this.dayOfWeekProfiles.size() == 1) {
            sb.append("Single day profile:");
            sb.append(System.lineSeparator());
            CpuProfile p = this.dayOfWeekProfiles.get(0);
            p.getEntries().forEach(e -> {
                sb.append("  " + e.toString());
                sb.append(System.lineSeparator());
            });
        } else {
            sb.append("7 day profile:");
            sb.append(System.lineSeparator());
            int dayOfWeek = 0;
            for (CpuProfile p : this.dayOfWeekProfiles) {
                sb.append("  " + DAYS[dayOfWeek]);
                sb.append(System.lineSeparator());
                p.getEntries().forEach(e -> {
                    sb.append("    " + e.toString());
                    sb.append(System.lineSeparator());
                });
                ++dayOfWeek;
            }
        }
        return sb.toString();
    }
}

