/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.com.github.jlangch.aviron.impl.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class StringUtils {
    public static String trimToNull(String s) {
        if (s == null) {
            return s;
        }
        String t = s.trim();
        return t.isEmpty() ? null : t;
    }

    public static String trimToEmpty(String s) {
        return s == null ? "" : s.trim();
    }

    public static boolean isBlank(String s) {
        return s == null ? true : s.trim().isEmpty();
    }

    public static boolean isNotBlank(String s) {
        return !StringUtils.isBlank(s);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> splitIntoLines(String text) {
        if (text == null) return new ArrayList<String>();
        if (text.isEmpty()) {
            return new ArrayList<String>();
        }
        try (BufferedReader br = new BufferedReader(new StringReader(text));){
            List<String> list = br.lines().collect(Collectors.toList());
            return list;
        }
        catch (IOException | RuntimeException ex) {
            throw new RuntimeException("Failed to split text into lines", ex);
        }
    }

    public static String stripEnd(String str, String tail) {
        if (StringUtils.isBlank(str) || StringUtils.isBlank(tail)) {
            return str;
        }
        if (str.equals(tail)) {
            return "";
        }
        if (str.endsWith(tail)) {
            return str.substring(0, str.length() - tail.length());
        }
        return str;
    }

    public static List<String> toList(String ... items) {
        ArrayList<String> list = new ArrayList<String>();
        for (String it : items) {
            list.add(it);
        }
        return list;
    }
}

