/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.com.github.jlangch.aviron.dto;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ScanResult {
    private final Map<String, List<String>> foundViruses = new HashMap<String, List<String>>();

    private ScanResult(Map<String, List<String>> foundViruses) {
        if (foundViruses != null) {
            this.foundViruses.putAll(foundViruses);
        }
    }

    public static ScanResult ok() {
        return new ScanResult(null);
    }

    public static ScanResult virusFound(Map<String, List<String>> foundViruses) {
        return new ScanResult(foundViruses);
    }

    public boolean isOK() {
        return this.foundViruses.isEmpty();
    }

    public boolean hasVirus() {
        return !this.foundViruses.isEmpty();
    }

    public Map<String, List<String>> getVirusFound() {
        return Collections.unmodifiableMap(this.foundViruses);
    }

    public void mergeWith(ScanResult other) {
        if (other == null) {
            return;
        }
        other.foundViruses.forEach((k, v) -> {
            List<String> vals = this.foundViruses.get(k);
            if (vals == null) {
                this.foundViruses.put((String)k, (List<String>)v);
            } else {
                vals.addAll((Collection<String>)v);
            }
        });
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isOK()) {
            sb.append("ScanResult: OK");
        } else {
            sb.append("ScanResult: Virus found");
            for (Map.Entry<String, List<String>> e : this.foundViruses.entrySet()) {
                sb.append(System.lineSeparator());
                sb.append("File: ");
                sb.append(e.getKey());
                sb.append(System.lineSeparator());
                sb.append("Virus Signatures: ");
                sb.append(e.getValue().stream().collect(Collectors.joining(", ")));
            }
        }
        return sb.toString();
    }
}

