/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.ipc.impl.util;

import com.github.jlangch.venice.VncException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ExceptionUtil {
    public static boolean isBrokenPipeException(Throwable th) {
        if (th == null) {
            return false;
        }
        if (th instanceof IOException && ExceptionUtil.hasExMsg("Broken pipe", th)) {
            return true;
        }
        return ExceptionUtil.isBrokenPipeException(th.getCause());
    }

    public static boolean isStreamClosedException(Throwable th) {
        if (th == null) {
            return false;
        }
        if (th instanceof IOException && ExceptionUtil.hasExMsg("Stream closed", th)) {
            return true;
        }
        return ExceptionUtil.isStreamClosedException(th.getCause());
    }

    public static String printStackTraceToString(Exception ex) {
        if (ex instanceof VncException && ((VncException)ex).hasCallStack()) {
            return String.join((CharSequence)"\n", ((VncException)ex).getCallStackAsStringList());
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    private static boolean hasExMsg(String msg, Throwable th) {
        if (msg == null || th == null || th.getMessage() == null) {
            return false;
        }
        return msg.equalsIgnoreCase(th.getMessage());
    }
}

