/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.crypt;

import com.github.jlangch.venice.util.crypt.Util;
import java.io.File;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class FileEncryptor_ChaCha20 {
    private static final boolean supported = FileEncryptor_ChaCha20.checkSupported();
    private static ByteOrder ENDIAN = ByteOrder.BIG_ENDIAN;
    private static int SALT_LEN = 16;
    private static int NONCE_LEN = 12;
    private static int COUNTER_LEN = 4;

    public static boolean isSupported() {
        return supported;
    }

    public static void encryptFileWithPassphrase(String passphrase, File inputFile, File outputFile) throws Exception {
        byte[] fileData = Files.readAllBytes(inputFile.toPath());
        byte[] encryptedData = FileEncryptor_ChaCha20.encryptFileWithPassphrase(passphrase, fileData);
        Files.write(outputFile.toPath(), encryptedData, new OpenOption[0]);
    }

    public static byte[] encryptFileWithPassphrase(String passphrase, byte[] fileData) throws Exception {
        byte[] salt = new byte[SALT_LEN];
        new SecureRandom().nextBytes(salt);
        byte[] nonce = new byte[NONCE_LEN];
        new SecureRandom().nextBytes(nonce);
        int counter = new SecureRandom().nextInt();
        byte[] counterData = FileEncryptor_ChaCha20.counterToBytes(counter);
        byte[] key = Util.deriveKeyFromPassphrase(passphrase, salt, 65536, 256);
        byte[] encryptedData = FileEncryptor_ChaCha20.processData(1, fileData, key, nonce, counter);
        byte[] outData = new byte[SALT_LEN + NONCE_LEN + COUNTER_LEN + encryptedData.length];
        System.arraycopy(salt, 0, outData, 0, salt.length);
        System.arraycopy(nonce, 0, outData, SALT_LEN, nonce.length);
        System.arraycopy(counterData, 0, outData, SALT_LEN + NONCE_LEN, counterData.length);
        System.arraycopy(encryptedData, 0, outData, SALT_LEN + NONCE_LEN + COUNTER_LEN, encryptedData.length);
        return outData;
    }

    public static void encryptFileWithKey(byte[] key, File inputFile, File outputFile) throws Exception {
        byte[] fileData = Files.readAllBytes(inputFile.toPath());
        byte[] encryptedData = FileEncryptor_ChaCha20.encryptFileWithKey(key, fileData);
        Files.write(outputFile.toPath(), encryptedData, new OpenOption[0]);
    }

    public static byte[] encryptFileWithKey(byte[] key, byte[] fileData) throws Exception {
        byte[] nonce = new byte[NONCE_LEN];
        new SecureRandom().nextBytes(nonce);
        int counter = new SecureRandom().nextInt();
        byte[] counterData = FileEncryptor_ChaCha20.counterToBytes(counter);
        byte[] encryptedData = FileEncryptor_ChaCha20.processData(1, fileData, key, nonce, counter);
        byte[] outData = new byte[NONCE_LEN + COUNTER_LEN + encryptedData.length];
        System.arraycopy(nonce, 0, outData, 0, nonce.length);
        System.arraycopy(counterData, 0, outData, NONCE_LEN, counterData.length);
        System.arraycopy(encryptedData, 0, outData, NONCE_LEN + COUNTER_LEN, encryptedData.length);
        return outData;
    }

    public static void decryptFileWithPassphrase(String passphrase, File inputFile, File outputFile) throws Exception {
        byte[] fileData = Files.readAllBytes(inputFile.toPath());
        byte[] decryptedData = FileEncryptor_ChaCha20.decryptFileWithPassphrase(passphrase, fileData);
        Files.write(outputFile.toPath(), decryptedData, new OpenOption[0]);
    }

    public static byte[] decryptFileWithPassphrase(String passphrase, byte[] fileData) throws Exception {
        byte[] salt = new byte[SALT_LEN];
        System.arraycopy(fileData, 0, salt, 0, SALT_LEN);
        byte[] nonce = new byte[NONCE_LEN];
        System.arraycopy(fileData, SALT_LEN, nonce, 0, NONCE_LEN);
        byte[] counterBytes = new byte[COUNTER_LEN];
        System.arraycopy(fileData, SALT_LEN + NONCE_LEN, counterBytes, 0, COUNTER_LEN);
        byte[] encryptedData = new byte[fileData.length - SALT_LEN - NONCE_LEN - COUNTER_LEN];
        System.arraycopy(fileData, SALT_LEN + NONCE_LEN + COUNTER_LEN, encryptedData, 0, encryptedData.length);
        int counter = FileEncryptor_ChaCha20.counterToInt(counterBytes);
        byte[] key = Util.deriveKeyFromPassphrase(passphrase, salt, 65536, 256);
        return FileEncryptor_ChaCha20.processData(2, encryptedData, key, nonce, counter);
    }

    public static void decryptFileWithKey(byte[] key, File inputFile, File outputFile) throws Exception {
        byte[] fileData = Files.readAllBytes(inputFile.toPath());
        byte[] decryptedData = FileEncryptor_ChaCha20.decryptFileWithKey(key, fileData);
        Files.write(outputFile.toPath(), decryptedData, new OpenOption[0]);
    }

    public static byte[] decryptFileWithKey(byte[] key, byte[] fileData) throws Exception {
        byte[] nonce = new byte[NONCE_LEN];
        System.arraycopy(fileData, 0, nonce, 0, NONCE_LEN);
        byte[] counterBytes = new byte[COUNTER_LEN];
        System.arraycopy(fileData, NONCE_LEN, counterBytes, 0, COUNTER_LEN);
        byte[] encryptedData = new byte[fileData.length - NONCE_LEN - COUNTER_LEN];
        System.arraycopy(fileData, NONCE_LEN + COUNTER_LEN, encryptedData, 0, encryptedData.length);
        int counter = FileEncryptor_ChaCha20.counterToInt(counterBytes);
        return FileEncryptor_ChaCha20.processData(2, encryptedData, key, nonce, counter);
    }

    private static AlgorithmParameterSpec createChaCha20ParameterSpec(byte[] nonce, int counter) {
        try {
            Class<?> clazz = Util.classForName("javax.crypto.spec.ChaCha20ParameterSpec");
            Constructor<?> c = clazz.getConstructor(byte[].class, Integer.TYPE);
            return (AlgorithmParameterSpec)c.newInstance(nonce, counter);
        }
        catch (Exception ex) {
            throw new RuntimeException("Java Crypto algorithm ChaCha20 is not available!");
        }
    }

    private static byte[] processData(int mode, byte[] data, byte[] key, byte[] nonce, int counter) throws Exception {
        SecretKeySpec keySpec = new SecretKeySpec(key, "ChaCha20");
        AlgorithmParameterSpec param = FileEncryptor_ChaCha20.createChaCha20ParameterSpec(nonce, counter);
        Cipher cipher = Cipher.getInstance("ChaCha20");
        cipher.init(mode, (Key)keySpec, param);
        return cipher.doFinal(data);
    }

    private static byte[] counterToBytes(int counter) {
        return ByteBuffer.allocate(COUNTER_LEN).order(ENDIAN).putInt(counter).array();
    }

    private static int counterToInt(byte[] counter) {
        return ByteBuffer.wrap(counter).order(ENDIAN).getInt(0);
    }

    private static boolean checkSupported() {
        try {
            Class<?> clazz = Util.classForName("javax.crypto.spec.ChaCha20ParameterSpec");
            return clazz != null;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

