/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.time;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;

public class UnixTimestamp {
    private final long timestamp;

    public UnixTimestamp() {
        this.timestamp = 0L;
    }

    public UnixTimestamp(long secondsSinceEpoch) {
        this.timestamp = secondsSinceEpoch;
    }

    public static UnixTimestamp of(LocalDateTime ts) {
        ZoneId zoneId = ZoneId.systemDefault();
        return new UnixTimestamp(ts.atZone(zoneId).toEpochSecond());
    }

    public static UnixTimestamp of(ZonedDateTime ts) {
        return new UnixTimestamp(ts.toEpochSecond());
    }

    public static UnixTimestamp of(LocalDate ts) {
        ZoneId zoneId = ZoneId.systemDefault();
        return new UnixTimestamp(ts.atStartOfDay(zoneId).toInstant().getEpochSecond());
    }

    public static UnixTimestamp of(Date ts) {
        return new UnixTimestamp(ts.toInstant().getEpochSecond());
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return String.valueOf(this.timestamp);
    }
}

