/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.markdown.renderer.text;

import com.github.jlangch.venice.impl.util.markdown.block.TableBlock;
import com.github.jlangch.venice.impl.util.markdown.renderer.text.TextRenderer;
import java.util.ArrayList;
import java.util.List;

public class TextTableUtil {
    public static int[] maxColWidths(TableBlock block) {
        return TextTableUtil.maxColWidths(block, TextTableUtil.toHeaderCellTextLines(block), TextTableUtil.toBodyCellTextLines(block));
    }

    public static int[] maxColWidths(TableBlock block, List<String> headerCells, List<List<String>> bodyCells) {
        int ii;
        int cols = block.cols();
        int[] widths = new int[cols];
        for (ii = 0; ii < block.cols(); ++ii) {
            widths[ii] = 0;
        }
        for (ii = 0; ii < cols; ++ii) {
            widths[ii] = Math.max(widths[ii], headerCells.get(ii).length());
        }
        bodyCells.forEach(row -> {
            for (int ii = 0; ii < cols; ++ii) {
                widths[ii] = Math.max(widths[ii], ((String)row.get(ii)).length());
            }
        });
        return widths;
    }

    public static List<String> toHeaderCellTextLines(TableBlock block) {
        TextRenderer renderer = new TextRenderer().nowrap();
        ArrayList<String> cols = new ArrayList<String>();
        for (int col = 0; col < block.cols(); ++col) {
            cols.add(block.hasHeader() ? renderer.render(block.headerCell(col)) : "");
        }
        return cols;
    }

    public static List<List<String>> toBodyCellTextLines(TableBlock block) {
        TextRenderer renderer = new TextRenderer().nowrap();
        ArrayList<List<String>> cells = new ArrayList<List<String>>();
        for (int row = 0; row < block.bodyRows(); ++row) {
            ArrayList<String> cols = new ArrayList<String>();
            for (int col = 0; col < block.cols(); ++col) {
                cols.add(renderer.render(block.bodyCell(row, col)));
            }
            cells.add(cols);
        }
        return cells;
    }
}

