/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.io.zip;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import java.nio.file.attribute.FileTime;

public class ZipEntryAttr {
    private final long size;
    private final String method;
    private final long compressedSize;
    private final FileTime lastModifiedTime;
    private final Long crc;
    private final String name;
    private final boolean isDirectory;

    public ZipEntryAttr(String name, boolean isDirectory, String method, long size, long compressedSize, FileTime lastModifiedTime, Long crc) {
        this.method = method;
        this.size = size;
        this.compressedSize = compressedSize;
        this.lastModifiedTime = lastModifiedTime;
        this.crc = crc;
        this.name = name;
        this.isDirectory = isDirectory;
    }

    public long getSize() {
        return this.size;
    }

    public String getMethod() {
        return this.method;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public FileTime getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Long getCrc() {
        return this.crc;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public VncMap toVncMap() {
        return VncHashMap.of(new VncKeyword("name"), new VncString(this.name), new VncKeyword("directory"), VncBoolean.of(this.isDirectory), new VncKeyword("method"), new VncString(this.method), new VncKeyword("size"), new VncLong(this.size), new VncKeyword("compressed-size"), new VncLong(this.compressedSize), new VncKeyword("crc"), this.crc == null ? Constants.Nil : new VncLong(this.crc));
    }
}

