/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.FileException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncVal;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;

public class VncFileIterator
implements Iterator<VncVal>,
Iterable<VncVal> {
    private final IVncFunction filter;
    private final LinkedList<File> dirsLeft = new LinkedList();
    private final LinkedList<File> filesLeft = new LinkedList();

    public VncFileIterator(File root, IVncFunction filter) {
        if (root == null) {
            throw new FileException("A file iterator root dir must not be null!");
        }
        if (!root.isDirectory()) {
            throw new FileException("The file iterator root dir '" + root + "' does not exist!");
        }
        this.filter = filter;
        this.addChildren(root);
    }

    @Override
    public boolean hasNext() {
        return this.hasDirs() || this.hasFiles();
    }

    @Override
    public VncVal next() {
        while (this.hasDirs() || this.hasFiles()) {
            VncJavaObject item;
            if (this.hasFiles()) {
                File file = this.nextFile();
                item = new VncJavaObject(file);
            } else {
                File dir = this.nextDir();
                this.addChildren(dir);
                item = new VncJavaObject(dir);
            }
            if (this.filter == null) {
                return item;
            }
            if (!VncBoolean.isTrue(this.filter.applyOf(item))) continue;
            return item;
        }
        return Constants.Nil;
    }

    @Override
    public Iterator<VncVal> iterator() {
        return this;
    }

    public void stop() {
        this.dirsLeft.clear();
        this.filesLeft.clear();
    }

    private void addChildren(File parent) {
        Arrays.stream(parent.listFiles()).sorted(Comparator.comparing(File::getName)).forEach(f -> {
            if (f.isDirectory()) {
                this.dirsLeft.addLast((File)f);
            } else if (f.isFile()) {
                this.filesLeft.addLast((File)f);
            }
        });
    }

    private boolean hasDirs() {
        return !this.dirsLeft.isEmpty();
    }

    private boolean hasFiles() {
        return !this.filesLeft.isEmpty();
    }

    private File nextDir() {
        return this.hasDirs() ? this.dirsLeft.removeFirst() : null;
    }

    private File nextFile() {
        return this.hasFiles() ? this.filesLeft.removeFirst() : null;
    }
}

