/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.util.MetaUtil;

public class SourcePos {
    private final String file;
    private final int line;
    private final int column;

    public SourcePos(String file, int line, int column) {
        this.file = file == null || file.isEmpty() ? "unknown" : file;
        this.line = line <= 0 ? -1 : line;
        this.column = column <= 0 ? -1 : column;
    }

    public static SourcePos fromVal(VncVal val) {
        return SourcePos.fromMeta(val.getMeta());
    }

    public static SourcePos fromMeta(VncVal meta) {
        return new SourcePos(MetaUtil.getFile(meta), MetaUtil.getLine(meta), MetaUtil.getCol(meta));
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public int getLineOrElse(int elseLine) {
        return this.line < 0 ? elseLine : this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getColumnOrElse(int elseColumn) {
        return this.column < 0 ? elseColumn : this.column;
    }

    public String toString() {
        return String.format("%s> line: %d, col: %d", this.file, this.line, this.column);
    }
}

