/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.EmptyIterator;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.repackage.io.vavr.collection.TreeSet;

public class VncSortedSet
extends VncSet {
    public static final String TYPE = ":core/sorted-set";
    private static final long serialVersionUID = -1848883965231344442L;
    private final TreeSet<VncVal> value;

    public VncSortedSet() {
        this((org.repackage.io.vavr.collection.Set<VncVal>)null, null);
    }

    public VncSortedSet(VncVal meta) {
        this((org.repackage.io.vavr.collection.Set<VncVal>)null, meta);
    }

    public VncSortedSet(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        this(null, wrappingTypeDef, meta);
    }

    public VncSortedSet(org.repackage.io.vavr.collection.Set<VncVal> val) {
        this(val, null);
    }

    public VncSortedSet(org.repackage.io.vavr.collection.Set<VncVal> val, VncVal meta) {
        super(meta);
        this.value = val == null ? TreeSet.empty() : (val instanceof TreeSet ? (TreeSet<Object>)val : TreeSet.ofAll(val));
    }

    public VncSortedSet(org.repackage.io.vavr.collection.Set<VncVal> val, VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        super(wrappingTypeDef, meta);
        this.value = val == null ? TreeSet.empty() : (val instanceof TreeSet ? (TreeSet<Object>)val : TreeSet.ofAll(val));
    }

    public static VncSortedSet ofAll(Collection<? extends VncVal> val) {
        return new VncSortedSet(TreeSet.ofAll(val));
    }

    public static VncSortedSet ofAll(VncSequence val) {
        return new VncSortedSet(TreeSet.ofAll(val));
    }

    public static VncSortedSet of(VncVal ... mvs) {
        return new VncSortedSet(TreeSet.of(mvs));
    }

    @Override
    public VncSortedSet emptyWithMeta() {
        return new VncSortedSet(this.getMeta());
    }

    @Override
    public VncSortedSet withValues(Collection<? extends VncVal> replaceVals) {
        return new VncSortedSet(TreeSet.ofAll(replaceVals), this.getMeta());
    }

    @Override
    public VncSortedSet withValues(Collection<? extends VncVal> replaceVals, VncVal meta) {
        return new VncSortedSet(TreeSet.ofAll(replaceVals), meta);
    }

    @Override
    public VncSortedSet withMeta(VncVal meta) {
        return new VncSortedSet(this.value, meta);
    }

    @Override
    public VncSortedSet wrap(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        return new VncSortedSet(this.value, wrappingTypeDef, meta);
    }

    @Override
    public VncKeyword getType() {
        return this.isWrapped() ? new VncKeyword(this.getWrappingTypeDef().getType().getQualifiedName(), MetaUtil.typeMeta(new VncKeyword(TYPE), new VncKeyword(":core/set"), new VncKeyword(":core/collection"), new VncKeyword(":core/val"))) : new VncKeyword(TYPE, MetaUtil.typeMeta(new VncKeyword(":core/set"), new VncKeyword(":core/collection"), new VncKeyword(":core/val")));
    }

    @Override
    public VncSortedSet add(VncVal val) {
        return new VncSortedSet(this.value.add((Object)val), this.getMeta());
    }

    @Override
    public VncSortedSet addAll(VncSet val) {
        return new VncSortedSet(this.value.addAll((Iterable)val), this.getMeta());
    }

    @Override
    public VncSortedSet addAll(VncSequence val) {
        return new VncSortedSet(this.value.addAll((Iterable)val), this.getMeta());
    }

    @Override
    public VncSortedSet remove(VncVal val) {
        return new VncSortedSet(this.value.remove((Object)val), this.getMeta());
    }

    @Override
    public VncSortedSet removeAll(VncSet val) {
        return new VncSortedSet(this.value.removeAll((Iterable)val), this.getMeta());
    }

    @Override
    public VncSortedSet removeAll(VncSequence val) {
        return new VncSortedSet(this.value.removeAll((Iterable)val), this.getMeta());
    }

    @Override
    public boolean contains(VncVal val) {
        return this.value.contains(val);
    }

    @Override
    public Iterator<VncVal> iterator() {
        return this.isEmpty() ? EmptyIterator.empty() : this.value.iterator();
    }

    @Override
    public Stream<VncVal> stream() {
        return this.value.toJavaStream();
    }

    @Override
    public Set<VncVal> getJavaSet() {
        return Collections.unmodifiableSet(this.value.toJavaSet());
    }

    @Override
    public List<VncVal> getJavaList() {
        return Collections.unmodifiableList(this.value.toJavaList());
    }

    @Override
    public VncList toVncList() {
        return new VncList(this.value.toVector(), this.getMeta());
    }

    @Override
    public VncVector toVncVector() {
        return new VncVector(this.value.toVector(), this.getMeta());
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.SORTEDSET;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncSortedSet(o)) {
            int c = Integer.compare(this.size(), ((VncSortedSet)o).size());
            if (c != 0) {
                return c;
            }
            return this.equals(o) ? 0 : -1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncSortedSet other = (VncSortedSet)obj;
        return this.value.equals(other.value);
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean print_machine_readably) {
        return "#{" + Printer.join(this.toVncList(), " ", print_machine_readably) + "}";
    }
}

