/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.threadpool;

import com.github.jlangch.venice.impl.threadpool.ManagedExecutor;
import com.github.jlangch.venice.impl.threadpool.ThreadPoolUtil;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ManagedCachedThreadPoolExecutor
extends ManagedExecutor {
    private final String threadPoolName;
    private volatile int maxThreadPoolSize;
    private volatile int corePoolSize;
    private volatile int keepAliveTimeSeconds;

    public ManagedCachedThreadPoolExecutor(String threadPoolName, int maxPoolSize) {
        this.threadPoolName = threadPoolName;
        this.maxThreadPoolSize = Math.max(1, maxPoolSize);
        this.corePoolSize = 0;
        this.keepAliveTimeSeconds = 10;
    }

    @Override
    public ThreadPoolExecutor getExecutor() {
        return (ThreadPoolExecutor)super.getExecutor();
    }

    @Override
    protected ExecutorService createExecutorService() {
        ThreadPoolExecutor es = (ThreadPoolExecutor)Executors.newCachedThreadPool(ThreadPoolUtil.createCountedThreadFactory(this.threadPoolName, true));
        es.setCorePoolSize(this.corePoolSize);
        es.setKeepAliveTime(this.keepAliveTimeSeconds, TimeUnit.SECONDS);
        es.setMaximumPoolSize(this.maxThreadPoolSize);
        return es;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumThreadPoolSize(int poolSize) {
        ManagedCachedThreadPoolExecutor managedCachedThreadPoolExecutor = this;
        synchronized (managedCachedThreadPoolExecutor) {
            this.maxThreadPoolSize = Math.max(1, poolSize);
            if (super.exists()) {
                this.getExecutor().setMaximumPoolSize(this.maxThreadPoolSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCorePoolSize(int poolSize) {
        ManagedCachedThreadPoolExecutor managedCachedThreadPoolExecutor = this;
        synchronized (managedCachedThreadPoolExecutor) {
            this.corePoolSize = Math.max(0, poolSize);
            if (super.exists()) {
                this.getExecutor().setCorePoolSize(this.corePoolSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeepAliveTime(int seconds) {
        ManagedCachedThreadPoolExecutor managedCachedThreadPoolExecutor = this;
        synchronized (managedCachedThreadPoolExecutor) {
            this.keepAliveTimeSeconds = Math.max(0, seconds);
            if (super.exists()) {
                this.getExecutor().setKeepAliveTime(this.keepAliveTimeSeconds, TimeUnit.SECONDS);
            }
        }
    }

    public int getCoreThreadPoolSize() {
        return this.getExecutor().getCorePoolSize();
    }

    public int getMaximumThreadPoolSize() {
        return this.getExecutor().getMaximumPoolSize();
    }

    public int getLargestThreadPoolSize() {
        return this.getExecutor().getLargestPoolSize();
    }

    public int getActiveThreadCount() {
        return this.getExecutor().getActiveCount();
    }

    public int getThreadPoolSize() {
        return this.getExecutor().getPoolSize();
    }

    public long getScheduledTaskCount() {
        return this.getExecutor().getTaskCount();
    }

    public long getCompletedTaskCount() {
        return this.getExecutor().getCompletedTaskCount();
    }

    public VncMap info() {
        return VncOrderedMap.of(new VncKeyword("core-pool-size"), new VncLong(this.getCoreThreadPoolSize()), new VncKeyword("maximum-pool-size"), new VncLong(this.getMaximumThreadPoolSize()), new VncKeyword("current-pool-size"), new VncLong(this.getThreadPoolSize()), new VncKeyword("largest-pool-size"), new VncLong(this.getLargestThreadPoolSize()), new VncKeyword("active-thread-count"), new VncLong(this.getActiveThreadCount()), new VncKeyword("scheduled-task-count"), new VncLong(this.getScheduledTaskCount()), new VncKeyword("completed-task-count"), new VncLong(this.getCompletedTaskCount()));
    }
}

