/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.specialforms.util;

import com.github.jlangch.venice.impl.IFormEvaluator;
import com.github.jlangch.venice.impl.InterruptChecker;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJust;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import java.util.ArrayList;

public class Benchmark {
    private static VncFunction dummyFn = new VncFunction("dummy___"){
        private static final long serialVersionUID = -1L;

        @Override
        public VncVal apply(VncList args) {
            return zero;
        }
    };
    private static final VncLong zero = new VncLong(0L);
    private static final VncKeyword benchVal = new VncKeyword("*benchmark-val*");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VncList benchmark(long warmUpIterations, long gcRuns, long iterations, VncVal expr, VncFunction statusFn, Env env, IFormEvaluator evaluator) {
        try {
            VncList iterationSamples;
            statusFn.applyOf(new VncString("Warmup..."));
            VncList warmupSamples = Benchmark.samples(warmUpIterations, expr, env, evaluator);
            Benchmark.storeToHole(warmupSamples);
            long batchSize = 1L;
            statusFn.applyOf(new VncString("GC..."));
            Benchmark.runGCs(gcRuns);
            Benchmark.sleep(1000L);
            long overheadPerSample = Benchmark.measureSampleOverhead();
            Benchmark.runGCs(1L);
            statusFn.applyOf(new VncString("Sampling..."));
            VncList vncList = iterationSamples = Benchmark.samples(iterations, batchSize, overheadPerSample, expr, env, evaluator);
            return vncList;
        }
        finally {
            ThreadContext.removeValue(benchVal);
        }
    }

    private static VncList samples(long iterations, VncVal expr, Env env, IFormEvaluator evaluator) {
        return Benchmark.samples(iterations, 1L, 0L, expr, env, evaluator);
    }

    private static VncList samples(long iterations, long batchSize, long overheadPerSample, VncVal expr, Env env, IFormEvaluator evaluator) {
        if (batchSize == 1L) {
            ArrayList<VncLong> elapsed = new ArrayList<VncLong>();
            int ii = 0;
            while ((long)ii < iterations) {
                long elapsed_ = Benchmark.sample(1L, expr, env, evaluator);
                elapsed.add(new VncLong(Math.max(0L, elapsed_ - overheadPerSample)));
                InterruptChecker.checkInterrupted(Thread.currentThread(), "dobench");
                ++ii;
            }
            return VncList.ofList(elapsed);
        }
        ArrayList<VncLong> elapsed = new ArrayList<VncLong>();
        long batchedIterations = iterations / batchSize + 1L;
        int ii = 0;
        while ((long)ii < batchedIterations) {
            long elapsed_ = Benchmark.sample(batchSize, expr, env, evaluator);
            long e = Math.max(1L, (elapsed_ - overheadPerSample) / batchSize);
            int jj = 0;
            while ((long)jj < batchSize) {
                elapsed.add(new VncLong(e));
                ++jj;
            }
            InterruptChecker.checkInterrupted(Thread.currentThread(), "dobench");
            ++ii;
        }
        return VncList.ofList(elapsed);
    }

    private static long sample(long n, VncVal expr, Env env, IFormEvaluator evaluator) {
        long start = System.nanoTime();
        VncVal result = Constants.Nil;
        if (n == 1L) {
            result = evaluator.evaluate(expr, env, false);
        } else {
            int ii = 0;
            while ((long)ii < n) {
                result = evaluator.evaluate(expr, env, false);
                ++ii;
            }
        }
        long elapsed = System.nanoTime() - start;
        Benchmark.storeToHole(new VncJust(result));
        return elapsed;
    }

    private static long measureSampleOverhead() {
        long elapsedTotal = 0L;
        for (int ii = 0; ii < 10000; ++ii) {
            long start_ = System.nanoTime();
            VncLong result = (VncLong)dummyFn.apply(VncList.empty());
            long elapsed = System.nanoTime() - start_;
            Benchmark.storeToHole(new VncLong(elapsed - start_ + result.toJavaLong()));
            elapsedTotal += elapsed;
        }
        return elapsedTotal / 10000L;
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void runGCs(long count) {
        int ii = 0;
        while ((long)ii < count) {
            System.gc();
            ++ii;
        }
    }

    private static void storeToHole(VncVal v) {
        ThreadContext.setValue(benchVal, v);
    }
}

