/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.specialforms;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Destructuring;
import com.github.jlangch.venice.impl.IFormEvaluator;
import com.github.jlangch.venice.impl.ISequenceValuesEvaluator;
import com.github.jlangch.venice.impl.InterruptChecker;
import com.github.jlangch.venice.impl.debug.agent.DebugAgent;
import com.github.jlangch.venice.impl.debug.breakpoint.BreakpointFnRef;
import com.github.jlangch.venice.impl.debug.breakpoint.FunctionScope;
import com.github.jlangch.venice.impl.docgen.runtime.DocForm;
import com.github.jlangch.venice.impl.env.DynamicVar;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.EnvUtils;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.modules.Modules;
import com.github.jlangch.venice.impl.namespaces.Namespace;
import com.github.jlangch.venice.impl.namespaces.Namespaces;
import com.github.jlangch.venice.impl.specialforms.util.Benchmark;
import com.github.jlangch.venice.impl.specialforms.util.SpecialFormsContext;
import com.github.jlangch.venice.impl.specialforms.util.SpecialFormsUtil;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJust;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncSpecialForm;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.Inspector;
import com.github.jlangch.venice.impl.util.MeterRegistry;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.impl.util.Tuple2;
import com.github.jlangch.venice.impl.util.callstack.CallFrame;
import com.github.jlangch.venice.impl.util.callstack.CallStack;
import com.github.jlangch.venice.impl.util.callstack.WithCallStack;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SpecialForms_OtherFunctions {
    public static VncSpecialForm doc = new VncSpecialForm("doc", (VncVal)VncSpecialForm.meta().arglists("(doc )", "(doc x)").doc("Prints documentation for a var or special form given `x` as its name. Prints the definition of custom types. \n\nDisplays the source of a module if `x` is a module: `(doc :ansi)`\n\nIf the var could not be found, searches for a similiar var with the **Levenshtein distance** 1.\u00b6E.g: \n\n```                     \n> (doc dac)             \nSymbol 'dac' not found! \n                        \nDid you mean?           \n   dag/dag              \n   dec                  \n```").examples(";; documentation of function '+'\n(doc +)", ";; documentation of special form 'def'\n(doc def)", ";; source code of module ':ascii-table'\n(doc :ascii-table)", ";; definition/structure of a complex type\n(do \n  (deftype :complex [real :long, imaginary :long]) \n  (doc :complex))").seeAlso("ns-list", "modules", "finder").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            ArityExceptions.assertArity("doc", ArityExceptions.FnType.SpecialForm, args, 0, 1);
            VncString doc = DocForm.doc(args.first(), env);
            ctx.getEvaluator().evaluate(VncList.of(new VncSymbol("println"), doc), env, false);
            return Constants.Nil;
        }
    };
    public static VncSpecialForm finder = new VncSpecialForm("finder", (VncVal)VncSpecialForm.meta().arglists("(finder & args)").doc("Finds symbols that match one more glob patterns or regular expressions.\n\nFilters the symbol names by 0 to n glob patterns or regular expressions.\n\nGlob patterns and regular expressions are ANDed, flags are ORed.\n\nFlags:\n\n|:function    |filter functions|\n|:macro       |filter macros|\n|:special-form|filter special forms|\n|:protocol    |filter protocols|\n|:value       |filter values|\n|:machine     |return the result as Venice data otherwise print it in table format |").examples("(finder \"io/zip*\")", "(finder \"*delete-file*\")", "(finder \"io/zip*\" :machine)", "(finder #\"io/zip.*\")", "(finder #\".*delete-file*.\")", "(finder #\"io/zip.*\" :machine)", "(finder zip)").seeAlso("doc", "ns-list", "modules").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            ArityExceptions.assertMinArity("finder", ArityExceptions.FnType.SpecialForm, args, 0);
            Set flags = args.getJavaList().stream().filter(a -> Types.isVncKeyword(a)).map(a -> ":" + ((VncKeyword)a).getSimpleName()).collect(Collectors.toSet());
            List filters = args.getJavaList().stream().filter(a -> !Types.isVncKeyword(a)).collect(Collectors.toList());
            boolean machine = flags.contains(":machine");
            boolean functionType = flags.contains(":function");
            boolean macroType = flags.contains(":macro");
            boolean specialFormType = flags.contains(":special-form");
            boolean protocolType = flags.contains(":protocol");
            boolean valueType = flags.contains(":value");
            boolean allTypes = !functionType && !macroType && !specialFormType && !protocolType && !valueType;
            List<Tuple2<VncSymbol, VncKeyword>> items = EnvUtils.globalVars(env, (String)null);
            for (VncVal filter : filters) {
                Pattern p;
                String f;
                if (Types.isVncString(filter)) {
                    f = StringUtil.trimToNull(((VncString)filter).getValue());
                    if (f != null) {
                        f = f.contains("*") ? f.replaceAll("[*]", ".*") : ".*" + f + ".*";
                    }
                    p = Pattern.compile(f);
                } else if (Types.isVncSymbol(filter)) {
                    f = StringUtil.trimToNull(((VncSymbol)filter).getName());
                    if (f != null) {
                        f = f.contains("*") ? f.replaceAll("[*]", "[*]") : f;
                    }
                    p = Pattern.compile(f);
                } else if (Types.isVncJavaObject(args.first(), Pattern.class)) {
                    p = Coerce.toVncJavaObject(args.first(), Pattern.class);
                } else {
                    throw new VncException("finder expects either a glob pattern (string) or a regex pattern as argument! Got a filter value of type '" + Types.getType(filter) + "'");
                }
                Predicate<String> pred = p.asPredicate();
                items = items.stream().filter(v -> pred == null ? true : pred.test(((VncSymbol)v._1).getName())).collect(Collectors.toList());
            }
            items = items.stream().filter(v -> allTypes || functionType && SpecialForms_OtherFunctions.isFunctionType((VncKeyword)v._2) || macroType && SpecialForms_OtherFunctions.isMacroType((VncKeyword)v._2) || specialFormType && SpecialForms_OtherFunctions.isSpecialFormType((VncKeyword)v._2) || protocolType && SpecialForms_OtherFunctions.isProtocolType((VncKeyword)v._2) || valueType && SpecialForms_OtherFunctions.isValueType((VncKeyword)v._2)).collect(Collectors.toList());
            if (machine) {
                return VncList.ofAll(items.stream().map(v -> VncVector.of((VncVal)v._1, (VncVal)v._2)), (VncVal)Constants.Nil);
            }
            VncVal out = env.get(new VncSymbol("*out*"));
            PrintStream ps = Types.isVncJavaObject(out, PrintStream.class) ? Coerce.toVncJavaObject(out, PrintStream.class) : System.out;
            int maxLen = items.stream().map(v -> (VncSymbol)v._1).mapToInt(v -> v.getValue().length()).max().orElse(10);
            items.forEach(v -> ps.format("%s  %s%n", StringUtil.padRight(((VncSymbol)v._1).toString(), maxLen), ((VncKeyword)v._2).toString()));
            return Constants.Nil;
        }
    };
    public static VncSpecialForm macroexpand_on_loadQ = new VncSpecialForm("macroexpand-on-load?", (VncVal)VncSpecialForm.meta().arglists("(macroexpand-on-load?)").doc("Returns true if `macroexpand-on-load` feature is enabled else false.\n\nThe activation of `macroexpand-on-load` (upfront macro expansion) results in 3x to 15x better performance. Upfront macro expansion can be activated through the `!macroexpand` command in the REPL.").examples("(macroexpand-on-load?)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            ArityExceptions.assertMinArity("macroexpand-on-read?", ArityExceptions.FnType.SpecialForm, args, 0);
            return VncBoolean.of(ctx.getInterpreter().isMacroExpandOnLoad());
        }
    };
    public static VncSpecialForm eval = new VncSpecialForm("eval", (VncVal)VncSpecialForm.meta().arglists("(eval form)").doc("Evaluates the form data structure (not text!) and returns the result.").examples("(eval '(let [a 10] (+ 3 4 a)))", "(eval (list + 1 2 3))", "(eval (read-string \"(+ 1 2)\"))", "(let [s \"(+ 2 x)\" x 10]  \n  (eval (read-string s)))  ").seeAlso("read-string").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            SpecialFormsUtil.specialFormCallValidation(ctx, "eval");
            ArityExceptions.assertMinArity("eval", ArityExceptions.FnType.SpecialForm, args, 0);
            Namespace ns = Namespaces.getCurrentNamespace();
            try {
                IFormEvaluator formEvaluator = ctx.getEvaluator();
                ISequenceValuesEvaluator seqEvaluator = ctx.getSequenceValuesEvaluator();
                VncVal vncVal = formEvaluator.evaluate(Coerce.toVncSequence(seqEvaluator.evaluate_sequence_values(args, env)).last(), env, false);
                return vncVal;
            }
            finally {
                Namespaces.setCurrentNamespace(ns);
            }
        }
    };
    public static VncSpecialForm binding = new VncSpecialForm("binding", (VncVal)VncSpecialForm.meta().arglists("(binding [bindings*] exprs*)").doc("Evaluates the expressions and binds the values to dynamic (thread-local) symbols").examples("(do                      \n   (binding [x 100]      \n      (println x)        \n      (binding [x 200]   \n         (println x))    \n      (println x)))        ", ";; binding-introduced bindings are thread-locally mutable: \n(binding [x 1]                                             \n  (set! x 2)                                               \n  x)                                                         ", ";; binding can use qualified names : \n(binding [user/x 1]                  \n  user/x)                              ").seeAlso("def-dynamic", "let").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            Env bind_env = new Env(env);
            VncSequence bindings = Coerce.toVncSequence(args.first());
            VncList expressions = args.rest();
            if (bindings.size() % 2 != 0) {
                WithCallStack cs = new WithCallStack(new CallFrame("bindings", args, specialFormMeta));
                Throwable throwable = null;
                try {
                    try {
                        throw new VncException("bindings requires an even number of forms in the binding vector!");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (cs != null) {
                        if (throwable != null) {
                            try {
                                cs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            cs.close();
                        }
                    }
                    throw throwable3;
                }
            }
            IFormEvaluator formEvaluator = ctx.getEvaluator();
            ISequenceValuesEvaluator seqEvaluator = ctx.getSequenceValuesEvaluator();
            ArrayList<Var> bindingVars = new ArrayList<Var>();
            try {
                for (int i = 0; i < bindings.size(); i += 2) {
                    VncVal sym = bindings.nth(i);
                    VncVal val = formEvaluator.evaluate(bindings.nth(i + 1), bind_env, false);
                    if (sym instanceof VncSymbol) {
                        bind_env.pushGlobalDynamic((VncSymbol)sym, val);
                        bindingVars.add(new Var((VncSymbol)sym, val, Var.Scope.Local));
                        continue;
                    }
                    List<Var> vars = Destructuring.destructure(sym, val);
                    vars.forEach(v -> bind_env.pushGlobalDynamic(v.getName(), v.getVal()));
                    bindingVars.addAll(vars);
                }
                ThreadContext threadCtx = ThreadContext.get();
                DebugAgent debugAgent = threadCtx.getDebugAgent_();
                if (debugAgent != null && debugAgent.hasBreakpointFor(BreakpointFnRef.BINDINGS)) {
                    CallStack callStack = threadCtx.getCallStack_();
                    debugAgent.onBreakSpecialForm("bindings", FunctionScope.FunctionEntry, bindingVars, specialFormMeta, bind_env, callStack);
                }
                seqEvaluator.evaluate_sequence_values(expressions.butlast(), bind_env);
                VncVal vncVal = formEvaluator.evaluate(expressions.last(), bind_env, false);
                return vncVal;
            }
            finally {
                bindingVars.forEach(v -> bind_env.popGlobalDynamic(v.getName()));
            }
        }
    };
    public static VncSpecialForm locking = new VncSpecialForm("locking", (VncVal)VncSpecialForm.meta().arglists("(locking x & exprs)").doc("Executes 'exprs' in an implicit do, while holding the monitor of 'x'. Will release the monitor of 'x' in all circumstances. Locking operates like the synchronized keyword in Java.").examples("(do                        \n   (def x 1)               \n   (locking x              \n      (println 100)        \n      (println 200)))", ";; Locks are reentrant     \n(do                        \n   (def x 1)               \n   (locking x              \n      (locking x           \n         (println \"in\")) \n      (println \"out\"))) ", "(do                                             \n  (defn log [msg] (locking log (println msg)))  \n  (log \"message\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            VncVal mutex;
            ArityExceptions.assertMinArity("locking", ArityExceptions.FnType.SpecialForm, args, 2);
            VncVal vncVal = mutex = ctx.getEvaluator().evaluate(args.first(), env, false);
            synchronized (vncVal) {
                return SpecialFormsUtil.evaluateBody(args.rest(), ctx, env, true);
            }
        }
    };
    public static VncSpecialForm print_highlight = new VncSpecialForm("print-highlight", (VncVal)VncSpecialForm.meta().arglists("(print-highlight form)").doc("Prints the form highlighted to *out*").examples("(print-highlight \"(+ 1 2)\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            ArityExceptions.assertArity("print-highlight", ArityExceptions.FnType.SpecialForm, args, 1);
            VncString form = DocForm.highlight(Coerce.toVncString(args.first()), env);
            ctx.getEvaluator().evaluate(VncList.of(new VncSymbol("println"), form), env, false);
            return Constants.Nil;
        }
    };
    public static VncSpecialForm modules = new VncSpecialForm("modules", (VncVal)VncSpecialForm.meta().arglists("(modules)").doc("Lists the available Venice modules").seeAlso("load-module", "doc", "ns-list").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            return VncList.ofList(Modules.VALID_MODULES.stream().filter(s -> !s.equals("core")).sorted().map(s -> new VncKeyword((String)s)).collect(Collectors.toList()));
        }
    };
    public static VncSpecialForm inspect = new VncSpecialForm("inspect", (VncVal)VncSpecialForm.meta().arglists("(inspect val)").doc("Inspect a value").examples("(inspect '+)", "(inspect (symbol \"+\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            SpecialFormsUtil.specialFormCallValidation(ctx, "inspect");
            ArityExceptions.assertArity("inspect", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol sym = Coerce.toVncSymbol(ctx.getEvaluator().evaluate(args.first(), env, false));
            return Inspector.inspect(env.get(sym));
        }
    };
    public static VncSpecialForm resolve = new VncSpecialForm("resolve", (VncVal)VncSpecialForm.meta().arglists("(resolve symbol)").doc("Resolves a symbol.").examples("(resolve '+)", "(resolve 'y)", "(resolve (symbol \"+\"))", "((resolve (symbol \"core\" \"+\")) 1 2)", "((-> \"first\" symbol resolve) [1 2 3])").seeAlso("symbol").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            SpecialFormsUtil.specialFormCallValidation(ctx, "resolve");
            ArityExceptions.assertArity("resolve", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol sym = Coerce.toVncSymbol(ctx.getEvaluator().evaluate(args.first(), env, false));
            return env.getOrNil(sym);
        }
    };
    public static VncSpecialForm boundQ = new VncSpecialForm("bound?", (VncVal)VncSpecialForm.meta().arglists("(bound? s)").doc("Returns true if the symbol is bound to a value else false").examples("(bound? 'test)", "(let [test 100]   \n  (bound? 'test))   ", "(do               \n  (def a 100)     \n  (bound? 'a))      ").seeAlso("let", "def", "defonce").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            ArityExceptions.assertArity("bound?", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol sym = Coerce.toVncSymbol(ctx.getEvaluator().evaluate(args.first(), env, false));
            return VncBoolean.of(env.isBound(sym));
        }
    };
    public static VncSpecialForm setBANG = new VncSpecialForm("set!", (VncVal)VncSpecialForm.meta().arglists("(set! var-symbol expr)").doc("Sets a global or thread-local variable to the value of the expression.").examples("(do                             \n  (def x 10)                    \n  (set! x 20)                   \n  x)                              ", "(do                             \n   (def-dynamic x 100)          \n   (set! x 200)                 \n   x)                             ", "(do                             \n   (def-dynamic x 100)          \n   (with-out-str                \n      (print x)                 \n      (binding [x 200]          \n        (print (str \"-\" x))   \n        (set! x (inc x))        \n        (print (str \"-\" x)))  \n      (print (str \"-\" x))))     ").seeAlso("def", "def-dynamic").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            SpecialFormsUtil.specialFormCallValidation(ctx, "set!");
            ArityExceptions.assertArity("set!", ArityExceptions.FnType.SpecialForm, args, 2);
            VncSymbol sym = Types.isVncSymbol(args.first()) ? (VncSymbol)args.first() : Coerce.toVncSymbol(ctx.getEvaluator().evaluate(args.first(), env, false));
            Var globVar = env.getGlobalVarOrNull(sym);
            if (globVar != null) {
                VncVal expr = args.second();
                VncVal val = ctx.getEvaluator().evaluate(expr, env, false);
                if (globVar instanceof DynamicVar) {
                    env.popGlobalDynamic(globVar.getName());
                    env.pushGlobalDynamic(globVar.getName(), val);
                } else {
                    env.setGlobal(new Var(globVar.getName(), val, globVar.isOverwritable(), Var.Scope.Global));
                }
                return val;
            }
            throw new VncException(String.format("The global or thread-local var '%s' does not exist!", sym.getName()));
        }
    };
    public static VncSpecialForm quote = new VncSpecialForm("quote", (VncVal)VncSpecialForm.meta().arglists("(quote form)").doc("There are two equivalent ways to quote a form either with `quote` or with `'`. They prevent the quoted form from being evaluated.\n\nRegular quotes work recursively with any kind of forms and types: strings, maps, lists, vectors...").examples("(quote (1 2 3))", "(quote (+ 1 2))", "'(1 2 3)", "'(+ 1 2)", "'(a (b (c d (+ 1 2))))").seeAlso("quasiquote").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            if (args.size() != 1) {
                CallFrame callframe = new CallFrame("quote", args, specialFormMeta);
                try (WithCallStack cs = new WithCallStack(callframe);){
                    ArityExceptions.assertArity("quote", ArityExceptions.FnType.SpecialForm, args, 1);
                }
            }
            return args.first();
        }

        @Override
        public boolean addCallFrame() {
            return false;
        }
    };
    public static VncSpecialForm quasiquote = new VncSpecialForm("quasiquote", (VncVal)VncSpecialForm.meta().arglists("(quasiquote form)").doc("Quasi quotes also called syntax quotes (a backquote) suppress evaluation of the form that follows it and all the nested forms.\n\nunquote:\u00b6\nIt is possible to unquote part of the form that is quoted with `~`. Unquoting allows you to evaluate parts of the syntax quoted expression.\n\nunquote-splicing:\u00b6\nUnquote evaluates to a collection of values and inserts the collection into the quoted form. But sometimes you want to unquote a list and insert its elements (not the list) inside the quoted form. This is where `~@` (unquote-splicing) comes to rescue.").examples("(quasiquote (16 17 (inc 17)))", "`(16 17 (inc 17))", "`(16 17 ~(inc 17))", "`(16 17 ~(map inc [16 17]))", "`(16 17 ~@(map inc [16 17]))", "`(1 2 ~@#{1 2 3})", "`(1 2 ~@{:a 1 :b 2 :c 3})").seeAlso("quote").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            if (args.size() != 1) {
                CallFrame callframe = new CallFrame("quasiquote", args, specialFormMeta);
                try (WithCallStack cs = new WithCallStack(callframe);){
                    ArityExceptions.assertArity("quasiquote", ArityExceptions.FnType.SpecialForm, args, 1);
                }
            }
            return SpecialForms_OtherFunctions.quasiquote(args.first());
        }

        @Override
        public boolean addCallFrame() {
            return false;
        }
    };
    public static VncSpecialForm dobench = new VncSpecialForm("dobench", (VncVal)VncSpecialForm.meta().arglists("(dobench iterations expr)", "(dobench warm-up-iterations gc-runs iterations expr)").doc("Runs the expr iterations times in the most effective way and returns a list of elapsed nanoseconds for each invocation. It's main purpose is supporting benchmark tests.\n\n*Note:* For best performance enable `macroexpand-on-load`!").examples("(dobench 100 (+ 1 1))", "(dobench 1000 2 100 (+ 1 1))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            SpecialFormsUtil.specialFormCallValidation(ctx, "dobench");
            ArityExceptions.assertArity("dobench", ArityExceptions.FnType.SpecialForm, args, 2, 4, 5);
            long warmUpIterations = 0L;
            long gcRuns = 0L;
            long iterations = 0L;
            VncVal expr = Constants.Nil;
            VncFunction statusFn = nilStatusFn;
            if (args.size() == 2) {
                iterations = Coerce.toVncLong(args.first()).getValue();
                expr = args.second();
            } else if (args.size() == 4) {
                warmUpIterations = Coerce.toVncLong(args.first()).getValue();
                gcRuns = Coerce.toVncLong(args.second()).getValue();
                iterations = Coerce.toVncLong(args.third()).getValue();
                expr = args.fourth();
            } else {
                warmUpIterations = Coerce.toVncLong(args.first()).getValue();
                gcRuns = Coerce.toVncLong(args.second()).getValue();
                iterations = Coerce.toVncLong(args.third()).getValue();
                expr = args.fourth();
                statusFn = Coerce.toVncFunction(args.nth(4));
                statusFn.sandboxFunctionCallValidation();
            }
            return Benchmark.benchmark(warmUpIterations, gcRuns, iterations, expr, statusFn, env, ctx.getEvaluator());
        }
    };
    public static VncSpecialForm dorun = new VncSpecialForm("dorun", (VncVal)VncSpecialForm.meta().arglists("(dorun count expr)").doc("Runs the expr count times in the most effective way. It's main purpose is supporting benchmark tests. Returns the expression result of the last invocation.\n\n*Note:*\u00b6For best performance enable `macroexpand-on-load`! The expression is evaluated for every run. Alternatively a zero or one arg function referenced by a symbol can be passed:\n\n```                      \n(let [f (fn [] (+ 1 1))] \n  (dorun 10 f))          \n```                      \n\nWhen passing a one arg function `dorun` passes the incrementing counter value (0..N) to the function:\n\n```                       \n(let [f (fn [x] (+ x 1))] \n  (dorun 10 f))           \n```                         ").examples("(dorun 10 (+ 1 1))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            VncVal v;
            IFormEvaluator evaluator = ctx.getEvaluator();
            VncVal vCount = evaluator.evaluate(args.first(), env, false);
            long count = Coerce.toVncLong(vCount).getValue();
            if (count <= 0L) {
                return Constants.Nil;
            }
            VncVal expr = args.second();
            if (Types.isVncSymbol(expr) && Types.isVncFunction(v = env.getOrNil((VncSymbol)expr))) {
                VncFunction fn = (VncFunction)v;
                fn.sandboxFunctionCallValidation();
                if (fn.getFixedArgsCount() == 1) {
                    int ii = 0;
                    while ((long)ii < count - 1L) {
                        fn.apply(VncList.of(new VncLong(ii)));
                        ++ii;
                    }
                    return fn.apply(VncList.of(new VncLong(count - 1L)));
                }
                VncList fnArgs = VncList.empty();
                int ii = 0;
                while ((long)ii < count - 1L) {
                    fn.apply(fnArgs);
                    ++ii;
                }
                return fn.apply(fnArgs);
            }
            try {
                VncVal first = evaluator.evaluate(expr, env, false);
                int ii = 1;
                while ((long)ii < count) {
                    VncVal result = evaluator.evaluate(expr, env, false);
                    InterruptChecker.checkInterrupted(Thread.currentThread(), "dorun");
                    ThreadContext.setValue(new VncKeyword("*benchmark-val*"), new VncJust(result));
                    ++ii;
                }
                VncVal vncVal = first;
                return vncVal;
            }
            finally {
                ThreadContext.removeValue(new VncKeyword("*benchmark-val*"));
            }
        }
    };
    public static VncSpecialForm prof = new VncSpecialForm("prof", (VncVal)VncSpecialForm.meta().arglists("(prof opts)").doc("Controls the code profiling. See the companion functions/macros 'dorun' and 'perf'. The perf macro is built on prof and dorun and provides all for simple Venice profiling.\n\nThe profiler reports a function's elapsed time as \"time with children\"! \n\nProfiling recursive functions:\u00b6\nBecause the profiler reports \"time with children\" and accumulates the elapsed time across all recursive calls the resulting time for a particular recursive function is higher than the effective time.").examples("(do  \n  (prof :on)   ; turn profiler on  \n  (prof :off)   ; turn profiler off  \n  (prof :status)   ; returns the profiler on/off staus  \n  (prof :clear)   ; clear profiler data captured so far  \n  (prof :data)   ; returns the profiler data as map  \n  (prof :data-formatted)   ; returns the profiler data as formatted text  \n  (prof :data-formatted \"Metrics\")   ; returns the profiler data as formatted text with a title  \n  nil)  ").seeAlso("perf", "time").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            SpecialFormsUtil.specialFormCallValidation(ctx, "prof");
            ArityExceptions.assertArity("prof", ArityExceptions.FnType.SpecialForm, args, 1, 2, 3);
            MeterRegistry meterRegistry = ctx.getMeterRegistry();
            if (Types.isVncKeyword(args.first())) {
                VncKeyword cmd = (VncKeyword)args.first();
                switch (cmd.getValue()) {
                    case "on": 
                    case "enable": {
                        meterRegistry.enable();
                        return new VncKeyword("on");
                    }
                    case "off": 
                    case "disable": {
                        meterRegistry.disable();
                        return new VncKeyword("off");
                    }
                    case "status": {
                        return new VncKeyword(meterRegistry.isEnabled() ? "on" : "off");
                    }
                    case "clear": {
                        meterRegistry.reset();
                        return new VncKeyword(meterRegistry.isEnabled() ? "on" : "off");
                    }
                    case "clear-all-but": {
                        meterRegistry.resetAllBut(Coerce.toVncSequence(args.second()));
                        return new VncKeyword(meterRegistry.isEnabled() ? "on" : "off");
                    }
                    case "data": {
                        return meterRegistry.getVncTimerData();
                    }
                    case "data-formatted": {
                        VncVal opt1 = args.second();
                        VncVal opt2 = args.third();
                        String title = "Metrics";
                        if (Types.isVncString(opt1) && !Types.isVncKeyword(opt1)) {
                            title = ((VncString)opt1).getValue();
                        }
                        if (Types.isVncString(opt2) && !Types.isVncKeyword(opt2)) {
                            title = ((VncString)opt2).getValue();
                        }
                        boolean anonFn = false;
                        if (Types.isVncKeyword(opt1)) {
                            boolean bl = anonFn = anonFn || ((VncKeyword)opt1).hasValue("anon-fn");
                        }
                        if (Types.isVncKeyword(opt2)) {
                            anonFn = anonFn || ((VncKeyword)opt2).hasValue("anon-fn");
                        }
                        return new VncString(meterRegistry.getTimerDataFormatted(title, anonFn));
                    }
                }
            }
            throw new VncException("Function 'prof' expects a single keyword argument: :on, :off, :status, :clear, :clear-all-but, :data, or :data-formatted");
        }
    };
    private static VncFunction nilStatusFn = new VncFunction("nil-status-fn"){
        private static final long serialVersionUID = -1L;

        @Override
        public VncVal apply(VncList args) {
            return Constants.Nil;
        }
    };
    public static final Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(binding).add(boundQ).add(dobench).add(doc).add(finder).add(dorun).add(macroexpand_on_loadQ).add(eval).add(inspect).add(locking).add(modules).add(print_highlight).add(prof).add(quote).add(quasiquote).add(resolve).add(setBANG).toMap();

    private static VncVal quasiquote(VncVal ast) {
        if (SpecialForms_OtherFunctions.isNonEmptySequence(ast)) {
            VncVal a00;
            VncVal a0 = Coerce.toVncSequence(ast).first();
            if (Types.isVncSymbol(a0) && ((VncSymbol)a0).getName().equals("unquote")) {
                return ((VncSequence)ast).second();
            }
            if (SpecialForms_OtherFunctions.isNonEmptySequence(a0) && Types.isVncSymbol(a00 = Coerce.toVncSequence(a0).first()) && ((VncSymbol)a00).getName().equals("splice-unquote")) {
                return VncList.of(new VncSymbol("concat"), Coerce.toVncSequence(a0).second(), SpecialForms_OtherFunctions.quasiquote(((VncSequence)ast).rest()));
            }
            return VncList.of(new VncSymbol("cons"), SpecialForms_OtherFunctions.quasiquote(a0), SpecialForms_OtherFunctions.quasiquote(((VncSequence)ast).rest()));
        }
        return VncList.of(new VncSymbol("quote"), ast);
    }

    private static boolean isNonEmptySequence(VncVal x) {
        return Types.isVncSequence(x) && !((VncSequence)x).isEmpty();
    }

    private static boolean isFunctionType(VncKeyword type) {
        return "core/function".equals(type.getQualifiedName()) || "core/protocol-function".equals(type.getQualifiedName());
    }

    private static boolean isMacroType(VncKeyword type) {
        return "core/macro".equals(type.getQualifiedName());
    }

    private static boolean isSpecialFormType(VncKeyword type) {
        return "core/special-form".equals(type.getQualifiedName());
    }

    private static boolean isProtocolType(VncKeyword type) {
        return "core/protocol".equals(type.getQualifiedName());
    }

    private static boolean isValueType(VncKeyword type) {
        return !SpecialForms_OtherFunctions.isFunctionType(type) && !SpecialForms_OtherFunctions.isMacroType(type) && !SpecialForms_OtherFunctions.isSpecialFormType(type) && !SpecialForms_OtherFunctions.isProtocolType(type);
    }
}

