/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.impl.util.StringUtil;
import java.io.File;

public class ReplDirs {
    private final File homeDir;
    private final File libsDir;
    private final File tmpDir;
    private final File scriptsDir;
    private final File toolsDir;

    private ReplDirs() {
        this.homeDir = null;
        this.libsDir = null;
        this.tmpDir = null;
        this.scriptsDir = null;
        this.toolsDir = null;
    }

    private ReplDirs(File homeDir, File libsDir, File tmpDir, File scriptsDir, File toolsDir) {
        this.homeDir = homeDir;
        this.libsDir = libsDir;
        this.tmpDir = tmpDir;
        this.scriptsDir = scriptsDir;
        this.toolsDir = toolsDir;
    }

    public static ReplDirs create() {
        File homeDir = ReplDirs.getReplHomeDir();
        if (homeDir != null) {
            File libsDir = new File(homeDir, "libs");
            File tmpDir = new File(homeDir, "tmp");
            File scriptsDir = new File(homeDir, "scripts");
            File toolsDir = new File(homeDir, "tools");
            return new ReplDirs(homeDir.isDirectory() ? homeDir : null, libsDir.isDirectory() ? libsDir : null, tmpDir.isDirectory() ? tmpDir : null, scriptsDir.isDirectory() ? scriptsDir : null, toolsDir.isDirectory() ? toolsDir : null);
        }
        return new ReplDirs();
    }

    public static ReplDirs notavail() {
        return new ReplDirs();
    }

    public File getHomeDir() {
        return this.homeDir;
    }

    public File getLibsDir() {
        return this.libsDir;
    }

    public File getFontsDir() {
        return this.libsDir;
    }

    public File getTmpDir() {
        return this.tmpDir;
    }

    public File getScriptsDir() {
        return this.scriptsDir;
    }

    public File getToolsDir() {
        return this.toolsDir;
    }

    public boolean valid() {
        return this.homeDir != null;
    }

    private static File getReplHomeDir() {
        String home = StringUtil.trimToNull(System.getProperty("venice.repl.home"));
        return home == null ? null : new File(home);
    }
}

