/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.sandbox.SandboxFunctionGroups;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.javainterop.IInterceptor;
import com.github.jlangch.venice.javainterop.RejectAllInterceptor;
import com.github.jlangch.venice.javainterop.SandboxInterceptor;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SandboxFunctions {
    public static VncFunction sandboxed_Q = new VncFunction("sandboxed?", (VncVal)VncFunction.meta().arglists("(sandboxed?)").doc("Returns true if there is a sandbox other than `:AcceptAllInterceptor` otherwise false.").examples("(sandboxed?)").seeAlso("sandbox/type").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return VncBoolean.of(ThreadContext.isSandboxed());
        }
    };
    public static VncFunction sandbox_type = new VncFunction("sandbox/type", (VncVal)VncFunction.meta().arglists("(sandbox/type)").doc("Returns the sandbox type. \n\nVenice sandbox types:\n\n * `:" + AcceptAllInterceptor.class.getSimpleName() + "` - accepts all (no restrictions)\n * `:" + RejectAllInterceptor.class.getSimpleName() + "` - safe sandbox, rejects access to all I/O functions, system properties, environment vars, extension modules, dynamic code loading, multi-threaded functions (futures, agents, ...), and Java calls\n * `:" + SandboxInterceptor.class.getSimpleName() + "` - customized sandbox").examples("(sandbox/type)").seeAlso("sandboxed?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            IInterceptor interceptor = ThreadContext.getInterceptor();
            return interceptor == null ? Constants.Nil : new VncKeyword(interceptor.getClass().getSimpleName());
        }
    };
    public static VncFunction sandbox_functions = new VncFunction("sandbox/functions", (VncVal)VncFunction.meta().arglists("(sandbox/functions group)").doc("Lists the sandboxed functions defined by a sandbox function group.\n\nGroups:\n\n * :io \n * :print \n * :concurrency \n * :java-interop \n * :system \n * :special-forms \n * :unsafe").examples("(sandbox/functions :print)").seeAlso("sandboxed?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            String group = Coerce.toVncKeyword(args.first()).getValue();
            return SandboxFunctions.getGroup(group);
        }
    };
    public static final Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(sandboxed_Q).add(sandbox_type).add(sandbox_functions).toMap();

    private static VncList getGroup(String group) {
        switch (group) {
            case "io": 
            case "print": 
            case "special-forms": 
            case "concurrency": 
            case "system": 
            case "java-interop": 
            case "unsafe": {
                return SandboxFunctions.toVncList(SandboxFunctionGroups.groupFunctions("*" + group + "*"));
            }
        }
        throw new VncException("Unsupported sandbox function group! Choose one of {:io, :print, :special-forms, :concurrency, :system, :java-interop, :unsafe}");
    }

    private static VncList toVncList(Set<String> set) {
        return VncList.ofColl(set.stream().sorted().map(s -> new VncString((String)s)).collect(Collectors.toList()));
    }
}

