/*   __    __         _
 *   \ \  / /__ _ __ (_) ___ ___
 *    \ \/ / _ \ '_ \| |/ __/ _ \
 *     \  /  __/ | | | | (_|  __/
 *      \/ \___|_| |_|_|\___\___|
 *
 *
 * Copyright 2017-2025 Venice
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.jlangch.venice.impl.docgen.util;


public class MarkdownDoc {

    public MarkdownDoc(
            final String title,
            final String docMarkdownTextStyled,
            final String docMarkdownXmlStyled,
            final String id
    ) {
        this.title = title;
        this.docMarkdownTextStyled = docMarkdownTextStyled;
        this.docMarkdownXmlStyled = docMarkdownXmlStyled;
        this.id = id;
    }


    public String getTitle() {
        return title;
    }

    public String getDocMarkdownTextStyled() {
        return docMarkdownTextStyled;
    }

    public String getDocMarkdownXmlStyled() {
        return docMarkdownXmlStyled;
    }

    public String getId() {
        return id;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((title == null) ? 0 : title.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        MarkdownDoc other = (MarkdownDoc) obj;
        if (title == null) {
            if (other.title != null)
                return false;
        } else if (!title.equals(other.title))
            return false;
        return true;
    }


    private final String title;
    private final String docMarkdownTextStyled;
    private final String docMarkdownXmlStyled;
    private final String id;
}
