/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.word;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.util.CollectionUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.docx4j.dml.CTBlip;
import org.docx4j.dml.CTNonVisualDrawingProps;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.ImagePngPart;
import org.docx4j.relationships.Relationship;

public class DocxImageReplacer {
    private final WordprocessingMLPackage mainDoc;

    public static DocxImageReplacer of(byte[] mainDoc) throws Exception {
        if (mainDoc == null) {
            throw new IllegalArgumentException("A mainDoc must not be null!");
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(mainDoc);){
            DocxImageReplacer docxImageReplacer = new DocxImageReplacer(WordprocessingMLPackage.load((InputStream)is));
            return docxImageReplacer;
        }
    }

    public static DocxImageReplacer of(ByteBuffer mainDoc) throws Exception {
        if (mainDoc == null) {
            throw new IllegalArgumentException("A mainDoc must not be null!");
        }
        return DocxImageReplacer.of(mainDoc.array());
    }

    public static DocxImageReplacer of(InputStream mainDocIs) throws Exception {
        if (mainDocIs == null) {
            throw new IllegalArgumentException("A mainDocIs must not be null!");
        }
        try {
            DocxImageReplacer docxImageReplacer = new DocxImageReplacer(WordprocessingMLPackage.load((InputStream)mainDocIs));
            return docxImageReplacer;
        }
        finally {
            try {
                mainDocIs.close();
            }
            catch (Exception exception) {}
        }
    }

    public static DocxImageReplacer of(File mainDocFile) throws Exception {
        if (mainDocFile == null) {
            throw new IllegalArgumentException("A mainDocFile must not be null!");
        }
        return new DocxImageReplacer(WordprocessingMLPackage.load((File)mainDocFile));
    }

    private DocxImageReplacer(WordprocessingMLPackage mainDoc) {
        if (mainDoc == null) {
            throw new IllegalArgumentException("A mainDoc must not be null!");
        }
        this.mainDoc = mainDoc;
    }

    public WordprocessingMLPackage doc() {
        return this.mainDoc;
    }

    public byte[] saveToBytes() throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            this.mainDoc.save((OutputStream)os);
            os.close();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    public ByteBuffer saveToByteBuffer() throws Exception {
        return ByteBuffer.wrap(this.saveToBytes());
    }

    public void saveTo(File file) throws Docx4JException {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null!");
        }
        this.mainDoc.save(file);
    }

    public void saveTo(OutputStream os) throws Exception {
        if (os == null) {
            throw new IllegalArgumentException("An os must not be null!");
        }
        try {
            this.mainDoc.save(os);
        }
        finally {
            try {
                os.close();
            }
            catch (Exception exception) {}
        }
    }

    public DocxImageReplacer replaceEmbeddedImageReferencedByImageName(String imageName, File img) throws Exception {
        if (imageName == null) {
            throw new IllegalArgumentException("An imageName must not be null!");
        }
        if (img == null) {
            throw new IllegalArgumentException("An img must not be null!");
        }
        String embedId = this.findImageEmbedIdByImageName(imageName);
        if (embedId == null) {
            throw new VncException(String.format("The Docx 'embedId' for the image name '%s' could not be found", imageName));
        }
        return this.replaceEmbeddedImage(embedId, new FileInputStream(img));
    }

    public DocxImageReplacer replaceEmbeddedImageReferencedByImageName(String imageName, byte[] img) throws Exception {
        if (imageName == null) {
            throw new IllegalArgumentException("An imageName must not be null!");
        }
        if (img == null) {
            throw new IllegalArgumentException("An img must not be null!");
        }
        String embedId = this.findImageEmbedIdByImageName(imageName);
        if (embedId == null) {
            throw new VncException(String.format("The Docx 'embedId' for the image name '%s' could not be found", imageName));
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(img);){
            DocxImageReplacer docxImageReplacer = this.replaceEmbeddedImage(embedId, is);
            return docxImageReplacer;
        }
    }

    public DocxImageReplacer replaceEmbeddedImageReferencedByImageName(String imageName, InputStream img) throws Exception {
        if (imageName == null) {
            throw new IllegalArgumentException("An imageName must not be null!");
        }
        if (img == null) {
            throw new IllegalArgumentException("An img must not be null!");
        }
        String embedId = this.findImageEmbedIdByImageName(imageName);
        if (embedId == null) {
            throw new VncException(String.format("The Docx 'embedId' for the image name '%s' could not be found", imageName));
        }
        return this.replaceEmbeddedImage(embedId, img);
    }

    public DocxImageReplacer replaceEmbeddedImageReferencedByImageDescr(String imgDescr, File img) throws Exception {
        if (imgDescr == null) {
            throw new IllegalArgumentException("An imgDescr must not be null!");
        }
        if (img == null) {
            throw new IllegalArgumentException("An img must not be null!");
        }
        String embedId = this.findImageEmbedIdByImageDescr(imgDescr);
        if (embedId == null) {
            throw new VncException(String.format("The Docx 'embedId' for the image descr '%s' could not be found", imgDescr));
        }
        return this.replaceEmbeddedImage(embedId, new FileInputStream(img));
    }

    public DocxImageReplacer replaceEmbeddedImageReferencedByImageDescr(String imgDescr, byte[] img) throws Exception {
        if (imgDescr == null) {
            throw new IllegalArgumentException("An imgDescr must not be null!");
        }
        if (img == null) {
            throw new IllegalArgumentException("An img must not be null!");
        }
        String embedId = this.findImageEmbedIdByImageDescr(imgDescr);
        if (embedId == null) {
            throw new VncException(String.format("The Docx 'embedId' for the image descr '%s' could not be found", imgDescr));
        }
        return this.replaceEmbeddedImage(embedId, new ByteArrayInputStream(img));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocxImageReplacer replaceEmbeddedImageReferencedByImageDescr(String imgDescr, InputStream imgIS) throws Exception {
        if (imgDescr == null) {
            throw new IllegalArgumentException("An imgDescr must not be null!");
        }
        if (imgIS == null) {
            throw new IllegalArgumentException("An imgIS must not be null!");
        }
        String embedId = this.findImageEmbedIdByImageDescr(imgDescr);
        if (embedId == null) {
            throw new VncException(String.format("The Docx 'embedId' for the image descr '%s' could not be found", imgDescr));
        }
        try {
            DocxImageReplacer docxImageReplacer = this.replaceEmbeddedImage(embedId, imgIS);
            return docxImageReplacer;
        }
        finally {
            try {
                imgIS.close();
            }
            catch (Exception exception) {}
        }
    }

    private String findImageEmbedIdByImageName(String imgName) throws Exception {
        List drawings = this.mainDoc.getMainDocumentPart().getJAXBNodesViaXPath(String.format("//wp:docPr[@name=\"%s\"]", imgName), false);
        return this.findImageEmbedId(drawings);
    }

    private String findImageEmbedIdByImageDescr(String imgDescr) throws Exception {
        List drawings = this.mainDoc.getMainDocumentPart().getJAXBNodesViaXPath(String.format("//wp:docPr[@descr=\"%s\"]", imgDescr), false);
        return this.findImageEmbedId(drawings);
    }

    private DocxImageReplacer replaceEmbeddedImage(String embedId, InputStream imgIS) throws Exception {
        Relationship rel = this.findRelationshipById(embedId);
        if (rel == null) {
            throw new VncException(String.format("The Docx relationship for the embedId '%s' could not be found", embedId));
        }
        String partName = String.format("/word/media/document_image_%s.png", embedId);
        ImagePngPart imagePart = new ImagePngPart(new PartName(partName));
        imagePart.setBinaryData(imgIS);
        imagePart.setContentType(new ContentType("image/png"));
        imagePart.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/image");
        Relationship relNew = this.mainDoc.getMainDocumentPart().addTargetPart((Part)imagePart);
        relNew.setId(embedId);
        return this;
    }

    private Relationship findRelationshipById(String rID) {
        return this.mainDoc.getMainDocumentPart().getRelationshipsPart().getRelationshipByID(rID);
    }

    private String findImageEmbedId(List<Object> drawings) {
        Object parent;
        Object drawing = CollectionUtil.first(drawings);
        if (drawing instanceof CTNonVisualDrawingProps && (parent = ((CTNonVisualDrawingProps)drawing).getParent()) instanceof Inline) {
            Inline inline = (Inline)parent;
            CTBlip blip = inline.getGraphic().getGraphicData().getPic().getBlipFill().getBlip();
            return blip.getEmbed();
        }
        return null;
    }
}

