/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.excel;

import com.github.jlangch.venice.impl.util.excel.Excel;
import com.github.jlangch.venice.util.excel.ExcelCellStyleBuilder;
import com.github.jlangch.venice.util.excel.ExcelFontBuilder;
import com.github.jlangch.venice.util.excel.ExcelSheetFacade;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ExcelFacade {
    private final Excel excel;

    public ExcelFacade(Excel excel) {
        this.excel = excel;
    }

    public static ExcelFacade open(byte[] document) {
        return new ExcelFacade(Excel.open(new ByteArrayInputStream(document)));
    }

    public static ExcelFacade open(ByteBuffer document) {
        return new ExcelFacade(Excel.open(new ByteArrayInputStream(document.array())));
    }

    public static ExcelFacade open(File file) {
        return new ExcelFacade(Excel.open(file));
    }

    public static ExcelFacade open(InputStream is) {
        return new ExcelFacade(Excel.open(is));
    }

    public static ExcelFacade createXls() {
        return new ExcelFacade(Excel.createXls());
    }

    public static ExcelFacade createXlsx() {
        return new ExcelFacade(Excel.createXlsx());
    }

    public int getNumberOfSheets() {
        return this.excel.getNumberOfSheets();
    }

    public void evaluateAllFormulas() {
        this.excel.evaluateAllFormulas();
    }

    public ExcelFontBuilder withFont(String name) {
        return new ExcelFontBuilder(this, this.excel, name);
    }

    public ExcelCellStyleBuilder withCellStyle(String name) {
        return new ExcelCellStyleBuilder(this, this.excel, name);
    }

    public <T> ExcelSheetFacade<T> withSheet(String name, Class<T> type) {
        return new ExcelSheetFacade(this, this.excel.createSheet(name));
    }

    public void write(File file) {
        this.excel.write(file);
    }

    public void write(OutputStream outputStream) {
        this.excel.write(outputStream);
    }

    public byte[] writeToBytes() {
        return this.excel.writeToBytes();
    }

    public ExcelFacade end() {
        this.excel.close();
        return this;
    }

    public <T> ExcelSheetFacade<T> getSheet(String name) {
        return new ExcelSheetFacade(this, this.excel.getSheet(name));
    }

    public <T> ExcelSheetFacade<T> getSheetAt(int sheetIdx) {
        return new ExcelSheetFacade(this, this.excel.getSheetAt(sheetIdx - 1));
    }

    public Excel toExcel() {
        return this.excel;
    }
}

