/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.crypt;

import com.github.jlangch.venice.util.crypt.Util;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.ChaChaEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class FileEncryptor_ChaCha20_BouncyCastle {
    private static final boolean supported = FileEncryptor_ChaCha20_BouncyCastle.checkSupported();
    private static int ROUNDS = 20;
    private static int SALT_LEN = 16;
    private static int IV_LEN = 8;

    public static boolean isSupported() {
        return supported;
    }

    public static void encryptFileWithPassphrase(String passphrase, File inputFile, File outputFile) throws Exception {
        byte[] fileData = Files.readAllBytes(inputFile.toPath());
        byte[] encryptedData = FileEncryptor_ChaCha20_BouncyCastle.encryptFileWithPassphrase(passphrase, fileData);
        Files.write(outputFile.toPath(), encryptedData, new OpenOption[0]);
    }

    public static byte[] encryptFileWithPassphrase(String passphrase, byte[] fileData) throws Exception {
        byte[] salt = new byte[SALT_LEN];
        new SecureRandom().nextBytes(salt);
        byte[] iv = new byte[IV_LEN];
        new SecureRandom().nextBytes(iv);
        byte[] key = Util.deriveKeyFromPassphrase(passphrase, salt, 65536, 256);
        byte[] encryptedData = FileEncryptor_ChaCha20_BouncyCastle.processData(1, fileData, key, iv);
        byte[] outData = new byte[SALT_LEN + IV_LEN + encryptedData.length];
        System.arraycopy(salt, 0, outData, 0, salt.length);
        System.arraycopy(iv, 0, outData, SALT_LEN, iv.length);
        System.arraycopy(encryptedData, 0, outData, SALT_LEN + IV_LEN, encryptedData.length);
        return outData;
    }

    public static void encryptFileWithKey(byte[] key, File inputFile, File outputFile) throws Exception {
        byte[] fileData = Files.readAllBytes(inputFile.toPath());
        byte[] encryptedData = FileEncryptor_ChaCha20_BouncyCastle.encryptFileWithKey(key, fileData);
        Files.write(outputFile.toPath(), encryptedData, new OpenOption[0]);
    }

    public static byte[] encryptFileWithKey(byte[] key, byte[] fileData) throws Exception {
        byte[] iv = new byte[IV_LEN];
        new SecureRandom().nextBytes(iv);
        byte[] encryptedData = FileEncryptor_ChaCha20_BouncyCastle.processData(1, fileData, key, iv);
        byte[] outData = new byte[IV_LEN + encryptedData.length];
        System.arraycopy(iv, 0, outData, 0, iv.length);
        System.arraycopy(encryptedData, 0, outData, IV_LEN, encryptedData.length);
        return outData;
    }

    public static void decryptFileWithPassphrase(String passphrase, File inputFile, File outputFile) throws Exception {
        byte[] fileData = Files.readAllBytes(inputFile.toPath());
        byte[] decryptedData = FileEncryptor_ChaCha20_BouncyCastle.decryptFileWithPassphrase(passphrase, fileData);
        Files.write(outputFile.toPath(), decryptedData, new OpenOption[0]);
    }

    public static byte[] decryptFileWithPassphrase(String passphrase, byte[] fileData) throws Exception {
        byte[] salt = new byte[SALT_LEN];
        System.arraycopy(fileData, 0, salt, 0, SALT_LEN);
        byte[] iv = new byte[IV_LEN];
        System.arraycopy(fileData, SALT_LEN, iv, 0, IV_LEN);
        byte[] encryptedData = new byte[fileData.length - SALT_LEN - IV_LEN];
        System.arraycopy(fileData, SALT_LEN + IV_LEN, encryptedData, 0, encryptedData.length);
        byte[] key = Util.deriveKeyFromPassphrase(passphrase, salt, 65536, 256);
        return FileEncryptor_ChaCha20_BouncyCastle.processData(2, encryptedData, key, iv);
    }

    public static void decryptFileWithKey(byte[] key, File inputFile, File outputFile) throws Exception {
        byte[] fileData = Files.readAllBytes(inputFile.toPath());
        byte[] decryptedData = FileEncryptor_ChaCha20_BouncyCastle.decryptFileWithKey(key, fileData);
        Files.write(outputFile.toPath(), decryptedData, new OpenOption[0]);
    }

    public static byte[] decryptFileWithKey(byte[] key, byte[] fileData) throws Exception {
        byte[] iv = new byte[IV_LEN];
        System.arraycopy(fileData, 0, iv, 0, IV_LEN);
        byte[] encryptedData = new byte[fileData.length - IV_LEN];
        System.arraycopy(fileData, IV_LEN, encryptedData, 0, encryptedData.length);
        return FileEncryptor_ChaCha20_BouncyCastle.processData(2, encryptedData, key, iv);
    }

    private static byte[] processData(int mode, byte[] data, byte[] key, byte[] iv) throws Exception {
        ChaChaEngine chacha = new ChaChaEngine(ROUNDS);
        chacha.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(key), iv));
        byte[] cryptData = new byte[data.length];
        chacha.processBytes(data, 0, data.length, cryptData, 0);
        return cryptData;
    }

    private static boolean checkSupported() {
        try {
            Class<?> clazz = Util.classForName("org.bouncycastle.crypto.engines.ChaChaEngine");
            return clazz != null;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

