/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.markdown.renderer.text;

import com.github.jlangch.venice.impl.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class LineFormatter {
    public static List<String> leftAlign(List<String> str, int width, char fill) {
        if (str == null) {
            throw new IllegalArgumentException("A str list must not be null!");
        }
        if (width < 0) {
            throw new IllegalArgumentException("A width must not be negative!");
        }
        return str.stream().map(s -> LineFormatter.leftAlign(s, width, fill)).collect(Collectors.toList());
    }

    public static String leftAlign(String str, int width, char fill) {
        if (width < 0) {
            throw new IllegalArgumentException("A width must not be negative!");
        }
        String s = StringUtil.nullToEmpty(str);
        int delta = width - s.length();
        return delta == 0 ? s : (delta > 0 ? s + StringUtil.repeat(fill, delta) : s.substring(0, width));
    }

    public static List<String> rightAlign(List<String> str, int width, char fill) {
        if (str == null) {
            throw new IllegalArgumentException("A str list must not be null!");
        }
        if (width < 0) {
            throw new IllegalArgumentException("A width must not be negative!");
        }
        return str.stream().map(s -> LineFormatter.rightAlign(s, width, fill)).collect(Collectors.toList());
    }

    public static String rightAlign(String str, int width, char fill) {
        if (width < 0) {
            throw new IllegalArgumentException("A width must not be negative!");
        }
        String s = StringUtil.nullToEmpty(str);
        int delta = width - s.length();
        return delta == 0 ? s : (delta > 0 ? StringUtil.repeat(fill, delta) + s : s.substring(0, width));
    }

    public static List<String> centerAlign(List<String> str, int width, char fill) {
        if (str == null) {
            throw new IllegalArgumentException("A str list must not be null!");
        }
        if (width < 0) {
            throw new IllegalArgumentException("A width must not be negative!");
        }
        return str.stream().map(s -> LineFormatter.centerAlign(s, width, fill)).collect(Collectors.toList());
    }

    public static String centerAlign(String str, int width, char fill) {
        if (width < 0) {
            throw new IllegalArgumentException("A width must not be negative!");
        }
        String s = StringUtil.nullToEmpty(str);
        int delta = width - s.length();
        if (delta == 0) {
            return s;
        }
        if (delta < 0) {
            return s.substring(0, width);
        }
        int leftPad = delta / 2;
        int rightPad = delta - leftPad;
        return StringUtil.repeat(fill, leftPad) + s + StringUtil.repeat(fill, rightPad);
    }

    public static List<String> bottomPad(List<String> lines, int height, char fill) {
        int delta = height - lines.size();
        if (delta == 0) {
            return lines;
        }
        if (delta < 0) {
            return lines.subList(0, height);
        }
        ArrayList<String> tmp = new ArrayList<String>(lines);
        for (int ii = 0; ii < delta; ++ii) {
            tmp.add("");
        }
        return tmp;
    }
}

