/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.io;

import com.github.jlangch.venice.FileException;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class FileIterator
implements Iterator<File> {
    private final File root;
    private final Predicate<File> filter;
    private final LinkedList<File> dirsLeft = new LinkedList();
    private final LinkedList<File> filesLeft = new LinkedList();

    public FileIterator(File root) {
        this(root, f -> true);
    }

    public FileIterator(File root, Predicate<File> filter) {
        if (root == null) {
            throw new IllegalArgumentException("A root dir must not be null!");
        }
        if (!root.isDirectory()) {
            throw new FileException("The root dir '" + root + "' does not exist!");
        }
        this.root = root;
        this.filter = filter;
        this.addChildren(root);
    }

    public Stream<File> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new FileIterator(this.root, this.filter), 16), false);
    }

    @Override
    public boolean hasNext() {
        return this.hasDirs() || this.hasFiles();
    }

    @Override
    public File next() {
        while (this.hasDirs() || this.hasFiles()) {
            if (this.hasFiles()) {
                File file = this.nextFile();
                if (!this.filter.test(file)) continue;
                return file;
            }
            File dir = this.nextDir();
            this.addChildren(dir);
            if (!this.filter.test(dir)) continue;
            return dir;
        }
        return null;
    }

    public void stop() {
        this.dirsLeft.clear();
        this.filesLeft.clear();
    }

    private void addChildren(File parent) {
        Arrays.stream(parent.listFiles()).sorted(Comparator.comparing(File::getName)).forEach(f -> {
            if (f.isDirectory()) {
                this.dirsLeft.addLast((File)f);
            } else if (f.isFile()) {
                this.filesLeft.addLast((File)f);
            }
        });
    }

    private boolean hasDirs() {
        return !this.dirsLeft.isEmpty();
    }

    private boolean hasFiles() {
        return !this.filesLeft.isEmpty();
    }

    private File nextDir() {
        return this.hasDirs() ? this.dirsLeft.removeFirst() : null;
    }

    private File nextFile() {
        return this.hasFiles() ? this.filesLeft.removeFirst() : null;
    }
}

