/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.excel;

import com.github.jlangch.venice.ExcelException;
import com.github.jlangch.venice.FileException;
import com.github.jlangch.venice.impl.util.excel.ColorUtil;
import com.github.jlangch.venice.impl.util.excel.ExcelCellStyles;
import com.github.jlangch.venice.impl.util.excel.ExcelSheet;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Excel
implements Closeable {
    public static final int DEFAULT_FONT_SIZE = 11;
    private final Workbook workbook;
    private final ExcelCellStyles cellDataStyles;
    private final Map<String, Font> fonts = new HashMap<String, Font>();
    private final FormulaEvaluator evaluator;

    Excel(Workbook workbook) {
        this.workbook = workbook;
        this.cellDataStyles = new ExcelCellStyles(workbook, this.fonts);
        this.evaluator = workbook.getCreationHelper().createFormulaEvaluator();
    }

    public static Excel create() {
        return Excel.createXls();
    }

    public static Excel createXls() {
        return new Excel((Workbook)new HSSFWorkbook());
    }

    public static Excel createXlsx() {
        return new Excel((Workbook)new XSSFWorkbook());
    }

    public static Excel open(byte[] document) {
        return Excel.open(new ByteArrayInputStream(document));
    }

    public static Excel open(ByteBuffer document) {
        return Excel.open(new ByteArrayInputStream(document.array()));
    }

    public static Excel open(File file) {
        try {
            return Excel.open(new FileInputStream(file));
        }
        catch (Exception ex) {
            throw new ExcelException(String.format("Failed to open the Excel file '%s'. File not found!", file.getPath()));
        }
    }

    public static Excel open(InputStream document) {
        try {
            return new Excel(WorkbookFactory.create((InputStream)document));
        }
        catch (Exception ex) {
            throw new ExcelException("Failed to open the Excel document from the input stream");
        }
    }

    public ExcelSheet createSheet(String name) {
        return new ExcelSheet(this.workbook.createSheet(name), this.cellDataStyles, this.evaluator);
    }

    public ExcelSheet getSheet(String name) {
        Sheet sheet = this.workbook.getSheet(name);
        if (sheet == null) {
            throw new ExcelException(String.format("The sheet '%s' does not exist", name));
        }
        return new ExcelSheet(sheet, this.cellDataStyles, this.evaluator);
    }

    public ExcelSheet getSheetAt(int sheetIdx) {
        Sheet sheet = this.workbook.getSheetAt(sheetIdx);
        if (sheet == null) {
            throw new ExcelException(String.format("The sheet at the index '%d' does not exist", sheetIdx + 1));
        }
        return new ExcelSheet(sheet, this.cellDataStyles, this.evaluator);
    }

    public int getNumberOfSheets() {
        return this.workbook.getNumberOfSheets();
    }

    public void evaluateAllFormulas() {
        this.evaluator.clearAllCachedResultValues();
        this.evaluator.evaluateAll();
    }

    public void registerFont(String id, String fontName, int heightInPoints) {
        this.registerFont(id, fontName, (Integer)heightInPoints, false, false, false, (Short)null);
    }

    public void registerFont(String id, String fontName, Integer heightInPoints, boolean bold, boolean italic, boolean underline, Short colorIndex) {
        Font font = this.workbook.createFont();
        if (fontName != null) {
            font.setFontName(fontName);
        }
        if (heightInPoints != null) {
            font.setFontHeightInPoints(heightInPoints.shortValue());
        }
        font.setBold(bold);
        font.setItalic(italic);
        font.setUnderline(underline ? (byte)1 : 0);
        if (colorIndex != null) {
            font.setColor(colorIndex.shortValue());
        }
        this.fonts.put(id, font);
    }

    public void registerFont(String id, String fontName, Integer heightInPoints, boolean bold, boolean italic, boolean underline, Color color) {
        Font font = this.workbook.createFont();
        if (fontName != null) {
            font.setFontName(fontName);
        }
        if (heightInPoints != null) {
            font.setFontHeightInPoints(heightInPoints.shortValue());
        }
        font.setBold(bold);
        font.setItalic(italic);
        font.setUnderline(underline ? (byte)1 : 0);
        if (color != null) {
            if (font instanceof XSSFFont) {
                ((XSSFFont)font).setColor(new XSSFColor(color, null));
            } else if (font instanceof HSSFFont) {
                font.setColor(ColorUtil.bestHSSFColor((HSSFWorkbook)this.workbook, color).getIndex());
            }
        }
        this.fonts.put(id, font);
    }

    public void registerCellFormat(String id, String format) {
        this.registerCellFormat(id, format, null, (Short)null, null, null, null, (Short)null, null, null, null, null);
    }

    public void registerCellFormat(String id, String format, String fontRefName, Short bgColorIndex, Boolean wrapText, HorizontalAlignment hAlign, VerticalAlignment vAlign, Short rotation, BorderStyle borderTopStyle, BorderStyle borderRightStyle, BorderStyle borderBottomStyle, BorderStyle borderLeftStyle) {
        this.cellDataStyles.registerCellFormat(id, format, fontRefName, bgColorIndex, wrapText, hAlign, vAlign, rotation, borderTopStyle, borderRightStyle, borderBottomStyle, borderLeftStyle);
    }

    public void registerCellFormat(String id, String format, String fontRefName, Color bgColor, Boolean wrapText, HorizontalAlignment hAlign, VerticalAlignment vAlign, Short rotation, BorderStyle borderTopStyle, BorderStyle borderRightStyle, BorderStyle borderBottomStyle, BorderStyle borderLeftStyle) {
        this.cellDataStyles.registerCellFormat(id, format, fontRefName, bgColor, wrapText, hAlign, vAlign, rotation, borderTopStyle, borderRightStyle, borderBottomStyle, borderLeftStyle);
    }

    public void write(File file) {
        if (file == null) {
            this.close();
            throw new IllegalArgumentException("An 'file' must not be null");
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.workbook.write((OutputStream)fos);
        }
        catch (Exception ex) {
            throw new ExcelException("Failed to write the Excel document to the file " + file, ex);
        }
        finally {
            this.close();
        }
    }

    public void write(OutputStream outputStream) {
        if (outputStream == null) {
            this.close();
            throw new IllegalArgumentException("An 'outputStream' must not be null");
        }
        try {
            this.workbook.write(outputStream);
        }
        catch (Exception ex) {
            throw new ExcelException("Failed to write the Excel document to the output stream", ex);
        }
        finally {
            this.close();
        }
    }

    public byte[] writeToBytes() {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        this.write(bs);
        return bs.toByteArray();
    }

    public ByteBuffer writeToByteBuffer() {
        return ByteBuffer.wrap(this.writeToBytes());
    }

    public void writeToFile(File file) {
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(this.writeToBytes());
        }
        catch (Exception ex) {
            throw new FileException("Failed to write the Excel to a file", ex);
        }
    }

    public Map<String, Object> writeToDocument(String docName) {
        HashMap<String, Object> doc = new HashMap<String, Object>();
        doc.put("binary", this.writeToBytes());
        doc.put("name", docName);
        doc.put("filename", this.makeFilename(docName));
        doc.put("mimetype", this.isXls() ? "application/vnd.ms-msexcel" : "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        return doc;
    }

    @Override
    public void close() {
        try {
            this.workbook.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String makeFilename(String name) {
        return name.endsWith(".xls") || name.endsWith(".xlsx") ? name : (this.isXlsx() ? name + ".xlsx" : name + ".xls");
    }

    public boolean isXls() {
        return this.workbook instanceof HSSFWorkbook;
    }

    public boolean isXlsx() {
        return this.workbook instanceof XSSFWorkbook;
    }
}

