/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.csv;

import com.github.jlangch.venice.impl.util.io.CharsetUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;

public class CharacterReader {
    private static final int EOF = -1;
    private static final int LF = 10;
    private static final int CR = 13;
    private final Reader rd;
    private int chNext;
    private int lineNr = 1;
    private int columnNr = 1;

    public CharacterReader(String s) {
        this(new StringReader(s == null ? "" : s));
    }

    public CharacterReader(InputStream is, Charset charset) {
        this(new InputStreamReader(is, CharsetUtil.charset(charset)));
    }

    public CharacterReader(Reader r) {
        this.rd = r;
        this.chNext = this.next();
    }

    public int peek() {
        return this.chNext;
    }

    public void consume() {
        if (this.chNext != -1) {
            if (this.chNext == 10) {
                ++this.lineNr;
                this.columnNr = 1;
            } else if (this.chNext != 13) {
                ++this.columnNr;
            }
            this.chNext = this.next();
        }
    }

    public void skipAllOfChar(char ch) {
        while (this.peek() == ch) {
            this.consume();
        }
    }

    public boolean isEof() {
        return this.chNext == -1;
    }

    public boolean isLf() {
        return this.chNext == 10;
    }

    public boolean isCr() {
        return this.chNext == 13;
    }

    public int getLineNr() {
        return this.lineNr;
    }

    public int getColNr() {
        return this.columnNr;
    }

    private int next() {
        try {
            return this.rd.read();
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("Failed to read next char from CSV reader at line %d, col %d.", this.lineNr, this.columnNr), ex);
        }
    }
}

