/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.custom;

import com.github.jlangch.venice.AssertionException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.types.custom.VncCustomBaseTypeDef;
import com.github.jlangch.venice.impl.types.custom.VncCustomTypeFieldDef;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class VncCustomTypeDef
extends VncCustomBaseTypeDef {
    private static final long serialVersionUID = -1848883965231344442L;
    private final List<VncCustomTypeFieldDef> fieldDefs;
    private final VncFunction validationFn;

    public VncCustomTypeDef(VncKeyword type, List<VncCustomTypeFieldDef> fieldDefs, VncFunction validationFn) {
        super(type);
        this.fieldDefs = fieldDefs;
        this.validationFn = validationFn;
    }

    public VncCustomTypeFieldDef getFieldDef(int index) {
        if (index >= 0 && index < this.fieldDefs.size()) {
            return this.fieldDefs.get(index);
        }
        throw new VncException(String.format("deftype: field def index %d out of bounds.", index));
    }

    public List<VncCustomTypeFieldDef> getFieldDefs() {
        return this.fieldDefs;
    }

    public Set<VncKeyword> getFieldNames() {
        return this.fieldDefs.stream().map(f -> f.getName()).collect(Collectors.toSet());
    }

    public VncFunction getValidationFn() {
        return this.validationFn;
    }

    public int count() {
        return this.fieldDefs.size();
    }

    public void validate(VncVal val) {
        if (this.validationFn != null) {
            try {
                VncVal valid = this.validationFn.apply(VncList.of(val));
                if (VncBoolean.isFalseOrNil(valid)) {
                    throw new AssertionException(String.format("Invalid value for custom type :%s", this.getType().getValue()));
                }
            }
            catch (AssertionException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new AssertionException(String.format("Invalid value for custom type :%s", this.getType().getValue()), ex);
            }
        }
    }

    @Override
    public VncMap toMap() {
        List defs = this.fieldDefs.stream().map(o -> o.toMap()).collect(Collectors.toList());
        return VncOrderedMap.of(new VncKeyword(":type"), this.getType(), new VncKeyword(":custom-type"), new VncKeyword(":record"), new VncKeyword(":field-defs"), VncList.ofColl(defs), new VncKeyword(":validation-fn"), this.validationFn == null ? Constants.Nil : this.validationFn);
    }
}

