/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.namespaces;

import com.github.jlangch.venice.impl.namespaces.Namespace;
import com.github.jlangch.venice.impl.types.VncSymbol;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class NamespaceRegistry
implements Serializable {
    private static final long serialVersionUID = 672571759583276084L;
    private final Map<VncSymbol, Namespace> namespaces = new ConcurrentHashMap<VncSymbol, Namespace>();

    public NamespaceRegistry add(Namespace ns) {
        Objects.requireNonNull(ns);
        this.namespaces.put(ns.getNS(), ns);
        return this;
    }

    public NamespaceRegistry add(NamespaceRegistry nsRegistry) {
        for (Namespace ns : nsRegistry.namespaces.values()) {
            this.add(ns);
        }
        return this;
    }

    public NamespaceRegistry remove(VncSymbol sym) {
        Objects.requireNonNull(sym);
        this.namespaces.remove(sym);
        return this;
    }

    public Namespace get(VncSymbol sym) {
        Objects.requireNonNull(sym);
        return this.namespaces.get(sym);
    }

    public Namespace computeIfAbsent(VncSymbol sym) {
        Objects.requireNonNull(sym);
        return this.namespaces.computeIfAbsent(sym, s -> new Namespace((VncSymbol)s));
    }

    public void clear() {
        this.namespaces.clear();
    }

    public boolean isEmpty() {
        return this.namespaces.isEmpty();
    }

    public NamespaceRegistry copy() {
        NamespaceRegistry nsRegistry = new NamespaceRegistry();
        for (Map.Entry<VncSymbol, Namespace> entry : this.namespaces.entrySet()) {
            nsRegistry.namespaces.put(entry.getKey(), entry.getValue().copy());
        }
        return nsRegistry;
    }
}

