/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.namespaces;

import com.github.jlangch.venice.impl.javainterop.JavaImports;
import com.github.jlangch.venice.impl.namespaces.Namespaces;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class Namespace
implements Serializable {
    private static final long serialVersionUID = -6955287120175682059L;
    private final VncSymbol ns;
    private final JavaImports javaImports;
    private final ConcurrentHashMap<String, String> aliases = new ConcurrentHashMap();
    private final AtomicReference<VncHashMap> metaRef = new AtomicReference<VncHashMap>(VncHashMap.EMPTY);

    private Namespace(VncSymbol ns, JavaImports javaImports, ConcurrentHashMap<String, String> aliases) {
        this.ns = ns;
        this.javaImports = javaImports.copy();
        this.aliases.putAll(aliases);
    }

    public Namespace(VncSymbol ns) {
        this.ns = ns == null ? Namespaces.NS_USER : ns;
        this.javaImports = new JavaImports();
    }

    public VncSymbol getNS() {
        return this.ns;
    }

    public void addAlias(String alias, String ns) {
        this.aliases.put(alias, ns);
    }

    public void removeAlias(String alias) {
        this.aliases.remove(alias);
    }

    public String lookupByAlias(String alias) {
        return this.aliases.get(alias);
    }

    public VncMap listAliases() {
        return this.aliases.entrySet().stream().map(e -> VncHashMap.of(new VncSymbol((String)e.getKey()), new VncSymbol((String)e.getValue()))).reduce(new VncHashMap(), (x, y) -> x.putAll((VncMap)y));
    }

    public JavaImports getJavaImports() {
        return this.javaImports;
    }

    public VncList getJavaImportsAsVncList() {
        return this.javaImports.list();
    }

    public Namespace copy() {
        return new Namespace(this.ns, this.javaImports, this.aliases);
    }

    public VncHashMap getMeta() {
        return this.metaRef.get();
    }

    public void setMeta(VncHashMap meta) {
        this.metaRef.set(meta == null ? VncHashMap.EMPTY : meta);
    }

    public String toString() {
        return this.ns.getName();
    }
}

