/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.debug.breakpoint;

import com.github.jlangch.venice.impl.debug.breakpoint.AncestorType;
import com.github.jlangch.venice.impl.types.util.QualifiedName;

public class AncestorSelector {
    private final QualifiedName ancestorQN;
    private final AncestorType type;

    public AncestorSelector(QualifiedName ancestorQN, AncestorType type) {
        if (ancestorQN == null) {
            throw new RuntimeException("A ancestorQN must not be null");
        }
        if (type == null) {
            throw new RuntimeException("A type must not be null");
        }
        this.ancestorQN = ancestorQN;
        this.type = type;
    }

    public QualifiedName getAncestor() {
        return this.ancestorQN;
    }

    public AncestorType getType() {
        return this.type;
    }

    public String formatForBaseFn(String fnName) {
        return String.format("%s %s %s", this.ancestorQN.getQualifiedName(), this.type.symbol(), fnName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ancestorQN == null ? 0 : this.ancestorQN.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AncestorSelector other = (AncestorSelector)obj;
        if (this.ancestorQN == null ? other.ancestorQN != null : !this.ancestorQN.equals(other.ancestorQN)) {
            return false;
        }
        return this.type == other.type;
    }
}

