/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.IVeniceInterpreter;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.modules.ModuleLoader;
import com.github.jlangch.venice.impl.namespaces.Namespace;
import com.github.jlangch.venice.impl.namespaces.Namespaces;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.javainterop.IInterceptor;

public class CodeLoader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadModule(VncKeyword module, IVeniceInterpreter venice, IInterceptor interceptor, Env env, boolean force, VncVector aliasOpt) {
        VncSet loadedModules;
        VncSet vncSet = loadedModules = this.getLoadedModules(env);
        synchronized (vncSet) {
            Namespace currNS = Namespaces.getCurrentNamespace();
            try {
                boolean load;
                long nanos = System.nanoTime();
                String moduleName = module.getValue();
                boolean bl = load = !loadedModules.contains(module) || force;
                if (load) {
                    if (interceptor != null) {
                        interceptor.validateLoadModule(moduleName);
                    }
                    String code = ModuleLoader.loadModule(moduleName);
                    this.loadCode(code, moduleName, venice, env);
                    loadedModules.add(module);
                }
                this.processNsAlias(aliasOpt, currNS, String.format("load-module '%s'", moduleName));
                long elapsed = System.nanoTime() - nanos;
                if (load && venice.getMeterRegistry().enabled) {
                    venice.getMeterRegistry().record("venice.module." + module + ".load", elapsed);
                }
                this.reportModuleLoad(moduleName, elapsed, load, force);
                boolean bl2 = load;
                return bl2;
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                throw new VncException("Failed to load module '" + module + "'", ex);
            }
            finally {
                Namespaces.setCurrentNamespace(currNS);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadVeniceFile(VncString file, IVeniceInterpreter venice, IInterceptor interceptor, Env env, boolean force, VncVector aliasOpt) {
        VncSet loadedFiles;
        VncSet vncSet = loadedFiles = this.getLoadedFiles(env);
        synchronized (vncSet) {
            Namespace currNS = Namespaces.getCurrentNamespace();
            try {
                boolean load;
                String fileName = file.getValue();
                boolean bl = load = !loadedFiles.contains(file) || force;
                if (load) {
                    String code = ModuleLoader.loadExternalVeniceFile(fileName);
                    this.loadCode(code, fileName, venice, env);
                    loadedFiles.add(file);
                }
                this.processNsAlias(aliasOpt, currNS, String.format("load-file '%s'", fileName));
                boolean bl2 = load;
                return bl2;
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                throw new VncException("Failed to load file '" + file.getValue() + "'", ex);
            }
            finally {
                Namespaces.setCurrentNamespace(currNS);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadVeniceClasspathFile(VncString file, IVeniceInterpreter venice, IInterceptor interceptor, Env env, boolean force, VncVector aliasOpt) {
        VncSet loadedFiles;
        VncSet vncSet = loadedFiles = this.getLoadedFiles(env);
        synchronized (vncSet) {
            Namespace currNS = Namespaces.getCurrentNamespace();
            try {
                boolean load;
                String fileName = file.getValue();
                boolean bl = load = !loadedFiles.contains(file) || force;
                if (load) {
                    String code = ModuleLoader.loadClasspathVeniceFile(fileName);
                    if (code == null) {
                        throw new VncException("Failed to load Venice classpath file");
                    }
                    this.loadCode(code, fileName, venice, env);
                    loadedFiles.add(file);
                }
                this.processNsAlias(aliasOpt, currNS, String.format("load-classpath-file '%s'", fileName));
                boolean bl2 = load;
                return bl2;
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                throw new VncException("Failed to load classpath file '" + file.getValue() + "'", ex);
            }
            finally {
                Namespaces.setCurrentNamespace(currNS);
            }
        }
    }

    public VncVal loadCode(String code, String name, IVeniceInterpreter venice, Env env) {
        VncVal ast = venice.READ("(do " + code + ")", name);
        if (venice.isMacroExpandOnLoad()) {
            ast = venice.MACROEXPAND(ast, env);
        }
        ast = venice.EVAL(ast, env);
        return ast;
    }

    private void processNsAlias(VncVector aliasOpt, Namespace ns, String contextInfo) {
        if (aliasOpt != null) {
            this.validateNsAlias(contextInfo, aliasOpt);
            VncSymbol aliasName = this.unquoteSymbol(aliasOpt.third());
            VncSymbol nsName = this.unquoteSymbol(aliasOpt.first());
            ns.addAlias(aliasName.getName(), nsName.getName());
        }
    }

    private VncSet getLoadedModules(Env env) {
        return Coerce.toVncSet(env.getGlobalOrNull(new VncSymbol("*loaded-modules*")));
    }

    private VncSet getLoadedFiles(Env env) {
        return Coerce.toVncSet(env.getGlobalOrNull(new VncSymbol("*loaded-files*")));
    }

    private void validateNsAlias(String caller, VncVector aliasOpt) {
        boolean ok;
        boolean bl = ok = !(aliasOpt.size() != 3 || !Types.isVncSymbol(aliasOpt.first()) && !this.isQuotedSymbol(aliasOpt.first()) || !Types.isVncKeyword(aliasOpt.second()) || !"as".equals(Coerce.toVncKeyword(aliasOpt.second()).getValue()) || !Types.isVncSymbol(aliasOpt.third()) && !this.isQuotedSymbol(aliasOpt.third()));
        if (!ok) {
            throw new VncException(String.format("Invalid ns alias definition '%s' for %s!", Printer.pr_str(aliasOpt, true), caller));
        }
    }

    private boolean isQuotedSymbol(VncVal v) {
        VncSequence seq;
        if (Types.isVncSequence(v) && (seq = (VncSequence)v).size() == 2) {
            VncVal v1 = seq.first();
            VncVal v2 = seq.second();
            return Types.isVncSymbol(v1) && "quote".equals(((VncSymbol)v1).getValue()) && Types.isVncSymbol(v2);
        }
        return false;
    }

    private VncSymbol unquoteSymbol(VncVal v) {
        if (Types.isVncSymbol(v)) {
            return (VncSymbol)v;
        }
        if (this.isQuotedSymbol(v)) {
            VncSequence seq = (VncSequence)v;
            return (VncSymbol)seq.second();
        }
        throw new VncException("Invalid namespace alias.");
    }

    private void reportModuleLoad(String moduleName, long elapsed, boolean loaded, boolean force) {
    }
}

