/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.excel;

import com.github.jlangch.venice.impl.util.excel.ColorUtil;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelCellStyles {
    private final Workbook workbook;
    private final Map<String, Font> fonts;
    private final DataFormat dataFormat;
    private final Map<String, CellStyle> cellStyles = new HashMap<String, CellStyle>();

    public ExcelCellStyles(Workbook workbook, Map<String, Font> fonts) {
        this.workbook = workbook;
        this.fonts = fonts;
        this.dataFormat = workbook.createDataFormat();
        this.registerStandardFormats();
    }

    public void registerCellFormat(String name, String dataFormat, String fontRefName, Short bgColorIndex, Boolean wrapText, HorizontalAlignment hAlign, VerticalAlignment vAlign, Short rotation, BorderStyle borderTopStyle, BorderStyle borderRightStyle, BorderStyle borderBottomStyle, BorderStyle borderLeftStyle) {
        Font font;
        if (name == null) {
            throw new IllegalArgumentException("A cell format name must not be null");
        }
        CellStyle style = this.workbook.createCellStyle();
        if (bgColorIndex != null) {
            style.setFillForegroundColor(bgColorIndex.shortValue());
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        if (dataFormat != null) {
            style.setDataFormat(this.dataFormat.getFormat(dataFormat));
        }
        if (fontRefName != null && (font = this.fonts.get(fontRefName)) != null) {
            style.setFont(font);
        }
        if (wrapText != null) {
            style.setWrapText(wrapText.booleanValue());
        }
        if (hAlign != null) {
            style.setAlignment(hAlign);
        }
        if (vAlign != null) {
            style.setVerticalAlignment(vAlign);
        }
        if (rotation != null) {
            style.setRotation(rotation.shortValue());
        }
        if (borderTopStyle != null) {
            style.setBorderTop(borderTopStyle);
        }
        if (borderRightStyle != null) {
            style.setBorderRight(borderRightStyle);
        }
        if (borderBottomStyle != null) {
            style.setBorderBottom(borderBottomStyle);
        }
        if (borderLeftStyle != null) {
            style.setBorderLeft(borderLeftStyle);
        }
        this.cellStyles.put(name, style);
    }

    public void registerCellFormat(String name, String dataFormat, String fontRefName, Color bgColor, Boolean wrapText, HorizontalAlignment hAlign, VerticalAlignment vAlign, Short rotation, BorderStyle borderTopStyle, BorderStyle borderRightStyle, BorderStyle borderBottomStyle, BorderStyle borderLeftStyle) {
        Font font;
        if (name == null) {
            throw new IllegalArgumentException("A cell format name must not be null");
        }
        CellStyle style = this.workbook.createCellStyle();
        if (bgColor != null) {
            if (this.workbook instanceof XSSFWorkbook) {
                ((XSSFCellStyle)style).setFillForegroundColor(new XSSFColor(bgColor, null));
            } else if (this.workbook instanceof HSSFWorkbook) {
                HSSFColor hssfColor = ColorUtil.bestHSSFColor((HSSFWorkbook)this.workbook, bgColor);
                style.setFillForegroundColor(hssfColor.getIndex());
            }
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        if (dataFormat != null) {
            style.setDataFormat(this.dataFormat.getFormat(dataFormat));
        }
        if (fontRefName != null && (font = this.fonts.get(fontRefName)) != null) {
            style.setFont(font);
        }
        if (wrapText != null) {
            style.setWrapText(wrapText.booleanValue());
        }
        if (hAlign != null) {
            style.setAlignment(hAlign);
        }
        if (vAlign != null) {
            style.setVerticalAlignment(vAlign);
        }
        if (rotation != null) {
            style.setRotation(rotation.shortValue());
        }
        if (borderTopStyle != null) {
            style.setBorderTop(borderTopStyle);
        }
        if (borderRightStyle != null) {
            style.setBorderRight(borderRightStyle);
        }
        if (borderBottomStyle != null) {
            style.setBorderBottom(borderBottomStyle);
        }
        if (borderLeftStyle != null) {
            style.setBorderLeft(borderLeftStyle);
        }
        this.cellStyles.put(name, style);
    }

    public CellStyle getCellStyle(String name) {
        return name != null ? this.cellStyles.get(name) : null;
    }

    private void registerStandardFormats() {
        this.getStandardFormats().entrySet().stream().filter(e -> e.getValue() != null).forEach(e -> this.registerCellFormat((String)e.getKey(), (String)e.getValue(), null, (Short)null, null, null, null, null, null, null, null, null));
    }

    private Map<String, String> getStandardFormats() {
        HashMap<String, String> cellDataFormats = new HashMap<String, String>();
        cellDataFormats.put("string", null);
        cellDataFormats.put("boolean", null);
        cellDataFormats.put("integer", "#0");
        cellDataFormats.put("float", "#,##0.00");
        cellDataFormats.put("date", "d.m.yyyy");
        cellDataFormats.put("datetime", "d.m.yyyy hh:mm:ss");
        return cellDataFormats;
    }
}

