/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.dag;

import com.github.jlangch.venice.impl.util.dag.DagCycleException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class Node<T> {
    private final List<Node<T>> parents = new LinkedList<Node<T>>();
    private final List<Node<T>> children = new LinkedList<Node<T>>();
    private final T value;

    public Node(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public List<Node<T>> getParents() {
        return Collections.unmodifiableList(this.parents);
    }

    public List<Node<T>> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void addChild(Node<T> child) {
        if (child == this) {
            throw new DagCycleException(this.toString() + "->" + this.toString());
        }
        this.children.add(child);
        if (!child.getParents().contains(this)) {
            super.addParent(this);
        }
    }

    public boolean isWithoutRelations() {
        return this.parents.isEmpty() && this.children.isEmpty();
    }

    public String toString() {
        return "Node{value=" + this.value.toString() + '}';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public static <T> List<T> toValues(Collection<Node<T>> nodes) {
        return nodes.stream().map(n -> n.getValue()).collect(Collectors.toList());
    }

    private void addParent(Node<T> parent) {
        if (parent == this) {
            throw new DagCycleException(this.toString() + "->" + this.toString());
        }
        this.parents.add(parent);
        if (!parent.getChildren().contains(this)) {
            parent.addChild(this);
        }
    }
}

